/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.enumerations.PdfLockAction;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfByteRangeDocument;
import eu.europa.esig.dss.pades.validation.RevocationInfoArchival;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfMemoryUsageSetting;
import eu.europa.esig.dss.pdf.PdfVriDict;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import eu.europa.esig.dss.signature.resources.InMemoryResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PAdESUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PAdESUtils.class);
    public static final InMemoryResourcesHandlerBuilder DEFAULT_RESOURCES_HANDLER_BUILDER = new InMemoryResourcesHandlerBuilder();
    public static final PdfMemoryUsageSetting DEFAULT_PDF_MEMORY_USAGE_SETTING = PdfMemoryUsageSetting.memoryFull();
    private static final byte[] PDF_PREAMBLE = new byte[]{37, 80, 68, 70, 45};
    private static final byte[] PDF_EOF_STRING = new byte[]{37, 37, 69, 79, 70};

    private PAdESUtils() {
    }

    public static DSSDocument getOriginalPDF(PAdESSignature padesSignature) {
        return PAdESUtils.getOriginalPDF(padesSignature.getPdfRevision());
    }

    public static DSSDocument getOriginalPDF(PdfCMSRevision pdfRevision) {
        return pdfRevision.getPreviousRevision();
    }

    public static DSSDocument getRevisionContent(DSSDocument dssDocument, ByteRange byteRange) {
        Objects.requireNonNull(dssDocument, "DSSDocument cannot be null!");
        Objects.requireNonNull(byteRange, "ByteRange cannot be null!");
        PAdESUtils.assertPdfDocument(dssDocument);
        int beginning = byteRange.getFirstPartStart();
        int endSigValueContent = byteRange.getSecondPartStart();
        int endValue = byteRange.getSecondPartEnd();
        ByteRange revisionByteRange = PAdESUtils.getTwoIntegersByteRange(beginning, endSigValueContent + endValue - beginning);
        return new PdfByteRangeDocument(dssDocument, revisionByteRange);
    }

    public static DSSDocument getPreviousRevision(ByteRange byteRange, Collection<PdfByteRangeDocument> revisions) {
        Objects.requireNonNull(byteRange, "ByteRange cannot be null!");
        Objects.requireNonNull(revisions, "Revisions cannot be null!");
        CommonDocument bestCandidate = null;
        int firstPartLength = byteRange.getFirstPartStart() + byteRange.getFirstPartEnd();
        for (PdfByteRangeDocument byteRangeDocument : revisions) {
            ByteRange currentByteRange = byteRangeDocument.getByteRange();
            if (firstPartLength <= currentByteRange.getLength() || bestCandidate != null && currentByteRange.getLength() <= ((PdfByteRangeDocument)bestCandidate).getByteRange().getLength()) continue;
            bestCandidate = byteRangeDocument;
        }
        return bestCandidate != null ? bestCandidate : InMemoryDocument.createEmptyDocument();
    }

    public static byte[] getSignatureValue(DSSDocument dssDocument, ByteRange byteRange) {
        Objects.requireNonNull(dssDocument, "DSSDocument cannot be null!");
        Objects.requireNonNull(byteRange, "ByteRange cannot be null!");
        PAdESUtils.assertPdfDocument(dssDocument);
        int startSigValueContent = byteRange.getFirstPartStart() + byteRange.getFirstPartEnd() + 1;
        int endSigValueContent = byteRange.getSecondPartStart() - 1;
        PdfByteRangeDocument sigValueDocument = new PdfByteRangeDocument(dssDocument, PAdESUtils.getTwoIntegersByteRange(startSigValueContent, endSigValueContent));
        return Utils.fromHex(new String(DSSUtils.toByteArray(sigValueDocument)));
    }

    /*
     * Exception decompiling
     */
    public static DSSDocument replaceSignature(DSSDocument toBeSignedDocument, byte[] cmsSignedData, DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<PdfByteRangeDocument> extractRevisions(DSSDocument document) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ByteRange getTwoIntegersByteRange(int offset, int position) {
        return new ByteRange(new int[]{offset, position - offset, position, 0});
    }

    public static RevocationInfoArchival getRevocationInfoArchival(ASN1Encodable encodable) {
        if (encodable != null) {
            try {
                return RevocationInfoArchival.getInstance(encodable);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse RevocationInfoArchival", e);
            }
        }
        return null;
    }

    public static boolean isPDFDocument(DSSDocument document) {
        boolean bl;
        block8: {
            InputStream is = document.openStream();
            try {
                bl = Utils.startsWith(is, PDF_PREAMBLE);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException("Cannot read a sequence of bytes from the InputStream.", e);
                }
            }
            is.close();
        }
        return bl;
    }

    public static void assertPdfDocument(DSSDocument document) {
        Objects.requireNonNull(document, "DSSDocument cannot be null!");
        if (document instanceof DigestDocument) {
            throw new IllegalArgumentException("DigestDocument cannot be used! PDF document is expected!");
        }
        if (!PAdESUtils.isPDFDocument(document)) {
            throw new IllegalInputException(String.format("The document with name '%s' is not a PDF. PDF document is expected!", document.getName()));
        }
    }

    public static SigFieldPermissions extractPermissionsDictionary(PdfDict wrapper) {
        Number permissions;
        SigFieldPermissions sigFieldPermissions = new SigFieldPermissions();
        String action = wrapper.getNameValue("Action");
        sigFieldPermissions.setAction(PdfLockAction.forName(action));
        ArrayList<String> fields = new ArrayList<String>();
        PdfArray fieldsArray = wrapper.getAsArray("Fields");
        if (fieldsArray != null) {
            for (int j = 0; j < fieldsArray.size(); ++j) {
                String field = fieldsArray.getString(j);
                if (field == null) continue;
                fields.add(field);
            }
        }
        sigFieldPermissions.setFields(fields);
        if ("SigFieldLock".equals(wrapper.getNameValue("Type")) && (permissions = wrapper.getNumberValue("P")) != null) {
            CertificationPermission certificationPermission = CertificationPermission.fromCode(permissions.intValue());
            sigFieldPermissions.setCertificationPermission(certificationPermission);
        }
        return sigFieldPermissions;
    }

    public static List<PdfVriDict> getVRIsWithName(PdfDssDict pdfDssDict, String vriName) {
        List<PdfVriDict> vris = pdfDssDict.getVRIs();
        if (Utils.isCollectionEmpty(vris)) {
            return Collections.emptyList();
        }
        if (vriName == null) {
            return vris;
        }
        for (PdfVriDict vriDict : vris) {
            if (!vriName.equals(vriDict.getName())) continue;
            return Collections.singletonList(vriDict);
        }
        return Collections.emptyList();
    }

    public static DSSResourcesHandler initializeDSSResourcesHandler() {
        return DEFAULT_RESOURCES_HANDLER_BUILDER.createResourcesHandler();
    }
}

