/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.timedependent;

import eu.europa.esig.dss.model.timedependent.TimeDependent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TimeDependentValues<T extends TimeDependent>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -5066393438144711346L;
    protected final List<T> list = new LinkedList<T>();
    private final List<T> immutableList = Collections.unmodifiableList(this.list);

    public TimeDependentValues() {
    }

    public TimeDependentValues(Iterable<T> srcList) {
        for (TimeDependent x : srcList) {
            this.list.add(x);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.immutableList.iterator();
    }

    public T getLatest() {
        return (T)(this.list.isEmpty() ? null : (TimeDependent)this.list.get(0));
    }

    public T getCurrent(Date d) {
        for (TimeDependent x : this.list) {
            Date endDate;
            if (x.getStartDate().compareTo(d) > 0 || (endDate = x.getEndDate()) != null && endDate.compareTo(d) <= 0) continue;
            return (T)x;
        }
        return null;
    }

    public List<T> getAfter(Date notBefore) {
        ArrayList<TimeDependent> result = new ArrayList<TimeDependent>();
        for (TimeDependent x : this.list) {
            Date endDate = x.getEndDate();
            if (endDate != null && endDate.compareTo(notBefore) < 0) continue;
            result.add(x);
        }
        return result;
    }

    public String toString() {
        return this.list.toString();
    }
}

