/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.timedependent;

import eu.europa.esig.dss.model.timedependent.TimeDependent;
import eu.europa.esig.dss.model.timedependent.TimeDependentValues;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class MutableTimeDependentValues<T extends TimeDependent>
extends TimeDependentValues<T> {
    private static final long serialVersionUID = -7260622365917872977L;

    public MutableTimeDependentValues() {
    }

    public MutableTimeDependentValues(Iterable<T> srcList) {
        super(srcList);
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized void addOldest(T x) {
        Date endDate;
        Objects.requireNonNull(x, "Cannot add null");
        if (!this.list.isEmpty() && (endDate = x.getEndDate()) != null) {
            for (TimeDependent y : this.list) {
                if (y.getStartDate() == null || endDate.compareTo(y.getStartDate()) <= 0) continue;
                throw new IllegalArgumentException("Cannot add overlapping item");
            }
        }
        this.list.add(x);
    }

    public List<T> getList() {
        return this.list;
    }
}

