/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.policy.crypto;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteAlgorithm;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteEvaluation;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteMetadata;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CryptographicSuite19322
implements CryptographicSuite {
    private final CryptographicSuiteMetadata metadata;
    private final List<CryptographicSuiteAlgorithm> algorithmList;
    private Level globalLevel = Level.FAIL;
    private Level acceptableSignatureAlgorithmsLevel;
    private Level acceptableSignatureAlgorithmsMinKeySizeLevel;
    private Level acceptableDigestAlgorithmsLevel;
    private Level algorithmsExpirationDateLevel;
    private Level algorithmsExpirationTimeAfterPolicyUpdateLevel = Level.WARN;
    private Map<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> acceptableDigestAlgorithms;
    private Map<SignatureAlgorithm, Set<CryptographicSuiteEvaluation>> acceptableSignatureAlgorithms;

    public CryptographicSuite19322(CryptographicSuiteMetadata metadata, List<CryptographicSuiteAlgorithm> algorithmList) {
        Objects.requireNonNull(metadata, "metadata cannot be null!");
        Objects.requireNonNull(algorithmList, "algorithmList cannot be null!");
        this.metadata = metadata;
        this.algorithmList = algorithmList;
    }

    @Override
    public String getPolicyName() {
        return this.metadata.getPolicyName();
    }

    @Override
    public Date getCryptographicSuiteUpdateDate() {
        return this.metadata.getPolicyIssueDate();
    }

    @Override
    public Level getLevel() {
        return this.globalLevel;
    }

    @Override
    public void setLevel(Level level) {
        this.globalLevel = level;
    }

    @Override
    public Level getAcceptableDigestAlgorithmsLevel() {
        return this.getLevel(this.acceptableDigestAlgorithmsLevel);
    }

    @Override
    public void setAcceptableDigestAlgorithmsLevel(Level acceptableDigestAlgorithmsLevel) {
        this.acceptableDigestAlgorithmsLevel = acceptableDigestAlgorithmsLevel;
    }

    @Override
    public Level getAcceptableSignatureAlgorithmsLevel() {
        return this.getLevel(this.acceptableSignatureAlgorithmsLevel);
    }

    @Override
    public void setAcceptableSignatureAlgorithmsLevel(Level acceptableSignatureAlgorithmsLevel) {
        this.acceptableSignatureAlgorithmsLevel = acceptableSignatureAlgorithmsLevel;
    }

    @Override
    public Level getAcceptableSignatureAlgorithmsMiniKeySizeLevel() {
        return this.getLevel(this.acceptableSignatureAlgorithmsMinKeySizeLevel);
    }

    @Override
    public void setAcceptableSignatureAlgorithmsMiniKeySizeLevel(Level acceptableSignatureAlgorithmsMiniKeySizeLevel) {
        this.acceptableSignatureAlgorithmsMinKeySizeLevel = acceptableSignatureAlgorithmsMiniKeySizeLevel;
    }

    @Override
    public Level getAlgorithmsExpirationDateLevel() {
        return this.getLevel(this.algorithmsExpirationDateLevel);
    }

    @Override
    public void setAlgorithmsExpirationDateLevel(Level algorithmsExpirationDateLevel) {
        this.algorithmsExpirationDateLevel = algorithmsExpirationDateLevel;
    }

    @Override
    public Level getAlgorithmsExpirationDateAfterUpdateLevel() {
        return this.algorithmsExpirationTimeAfterPolicyUpdateLevel;
    }

    @Override
    public void setAlgorithmsExpirationTimeAfterPolicyUpdateLevel(Level algorithmsExpirationTimeAfterPolicyUpdateLevel) {
        this.algorithmsExpirationTimeAfterPolicyUpdateLevel = algorithmsExpirationTimeAfterPolicyUpdateLevel;
    }

    private Level getLevel(Level level) {
        return level != null ? level : this.globalLevel;
    }

    @Override
    public Map<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> getAcceptableDigestAlgorithms() {
        if (this.acceptableDigestAlgorithms == null) {
            this.acceptableDigestAlgorithms = new EnumMap<DigestAlgorithm, Set<CryptographicSuiteEvaluation>>(DigestAlgorithm.class);
            for (CryptographicSuiteAlgorithm algorithm : this.algorithmList) {
                DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm(algorithm);
                if (digestAlgorithm == null) continue;
                this.acceptableDigestAlgorithms.computeIfAbsent(digestAlgorithm, v -> new HashSet()).addAll(algorithm.getEvaluationList());
            }
        }
        return this.acceptableDigestAlgorithms;
    }

    private DigestAlgorithm getDigestAlgorithm(CryptographicSuiteAlgorithm algorithm) {
        List<String> uris;
        if (algorithm == null) {
            return null;
        }
        List<String> objectIdentifiers = algorithm.getAlgorithmIdentifierOIDs();
        if (objectIdentifiers != null && !objectIdentifiers.isEmpty()) {
            for (String oid : objectIdentifiers) {
                try {
                    return DigestAlgorithm.forOID(oid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        if ((uris = algorithm.getAlgorithmIdentifierURIs()) != null && !uris.isEmpty()) {
            for (String uri : uris) {
                try {
                    return DigestAlgorithm.forXML(uri);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    @Override
    public Map<SignatureAlgorithm, Set<CryptographicSuiteEvaluation>> getAcceptableSignatureAlgorithms() {
        if (this.acceptableSignatureAlgorithms == null) {
            this.acceptableSignatureAlgorithms = new EnumMap<SignatureAlgorithm, Set<CryptographicSuiteEvaluation>>(SignatureAlgorithm.class);
            for (CryptographicSuiteAlgorithm algorithm : this.algorithmList) {
                SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm(algorithm);
                if (signatureAlgorithm == null) continue;
                this.acceptableSignatureAlgorithms.computeIfAbsent(signatureAlgorithm, v -> new HashSet()).addAll(algorithm.getEvaluationList());
            }
            Map<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> digestAlgorithmsMap = this.getAcceptableDigestAlgorithms();
            EnumMap<SignatureAlgorithm, Set> tempMap = new EnumMap<SignatureAlgorithm, Set>(SignatureAlgorithm.class);
            for (CryptographicSuiteAlgorithm cryptographicSuiteAlgorithm : this.algorithmList) {
                EncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm(cryptographicSuiteAlgorithm);
                if (encryptionAlgorithm == null) continue;
                for (Map.Entry<DigestAlgorithm, Set<CryptographicSuiteEvaluation>> entry : digestAlgorithmsMap.entrySet()) {
                    SignatureAlgorithm signatureAlgorithm = this.findSignatureAlgorithm(encryptionAlgorithm, entry.getKey());
                    if (signatureAlgorithm == null || this.acceptableSignatureAlgorithms.containsKey(signatureAlgorithm)) continue;
                    HashSet<CryptographicSuiteEvaluation> finalEvaluationList = new HashSet<CryptographicSuiteEvaluation>();
                    for (CryptographicSuiteEvaluation evaluation : cryptographicSuiteAlgorithm.getEvaluationList()) {
                        for (CryptographicSuiteEvaluation digestAlgoEvaluation : entry.getValue()) {
                            Date digestAlgoValidityEnd;
                            evaluation = CryptographicSuiteEvaluation.copy(evaluation);
                            Date digestAlgoValidityStart = digestAlgoEvaluation.getValidityStart();
                            if (digestAlgoValidityStart != null && (evaluation.getValidityStart() == null || digestAlgoValidityStart.after(evaluation.getValidityStart()))) {
                                evaluation.setValidityStart(digestAlgoValidityStart);
                            }
                            if ((digestAlgoValidityEnd = digestAlgoEvaluation.getValidityEnd()) != null && (evaluation.getValidityEnd() == null || digestAlgoValidityEnd.before(evaluation.getValidityEnd()))) {
                                evaluation.setValidityEnd(digestAlgoValidityEnd);
                            }
                            if (evaluation.getValidityStart() != null && evaluation.getValidityEnd() != null && !evaluation.getValidityStart().before(evaluation.getValidityEnd())) continue;
                            finalEvaluationList.add(evaluation);
                        }
                    }
                    tempMap.computeIfAbsent(signatureAlgorithm, v -> new HashSet()).addAll(finalEvaluationList);
                }
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                this.acceptableSignatureAlgorithms.computeIfAbsent((SignatureAlgorithm)entry.getKey(), v -> new HashSet()).addAll((Collection)entry.getValue());
            }
        }
        return this.acceptableSignatureAlgorithms;
    }

    private SignatureAlgorithm getSignatureAlgorithm(CryptographicSuiteAlgorithm algorithm) {
        List<String> uris;
        if (algorithm == null) {
            return null;
        }
        List<String> objectIdentifiers = algorithm.getAlgorithmIdentifierOIDs();
        if (objectIdentifiers != null && !objectIdentifiers.isEmpty()) {
            for (String oid : objectIdentifiers) {
                try {
                    EncryptionAlgorithm encryptionAlgorithm;
                    SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID(oid);
                    if (signatureAlgorithm == null || (encryptionAlgorithm = this.getEncryptionAlgorithm(algorithm)) != null) continue;
                    return signatureAlgorithm;
                }
                catch (IllegalArgumentException signatureAlgorithm) {
                }
            }
        }
        if ((uris = algorithm.getAlgorithmIdentifierURIs()) != null && !uris.isEmpty()) {
            for (String uri : uris) {
                try {
                    SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forXML(uri);
                    if (signatureAlgorithm == null) continue;
                    return signatureAlgorithm;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    private EncryptionAlgorithm getEncryptionAlgorithm(CryptographicSuiteAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        List<String> objectIdentifiers = algorithm.getAlgorithmIdentifierOIDs();
        if (objectIdentifiers != null && !objectIdentifiers.isEmpty()) {
            for (String oid : objectIdentifiers) {
                try {
                    return EncryptionAlgorithm.forOID(oid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return null;
    }

    private SignatureAlgorithm findSignatureAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        return SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm);
    }
}

