/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.extension;

import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignatureProfile;
import eu.europa.esig.dss.extension.SignedDocumentExtender;
import eu.europa.esig.dss.model.AbstractSerializableSignatureParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentExtender<SP extends AbstractSignatureParameters<?>, TP extends TimestampParameters>
extends SignedDocumentExtender {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDocumentExtender.class);
    private static final SerializableSignatureParameters[] EMPTY_PARAMETERS = new SerializableSignatureParameters[0];
    protected DSSDocument document;

    protected AbstractDocumentExtender() {
    }

    @Override
    public DSSDocument extendDocument(SignatureProfile signatureProfile) {
        return this.extendDocument(signatureProfile, Collections.emptyList());
    }

    @Override
    public DSSDocument extendDocument(SignatureProfile signatureProfile, List<DSSDocument> detachedContents) {
        return this.extendDocument(signatureProfile, detachedContents, EMPTY_PARAMETERS);
    }

    @Override
    public DSSDocument extendDocument(SignatureProfile signatureProfile, SerializableSignatureParameters ... extensionParameters) {
        return this.extendDocument(signatureProfile, Collections.emptyList(), extensionParameters);
    }

    @Override
    public DSSDocument extendDocument(SignatureProfile signatureProfile, List<DSSDocument> detachedContents, SerializableSignatureParameters ... extensionParameters) {
        Objects.requireNonNull(this.document, "Document is not provided to the extender");
        Objects.requireNonNull(signatureProfile, "SignatureProfile cannot be null!");
        DocumentSignatureService<SP, TP> service = this.initSignatureService();
        SP parameters = this.initSignatureParameters(signatureProfile, detachedContents, extensionParameters);
        return service.extendDocument(this.document, parameters);
    }

    protected DocumentSignatureService<SP, TP> initSignatureService() {
        if (Utils.isArrayNotEmpty(this.services)) {
            for (DocumentSignatureService service : this.services) {
                if (!this.isSupportedService(service)) continue;
                return service;
            }
        }
        return this.createSignatureService();
    }

    protected abstract DocumentSignatureService<SP, TP> createSignatureService();

    protected abstract boolean isSupportedService(DocumentSignatureService<?, ?> var1);

    protected SP initSignatureParameters(SignatureProfile signatureProfile, List<DSSDocument> detachedContents, SerializableSignatureParameters ... extensionParameters) {
        SP signatureParameters = this.getFromProvidedParameters(extensionParameters);
        return this.fillSignatureParameters(signatureParameters, signatureProfile, detachedContents);
    }

    private SP getFromProvidedParameters(SerializableSignatureParameters ... explicitParameters) {
        if (Utils.isArrayNotEmpty(explicitParameters)) {
            for (SerializableSignatureParameters parameters : explicitParameters) {
                if (!this.isSupportedParameters(parameters)) continue;
                return (SP)((AbstractSignatureParameters)parameters);
            }
        }
        return this.emptySignatureParameters();
    }

    protected abstract SP emptySignatureParameters();

    protected abstract boolean isSupportedParameters(SerializableSignatureParameters var1);

    protected SP fillSignatureParameters(SP signatureParameters, SignatureProfile signatureProfile, List<DSSDocument> detachedContents) {
        if (((AbstractSerializableSignatureParameters)signatureParameters).getSignatureLevel() == null) {
            ((AbstractSerializableSignatureParameters)signatureParameters).setSignatureLevel(this.getSignatureLevel(signatureProfile));
        } else if (signatureProfile != ((AbstractSerializableSignatureParameters)signatureParameters).getSignatureLevel().getSignatureProfile()) {
            LOG.info("Signature level '{}' defined within the applicable signature parameters does not match the target signature profile '{}'. The signature level from signature parameters is used.", (Object)((AbstractSerializableSignatureParameters)signatureParameters).getSignatureLevel(), (Object)signatureProfile);
        }
        if (Utils.isCollectionEmpty(((AbstractSignatureParameters)signatureParameters).getDetachedContents())) {
            ((AbstractSignatureParameters)signatureParameters).setDetachedContents(detachedContents);
        }
        return signatureParameters;
    }

    protected SignatureLevel getSignatureLevel(SignatureProfile signatureProfile) {
        Objects.requireNonNull(signatureProfile, "SignatureProfile cannot be null!");
        SignatureForm signatureForm = this.getSignatureForm();
        SignatureLevel signatureLevel = SignatureLevel.getSignatureLevel(signatureForm, signatureProfile);
        if (signatureLevel == null) {
            throw new IllegalArgumentException(String.format("No SignatureLevel found for the given SignatureForm '%s' and SignatureProfile '%s'.", signatureForm.name(), signatureProfile.name()));
        }
        return signatureLevel;
    }
}

