/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.EvidenceRecordProductionComparator;
import eu.europa.esig.dss.cades.TimeStampTokenProductionComparator;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSigProperties;
import eu.europa.esig.dss.enumerations.TimestampType;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.tsp.EvidenceRecord;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;

public class CAdESUnsignedAttributes
extends CAdESSigProperties {
    private static final long serialVersionUID = -2908905249481936152L;

    CAdESUnsignedAttributes(ASN1Set asn1Set) {
        super(asn1Set);
    }

    public static CAdESUnsignedAttributes build(SignerInformation signerInformation) {
        return new CAdESUnsignedAttributes(signerInformation.toASN1Structure().getUnauthenticatedAttributes());
    }

    @Override
    public List<CAdESAttribute> getAttributes() {
        List<CAdESAttribute> attributes = super.getAttributes();
        return this.sortAttributes(attributes);
    }

    private List<CAdESAttribute> sortAttributes(List<CAdESAttribute> attributes) {
        CAdESAttributeTimeStampComparator comparator = new CAdESAttributeTimeStampComparator();
        for (int ii = 0; ii < attributes.size() - 1; ++ii) {
            for (int jj = 0; jj < attributes.size() - ii - 1; ++jj) {
                CAdESAttribute nextCAdESAttribute;
                CAdESAttribute cadesAttribute = attributes.get(jj);
                if (comparator.compare(cadesAttribute, nextCAdESAttribute = attributes.get(jj + 1)) <= 0) continue;
                Collections.swap(attributes, jj, jj + 1);
            }
        }
        return attributes;
    }

    private static final class CAdESAttributeTimeStampComparator
    implements Comparator<CAdESAttribute>,
    Serializable {
        private static final long serialVersionUID = -603149548378907782L;

        private CAdESAttributeTimeStampComparator() {
        }

        @Override
        public int compare(CAdESAttribute o1, CAdESAttribute o2) {
            int result = this.compareByType(o1, o2);
            if (result == 0) {
                result = this.compareByTimeStampToken(o1, o2);
            }
            if (result == 0) {
                result = this.compareByTimestampType(o1, o2);
            }
            if (result == 0) {
                result = this.compareByEvidenceRecord(o1, o2);
            }
            return result;
        }

        private int compareByType(CAdESAttribute attributeOne, CAdESAttribute attributeTwo) {
            if (!attributeOne.isEvidenceRecord() && attributeTwo.isEvidenceRecord()) {
                return -1;
            }
            if (attributeOne.isEvidenceRecord() && !attributeTwo.isEvidenceRecord()) {
                return 1;
            }
            if (!attributeOne.isTimeStampToken() && attributeTwo.isTimeStampToken()) {
                return -1;
            }
            if (attributeOne.isTimeStampToken() && !attributeTwo.isTimeStampToken()) {
                return 1;
            }
            return 0;
        }

        private int compareByTimeStampToken(CAdESAttribute attributeOne, CAdESAttribute attributeTwo) {
            TimeStampToken next;
            TimeStampToken current = attributeOne.isTimeStampToken() ? attributeOne.toTimeStampToken() : null;
            TimeStampToken timeStampToken = next = attributeTwo.isTimeStampToken() ? attributeTwo.toTimeStampToken() : null;
            if (current != null && next != null) {
                TimeStampTokenProductionComparator comparator = new TimeStampTokenProductionComparator();
                return comparator.compare(current, next);
            }
            return 0;
        }

        private int compareByTimestampType(CAdESAttribute attributeOne, CAdESAttribute attributeTwo) {
            TimestampType timestampTypeOne = attributeOne.getTimestampTokenType();
            TimestampType timestampTypeTwo = attributeTwo.getTimestampTokenType();
            if (timestampTypeOne != null && timestampTypeTwo != null) {
                return timestampTypeOne.compare(timestampTypeTwo);
            }
            return 0;
        }

        private int compareByEvidenceRecord(CAdESAttribute attributeOne, CAdESAttribute attributeTwo) {
            EvidenceRecord evidenceRecordTwo;
            EvidenceRecord evidenceRecordOne = attributeOne.isEvidenceRecord() ? attributeOne.toEvidenceRecord() : null;
            EvidenceRecord evidenceRecord = evidenceRecordTwo = attributeTwo.isEvidenceRecord() ? attributeTwo.toEvidenceRecord() : null;
            if (evidenceRecordOne != null && evidenceRecordTwo != null) {
                EvidenceRecordProductionComparator comparator = new EvidenceRecordProductionComparator();
                return comparator.compare(evidenceRecordOne, evidenceRecordTwo);
            }
            return 0;
        }
    }
}

