/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.extension;

import eu.europa.esig.dss.asic.xades.ASiCWithXAdESFormatDetector;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESService;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.extension.AbstractDocumentExtender;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import java.util.Objects;

public class ASiCWithXAdESDocumentExtender
extends AbstractDocumentExtender<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> {
    ASiCWithXAdESDocumentExtender() {
    }

    public ASiCWithXAdESDocumentExtender(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be extended cannot be null!");
        this.document = document;
    }

    @Override
    protected DocumentSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> createSignatureService() {
        Objects.requireNonNull(this.certificateVerifier, "Please provide CertificateVerifier or corresponding ASiCWithXAdESService!");
        ASiCWithXAdESService service = new ASiCWithXAdESService(this.certificateVerifier);
        service.setTspSource(this.tspSource);
        return service;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return new ASiCWithXAdESFormatDetector().isSupportedASiC(dssDocument);
    }

    @Override
    protected ASiCWithXAdESSignatureParameters emptySignatureParameters() {
        return new ASiCWithXAdESSignatureParameters();
    }

    @Override
    protected boolean isSupportedParameters(SerializableSignatureParameters parameters) {
        return parameters instanceof ASiCWithXAdESSignatureParameters;
    }

    @Override
    protected boolean isSupportedService(DocumentSignatureService<?, ?> service) {
        return service instanceof ASiCWithXAdESService;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.XAdES;
    }

    @Override
    public boolean isASiC() {
        return true;
    }
}

