/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail.disposable;

import com.sanctionco.jmail.disposable.HttpClient;
import com.sanctionco.jmail.disposable.InputStreamSource;
import com.sanctionco.jmail.disposable.IsTempMailAPISource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public interface DisposableDomainSource {
    public boolean isDisposableDomain(String var1);

    public static DisposableDomainSource file(String path) throws IOException {
        try (InputStream in = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            InputStreamSource inputStreamSource = new InputStreamSource(in);
            return inputStreamSource;
        }
    }

    public static DisposableDomainSource inputStream(InputStream inputStream) throws IOException {
        return new InputStreamSource(inputStream);
    }

    public static DisposableDomainSource isTempMailAPI(String apiKey) {
        return new IsTempMailAPISource(new HttpClient(), apiKey);
    }
}

