/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.fontlist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.tools.fontlist.FontSpec;
import org.apache.fop.util.GenerationHelperContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FontListSerializer {
    private static final String FONTS = "fonts";
    private static final String FAMILY = "family";
    private static final String FONT = "font";
    private static final String TRIPLETS = "triplets";
    private static final String TRIPLET = "triplet";
    private static final String NAME = "name";
    private static final String STRIPPED_NAME = "stripped-name";
    private static final String TYPE = "type";
    private static final String KEY = "key";
    private static final String STYLE = "style";
    private static final String WEIGHT = "weight";
    private static final String CDATA = "CDATA";
    private final Pattern quotePattern = Pattern.compile("'");

    public void generateSAX(SortedMap fontFamilies, GenerationHelperContentHandler handler) throws SAXException {
        this.generateSAX(fontFamilies, null, handler);
    }

    public void generateSAX(SortedMap fontFamilies, String singleFamily, GenerationHelperContentHandler handler) throws SAXException {
        handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        handler.startElement(FONTS, (Attributes)atts);
        Iterator iterator2 = fontFamilies.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator2.next();
            String familyName = (String)entry.getKey();
            if (singleFamily != null && !singleFamily.equals(familyName)) continue;
            atts.clear();
            atts.addAttribute("", NAME, NAME, CDATA, familyName);
            atts.addAttribute("", STRIPPED_NAME, STRIPPED_NAME, CDATA, this.stripQuotes(familyName));
            handler.startElement(FAMILY, (Attributes)atts);
            List containers = (List)entry.getValue();
            this.generateXMLForFontContainers(handler, containers);
            handler.endElement(FAMILY);
        }
        handler.endElement(FONTS);
        handler.endDocument();
    }

    private String stripQuotes(String name) {
        return this.quotePattern.matcher(name).replaceAll("");
    }

    private void generateXMLForFontContainers(GenerationHelperContentHandler handler, List containers) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        for (Object container : containers) {
            FontSpec cont = (FontSpec)container;
            atts.clear();
            atts.addAttribute("", KEY, KEY, CDATA, cont.getKey());
            atts.addAttribute("", TYPE, TYPE, CDATA, cont.getFontMetrics().getFontType().getName());
            handler.startElement(FONT, (Attributes)atts);
            this.generateXMLForTriplets(handler, cont.getTriplets());
            handler.endElement(FONT);
        }
    }

    private void generateXMLForTriplets(GenerationHelperContentHandler handler, Collection triplets) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        handler.startElement(TRIPLETS, (Attributes)atts);
        for (Object triplet1 : triplets) {
            FontTriplet triplet = (FontTriplet)triplet1;
            atts.clear();
            atts.addAttribute("", NAME, NAME, CDATA, triplet.getName());
            atts.addAttribute("", STYLE, STYLE, CDATA, triplet.getStyle());
            atts.addAttribute("", WEIGHT, WEIGHT, CDATA, Integer.toString(triplet.getWeight()));
            handler.element(TRIPLET, (Attributes)atts);
        }
        handler.endElement(TRIPLETS);
    }
}

