/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.eventtools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.fop.events.model.EventModel;
import org.apache.fop.events.model.EventProducerModel;
import org.apache.fop.eventtools.EventConventionException;
import org.apache.fop.eventtools.EventProducerCollector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.w3c.dom.Node;

public class EventProducerCollectorTask
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private File destDir;
    private File translationFile;
    private static final String MODEL2TRANSLATION = "model2translation.xsl";
    private static final String MERGETRANSLATION = "merge-translation.xsl";

    public void execute() throws BuildException {
        try {
            EventProducerCollector collector = new EventProducerCollector();
            long lastModified = this.processFileSets(collector);
            for (EventModel model : collector.getModels()) {
                File parentDir = this.getParentDir(model);
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new BuildException("Could not create target directory for event model file: " + parentDir);
                }
                File modelFile = new File(parentDir, "event-model.xml");
                if (!modelFile.exists() || lastModified > modelFile.lastModified()) {
                    model.saveToXML(modelFile);
                    this.log("Event model written to " + modelFile);
                }
                if (this.getTranslationFile() == null || this.getTranslationFile().exists() && lastModified <= this.getTranslationFile().lastModified()) continue;
                this.updateTranslationFile(modelFile);
            }
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (EventConventionException ece) {
            throw new BuildException((Throwable)ece);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    private File getParentDir(EventModel model) {
        Iterator iter = model.getProducers();
        assert (iter.hasNext());
        EventProducerModel producer = (EventProducerModel)iter.next();
        assert (!iter.hasNext());
        String interfaceName = producer.getInterfaceName();
        int startLocalName = interfaceName.lastIndexOf(".");
        if (startLocalName < 0) {
            return this.destDir;
        }
        String dirname = interfaceName.substring(0, startLocalName);
        dirname = dirname.replace('.', File.separatorChar);
        return new File(this.destDir, dirname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTranslationFile(File modelFile) throws IOException {
        try {
            Node sourceDocument;
            boolean resultExists = this.getTranslationFile().exists();
            SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            Source src = new StreamSource(modelFile.toURI().toURL().toExternalForm());
            StreamSource xslt1 = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(MODEL2TRANSLATION));
            if (xslt1.getInputStream() == null) {
                throw new FileNotFoundException("model2translation.xsl not found");
            }
            DOMResult domres = new DOMResult();
            Transformer transformer = tFactory.newTransformer(xslt1);
            transformer.transform(src, domres);
            final Node generated = domres.getNode();
            if (resultExists) {
                src = new StreamSource(this.getTranslationFile().toURI().toURL().toExternalForm());
                domres = new DOMResult();
                transformer = tFactory.newTransformer();
                transformer.transform(src, domres);
                sourceDocument = domres.getNode();
            } else {
                sourceDocument = generated;
            }
            src = new DOMSource(sourceDocument);
            OutputStream out = new FileOutputStream(this.getTranslationFile());
            out = new BufferedOutputStream(out);
            StreamResult res = new StreamResult(out);
            try {
                StreamSource xslt2 = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(MERGETRANSLATION));
                if (xslt2.getInputStream() == null) {
                    throw new FileNotFoundException("merge-translation.xsl not found");
                }
                transformer = tFactory.newTransformer(xslt2);
                transformer.setURIResolver(new URIResolver(){

                    @Override
                    public Source resolve(String href, String base) throws TransformerException {
                        if ("my:dom".equals(href)) {
                            return new DOMSource(generated);
                        }
                        return null;
                    }
                });
                if (resultExists) {
                    transformer.setParameter("generated-url", "my:dom");
                }
                transformer.transform(src, res);
                if (resultExists) {
                    this.log("Translation file updated: " + this.getTranslationFile());
                } else {
                    this.log("Translation file generated: " + this.getTranslationFile());
                }
            }
            finally {
                IOUtils.closeQuietly(out);
            }
        }
        catch (TransformerException te) {
            throw new IOException(te.getMessage());
        }
    }

    protected long processFileSets(EventProducerCollector collector) throws IOException, EventConventionException, ClassNotFoundException {
        long lastModified = 0L;
        for (FileSet fs : this.filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            File directory = fs.getDir(this.getProject());
            for (String filename : srcFiles) {
                File src = new File(directory, filename);
                boolean eventProducerFound = collector.scanFile(src);
                if (!eventProducerFound) continue;
                lastModified = Math.max(lastModified, src.lastModified());
            }
        }
        return lastModified;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setDestDir(File destDir) {
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("destDir must be a directory");
        }
        this.destDir = destDir;
    }

    public void setTranslationFile(File f) {
        this.translationFile = f;
    }

    public File getTranslationFile() {
        return this.translationFile;
    }

    public static void main(String[] args2) {
        try {
            Project project = new Project();
            EventProducerCollectorTask generator = new EventProducerCollectorTask();
            generator.setProject(project);
            project.setName("Test");
            FileSet fileset = new FileSet();
            fileset.setDir(new File("test/java"));
            FilenameSelector selector = new FilenameSelector();
            selector.setName("**/*.java");
            fileset.add((FileSelector)selector);
            generator.addFileset(fileset);
            File targetDir = new File("build/codegen1");
            targetDir.mkdirs();
            generator.setTranslationFile(new File("out1.xml"));
            generator.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

