/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.jades;

import eu.europa.esig.jws.AbstractJWSUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJAdESUtils
extends AbstractJWSUtils {
    protected static final String RFC7519_SCHEMA_LOCATION = "/schema/rfcs/rfc7519.json";
    protected static final String RFC7519_SCHEMA_URI = "rfc7519.json";
    protected static final String RFC7797_SCHEMA_LOCATION = "/schema/rfcs/rfc7797.json";
    protected static final String RFC7797_SCHEMA_URI = "rfc7797.json";
    protected static final String RFC_SUBDIRECTORY = "rfcs/";
    protected static final String JAdES_SCHEMA_DEFINITIONS_URI = "19182-jsonSchema.json";
    protected static final String JAdES_SCHEMA_DEFINITIONS_LOCATION = "/schema/19182-jsonSchema.json";

    protected AbstractJAdESUtils() {
    }

    @Override
    public Map<URI, String> getRFCDefinitions() {
        HashMap<URI, String> definitions = new HashMap<URI, String>();
        Map<URI, String> rfcDefinitions = super.getRFCDefinitions();
        for (Map.Entry<URI, String> entry : rfcDefinitions.entrySet()) {
            definitions.put(URI.create(RFC_SUBDIRECTORY + entry.getKey().toString()), entry.getValue());
        }
        definitions.put(URI.create("rfcs/rfc7519.json"), RFC7519_SCHEMA_LOCATION);
        definitions.put(URI.create("rfcs/rfc7797.json"), RFC7797_SCHEMA_LOCATION);
        return definitions;
    }

    @Override
    public Map<URI, String> getSchemaDefinitions() {
        Map<URI, String> definitions = this.getJSONSchemaDefinitions();
        definitions.putAll(this.getRFCDefinitions());
        definitions.put(URI.create(JAdES_SCHEMA_DEFINITIONS_URI), JAdES_SCHEMA_DEFINITIONS_LOCATION);
        return definitions;
    }
}

