/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.math.BigInteger;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class XAdESRevocationRefExtractionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESRevocationRefExtractionUtils.class);

    private XAdESRevocationRefExtractionUtils() {
    }

    public static OCSPRef createOCSPRef(XAdESPath xadesPaths, Element ocspRefElement) {
        Digest digest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement(ocspRefElement, xadesPaths.getCurrentDigestAlgAndValue()));
        ResponderId responderId = XAdESRevocationRefExtractionUtils.getOCSPResponderId(xadesPaths, ocspRefElement);
        if (responderId == null) {
            LOG.warn("Skipped OCSPRef (missing OCSPIdentifier / ResponderID)");
            return null;
        }
        Date producedAtDate = XAdESRevocationRefExtractionUtils.getOCSPProducedAtDate(xadesPaths, ocspRefElement);
        if (producedAtDate == null) {
            LOG.warn("Skipped OCSPRef (missing OCSPIdentifier / ProducedAt)");
            return null;
        }
        return new OCSPRef(digest, producedAtDate, responderId);
    }

    private static Date getOCSPProducedAtDate(XAdESPath xadesPaths, Element ocspRefElement) {
        Date producedAtDate = null;
        Element producedAtEl = DomUtils.getElement(ocspRefElement, xadesPaths.getCurrentOCSPRefProducedAt());
        if (producedAtEl != null) {
            producedAtDate = DomUtils.getDate(producedAtEl.getTextContent());
        }
        return producedAtDate;
    }

    private static ResponderId getOCSPResponderId(XAdESPath xadesPaths, Element ocspRefElement) {
        X500Principal responderName = null;
        byte[] ski = null;
        String currentOCSPRefResponderIDByName = xadesPaths.getCurrentOCSPRefResponderIDByName();
        String currentOCSPRefResponderIDByKey = xadesPaths.getCurrentOCSPRefResponderIDByKey();
        if (currentOCSPRefResponderIDByName != null && currentOCSPRefResponderIDByKey != null) {
            Element responderIdByKey;
            Element responderIdByName = DomUtils.getElement(ocspRefElement, currentOCSPRefResponderIDByName);
            if (responderIdByName != null) {
                responderName = DSSASN1Utils.getX500PrincipalOrNull(responderIdByName.getTextContent());
            }
            if ((responderIdByKey = DomUtils.getElement(ocspRefElement, currentOCSPRefResponderIDByKey)) != null) {
                String base64EncodedResponderId = responderIdByKey.getTextContent();
                if (Utils.isBase64Encoded(base64EncodedResponderId)) {
                    ski = Utils.fromBase64(base64EncodedResponderId);
                } else {
                    LOG.warn("OCSP ResponderId value is not represented by a base64-encoded string!");
                }
            }
        } else {
            Element responderIdElement = DomUtils.getElement(ocspRefElement, xadesPaths.getCurrentOCSPRefResponderID());
            if (responderIdElement != null) {
                responderName = DSSASN1Utils.getX500PrincipalOrNull(responderIdElement.getTextContent());
            }
        }
        if (responderName != null || Utils.isArrayNotEmpty(ski)) {
            return new ResponderId(responderName, ski);
        }
        return null;
    }

    public static CRLRef createCRLRef(XAdESPath xadesPaths, Element crlRefElement) {
        Digest digest = DSSXMLUtils.getDigestAndValue(DomUtils.getElement(crlRefElement, xadesPaths.getCurrentDigestAlgAndValue()));
        if (digest == null) {
            LOG.warn("Skipped CRLRef (missing DigestAlgAndValue)");
            return null;
        }
        X500Principal issuer = XAdESRevocationRefExtractionUtils.getCRLIssuer(xadesPaths, crlRefElement);
        if (issuer == null) {
            LOG.warn("Skipped CRLRef (missing CRLIdentifier / Issuer)");
            return null;
        }
        Date issueTime = XAdESRevocationRefExtractionUtils.getCRLIssueTime(xadesPaths, crlRefElement);
        if (issueTime == null) {
            LOG.warn("Skipped CRLRef (missing CRLIdentifier / IssueTime)");
            return null;
        }
        BigInteger crlNumber = XAdESRevocationRefExtractionUtils.getCRLNumber(xadesPaths, crlRefElement);
        return new CRLRef(digest, issuer, issueTime, crlNumber);
    }

    private static X500Principal getCRLIssuer(XAdESPath xadesPaths, Element crlRefElement) {
        X500Principal issuer = null;
        Element issuerEl = DomUtils.getElement(crlRefElement, xadesPaths.getCurrentCRLRefCRLIdentifierIssuer());
        if (issuerEl != null) {
            issuer = DSSASN1Utils.getX500PrincipalOrNull(issuerEl.getTextContent());
        }
        return issuer;
    }

    private static Date getCRLIssueTime(XAdESPath xadesPaths, Element crlRefElement) {
        Date issueTime = null;
        Element issueTimeEl = DomUtils.getElement(crlRefElement, xadesPaths.getCurrentCRLRefCRLIdentifierIssueTime());
        if (issueTimeEl != null) {
            issueTime = DomUtils.getDate(issueTimeEl.getTextContent());
        }
        return issueTime;
    }

    private static BigInteger getCRLNumber(XAdESPath xadesPaths, Element crlRefElement) {
        BigInteger number = null;
        Element numberEl = DomUtils.getElement(crlRefElement, xadesPaths.getCurrentCRLRefCRLIdentifierNumber());
        if (numberEl != null) {
            try {
                number = new BigInteger(numberEl.getTextContent());
            }
            catch (Exception e) {
                LOG.warn("Unable to read CRL number : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return number;
    }
}

