/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.evidencerecord;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.SignatureAttribute;
import eu.europa.esig.dss.spi.validation.evidencerecord.AbstractSignatureEvidenceRecordDigestBuilder;
import eu.europa.esig.dss.spi.validation.evidencerecord.ByteArrayComparator;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESEvidenceRecordDigestBuilder
extends AbstractSignatureEvidenceRecordDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESEvidenceRecordDigestBuilder.class);
    private List<DSSDocument> detachedContent;
    private String signatureId;

    public XAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument) {
        super(signatureDocument);
    }

    public XAdESEvidenceRecordDigestBuilder(DSSDocument signatureDocument, DigestAlgorithm digestAlgorithm) {
        super(signatureDocument, digestAlgorithm);
    }

    protected XAdESEvidenceRecordDigestBuilder(AdvancedSignature signature, SignatureAttribute evidenceRecordAttribute, DigestAlgorithm digestAlgorithm) {
        super(signature, evidenceRecordAttribute, digestAlgorithm);
    }

    public XAdESEvidenceRecordDigestBuilder setDetachedContent(List<DSSDocument> detachedContent) {
        this.detachedContent = detachedContent;
        return this;
    }

    public XAdESEvidenceRecordDigestBuilder setSignatureId(String signatureId) {
        this.signatureId = signatureId;
        return this;
    }

    @Override
    public XAdESEvidenceRecordDigestBuilder setParallelEvidenceRecord(boolean parallelEvidenceRecord) {
        return (XAdESEvidenceRecordDigestBuilder)super.setParallelEvidenceRecord(parallelEvidenceRecord);
    }

    @Override
    public Digest build() {
        XAdESSignature xadesSignature = this.getXAdESSignature();
        return this.getXmlSignatureMessageImprint(xadesSignature);
    }

    protected XAdESSignature getXAdESSignature() {
        if (this.signature != null) {
            return (XAdESSignature)this.signature;
        }
        if (this.signatureDocument != null) {
            AdvancedSignature signature;
            XMLDocumentAnalyzer documentAnalyzer = new XMLDocumentAnalyzer(this.signatureDocument);
            documentAnalyzer.setDetachedContents(this.detachedContent);
            List<AdvancedSignature> signatures = documentAnalyzer.getSignatures();
            if (Utils.collectionSize(signatures) == 0) {
                throw new IllegalInputException("The provided document does not contain any signature! Unable to compute message-imprint for an integrated evidence-record.");
            }
            if (Utils.isStringNotEmpty(this.signatureId)) {
                signature = documentAnalyzer.getSignatureById(this.signatureId);
                if (signature == null) {
                    throw new IllegalArgumentException(String.format("No signature with Id '%s' found in the document!", this.signatureId));
                }
            } else {
                if (Utils.collectionSize(signatures) > 1) {
                    throw new IllegalInputException("The provided document contains multiple signatures! Please use #setSignatureId method in order to provide the identifier.");
                }
                signature = signatures.get(0);
            }
            return (XAdESSignature)signature;
        }
        throw new IllegalStateException("Either DSSDocument containing the signature or AdvancedSignature shall be defined!");
    }

    protected DSSMessageDigest getXmlSignatureMessageImprint(XAdESSignature signature) {
        try {
            List<XAdESAttribute> unsignedProperties;
            ArrayList<byte[]> digestObjectsGroup = new ArrayList<byte[]>();
            byte[] digestValue = null;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 1): Processing ds:Reference's within ds:SignedInfo");
            }
            String canonicalizationAlgorithm = this.getCanonicalizationAlgorithm(signature);
            for (Reference reference : signature.getReferences()) {
                digestValue = this.getReferenceBytesDigestValue(reference, canonicalizationAlgorithm);
                digestObjectsGroup.add(digestValue);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 2): Canonicalization of ds:SignedInfo, ds:SignatureValue, ds:KeyInfo element");
            }
            digestValue = this.getDigestValueOnCanonicalizedNode(signature, XMLDSigPath.SIGNED_INFO_PATH, canonicalizationAlgorithm);
            digestObjectsGroup.add(digestValue);
            digestValue = this.getDigestValueOnCanonicalizedNode(signature, XMLDSigPath.SIGNATURE_VALUE_PATH, canonicalizationAlgorithm);
            digestObjectsGroup.add(digestValue);
            digestValue = this.getDigestValueOnCanonicalizedNode(signature, XMLDSigPath.KEY_INFO_PATH, canonicalizationAlgorithm);
            digestObjectsGroup.add(digestValue);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 3): Processing of unsigned qualifying properties");
            }
            if (Utils.isCollectionNotEmpty(unsignedProperties = this.getUnsignedSignaturePropertiesList(signature))) {
                for (XAdESAttribute xadesAttribute : unsignedProperties) {
                    digestValue = this.getDigestValueOnCanonicalizedNode(xadesAttribute.getElement(), canonicalizationAlgorithm);
                    digestObjectsGroup.add(digestValue);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 5): Processing of ds:Object's");
            }
            for (Node object : this.getObjects(signature)) {
                if (this.containsQualifyingProperties(object, signature.getXAdESPaths())) continue;
                digestValue = this.getDigestValueOnCanonicalizedNode(object, canonicalizationAlgorithm);
                digestObjectsGroup.add(digestValue);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Step 6): Processing of ds:Manifest's");
            }
            for (Reference reference : signature.getReferences()) {
                if (!reference.typeIsReferenceToManifest()) continue;
                List<byte[]> manifestDataObjectDigests = this.getManifestDataObjectDigests(signature, reference, canonicalizationAlgorithm);
                digestObjectsGroup.addAll(manifestDataObjectDigests);
            }
            DSSMessageDigest dSSMessageDigest = this.computeDigestValueGroupHash(digestObjectsGroup);
            if (LOG.isTraceEnabled()) {
                LOG.trace(String.format("Evidence-record signature data group digest: %s", dSSMessageDigest));
            }
            return dSSMessageDigest;
        }
        catch (IOException | XMLSecurityException e) {
            throw new DSSException(String.format("Unable to compute message-imprint for an evidence-record. Reason : %s", e.getMessage()), e);
        }
    }

    protected String getCanonicalizationAlgorithm(XAdESSignature signature) {
        Element signedInfo = signature.getSignedInfo();
        if (signedInfo == null) {
            throw new IllegalStateException("ds:SignedInfo element shall be defined within a signature!");
        }
        String canonicalizationMethod = DomUtils.getValue(signedInfo, XMLDSigPath.CANONICALIZATION_ALGORITHM_PATH);
        if (Utils.isStringEmpty(canonicalizationMethod)) {
            LOG.warn("No canonicalization method found within ds:SignedInfo element. Re-use the default canonicalization algorithm 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315'");
            canonicalizationMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
        }
        return canonicalizationMethod;
    }

    private byte[] getReferenceBytesDigestValue(Reference reference, String canonicalizationAlgorithm) throws XMLSecurityException, IOException {
        try {
            byte[] digest;
            if (this.isResultXmlNodeSet(reference)) {
                byte[] referencedBytes = reference.getReferencedBytes();
                digest = DomUtils.isDOM(referencedBytes) ? DSSXMLUtils.getDigestOnCanonicalizedBytes(referencedBytes, this.digestAlgorithm, canonicalizationAlgorithm).getValue() : DSSUtils.digest(this.digestAlgorithm, referencedBytes);
            } else {
                XMLSignatureInput input = reference.getContentsAfterTransformation();
                digest = this.getDigestValueOnInputStream(input.getOctetStream());
            }
            return digest;
        }
        catch (ReferenceNotInitializedException e) {
            throw new DSSException(String.format("An error occurred on ds:Reference processing. In case of detached signature, please use #setDetachedContent method to provide original documents. More information : %s", e.getMessage()), e);
        }
    }

    private byte[] getDigestValueOnInputStream(InputStream is) throws IOException {
        DSSMessageDigestCalculator messageDigestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
        messageDigestCalculator.update(is);
        return messageDigestCalculator.getMessageDigest(this.digestAlgorithm).getValue();
    }

    private byte[] getDigestValueOnCanonicalizedNode(XAdESSignature signature, String xPathString, String canonicalizationAlgorithm) {
        Element element = DomUtils.getElement(signature.getSignatureElement(), xPathString);
        return this.getDigestValueOnCanonicalizedNode(element, canonicalizationAlgorithm);
    }

    private byte[] getDigestValueOnCanonicalizedNode(Node node, String canonicalizationAlgorithm) {
        return DSSXMLUtils.getDigestOnCanonicalizedNode(node, this.digestAlgorithm, canonicalizationAlgorithm).getValue();
    }

    private List<XAdESAttribute> getUnsignedSignaturePropertiesList(XAdESSignature signature) {
        XAdESAttribute erAttribute;
        XAdESUnsignedSigProperties unsignedSigProperties = XAdESUnsignedSigProperties.build(signature.getSignatureElement(), signature.getXAdESPaths());
        if (!unsignedSigProperties.isExist()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No xades:UnsignedSignatureProperties is present to compute the message-imprint for an evidence-record");
            }
            return Collections.emptyList();
        }
        if (this.evidenceRecordAttribute != null) {
            return this.getPrecedingAttributes(unsignedSigProperties, this.evidenceRecordAttribute);
        }
        if (this.parallelEvidenceRecord && (erAttribute = XAdESSignatureUtils.getLastSealingEvidenceRecordAttribute(unsignedSigProperties)) != null) {
            return this.getPrecedingAttributes(unsignedSigProperties, erAttribute);
        }
        return unsignedSigProperties.getAttributes();
    }

    private List<XAdESAttribute> getPrecedingAttributes(XAdESUnsignedSigProperties unsignedSigProperties, SignatureAttribute attribute) {
        ArrayList<XAdESAttribute> attributes = new ArrayList<XAdESAttribute>();
        for (XAdESAttribute currentAttribute : unsignedSigProperties.getAttributes()) {
            if (attribute.equals(currentAttribute)) break;
            attributes.add(currentAttribute);
        }
        return attributes;
    }

    private List<Node> getObjects(XAdESSignature signature) {
        NodeList objects = signature.getObjects();
        if (objects != null && objects.getLength() > 0) {
            ArrayList<Node> result = new ArrayList<Node>();
            for (int i = 0; i < objects.getLength(); ++i) {
                result.add(objects.item(i));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private boolean containsQualifyingProperties(Node node, XAdESPath xadesPath) {
        Node qualifyingProperties = DomUtils.getNode(node, xadesPath.getCurrentQualifyingPropertiesPath());
        return qualifyingProperties != null;
    }

    private List<byte[]> getManifestDataObjectDigests(XAdESSignature signature, Reference referenceToManifest, String canonicalizationAlgorithm) throws XMLSecurityException, IOException {
        ArrayList<byte[]> digestObjectsGroup = new ArrayList<byte[]>();
        this.getManifestDataObjectDigestsRecursively(signature, referenceToManifest, canonicalizationAlgorithm, digestObjectsGroup);
        return digestObjectsGroup;
    }

    private void getManifestDataObjectDigestsRecursively(XAdESSignature signature, Reference referenceToManifest, String canonicalizationAlgorithm, List<byte[]> digestObjectsGroup) throws XMLSecurityException, IOException {
        for (Reference manifestReference : this.getManifestReferences(signature, referenceToManifest)) {
            if (!this.isResultXmlNodeSet(manifestReference) || !manifestReference.typeIsReferenceToManifest()) {
                byte[] bytes = this.getReferenceBytesDigestValue(manifestReference, canonicalizationAlgorithm);
                digestObjectsGroup.add(bytes);
                continue;
            }
            this.getManifestDataObjectDigestsRecursively(signature, manifestReference, canonicalizationAlgorithm, digestObjectsGroup);
        }
    }

    private List<Reference> getManifestReferences(XAdESSignature signature, Reference referenceToManifest) throws XMLSecurityException {
        String uri = referenceToManifest.getURI();
        Element manifestElement = DSSXMLUtils.getManifestById(signature.getSignatureElement(), uri);
        Manifest manifest = DSSXMLUtils.initManifestWithDetachedContent(manifestElement, this.detachedContent);
        return DSSXMLUtils.extractReferences(manifest);
    }

    private boolean isResultXmlNodeSet(Reference reference) throws XMLSecurityException {
        return ReferenceOutputType.NODE_SET.equals((Object)DSSXMLUtils.getReferenceOutputType(reference));
    }

    private DSSMessageDigest computeDigestValueGroupHash(List<byte[]> digestValueGroup) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("1. Digest Value Group:");
            digestValueGroup.forEach(d -> LOG.trace(Utils.toHex(d)));
        }
        if (Utils.collectionSize(digestValueGroup) == 1) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("2a. Only one data object: {}", (Object)digestValueGroup.get(0));
            }
            return new DSSMessageDigest(this.digestAlgorithm, digestValueGroup.get(0));
        }
        digestValueGroup.sort(ByteArrayComparator.getInstance());
        if (LOG.isTraceEnabled()) {
            LOG.trace("2b. Sorted Digest Value Group:");
            digestValueGroup.forEach(d -> LOG.trace(Utils.toHex(d)));
        }
        DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
        for (byte[] hashValue : digestValueGroup) {
            digestCalculator.update(hashValue);
        }
        DSSMessageDigest messageDigest = digestCalculator.getMessageDigest(this.digestAlgorithm);
        if (LOG.isTraceEnabled()) {
            LOG.trace("4. Message-digest of concatenated string: {}", (Object)messageDigest.getHexValue());
        }
        return messageDigest;
    }
}

