/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;

public class SigningTimeInCertificateValidityRangeCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final SignatureWrapper signature;

    public SigningTimeInCertificateValidityRangeCheck(I18nProvider i18nProvider, T result, SignatureWrapper signature, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        return this.signature.getClaimedSigningTime() != null && this.signature.getSigningCertificate() != null && this.signature.getClaimedSigningTime().compareTo(this.signature.getSigningCertificate().getNotBefore()) >= 0 && this.signature.getClaimedSigningTime().compareTo(this.signature.getSigningCertificate().getNotAfter()) <= 0;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ISQPSTWSCVR;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ISQPSTWSCVR_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

