/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;
import java.util.stream.Collectors;

public class EvidenceRecordHashTreeRenewalTimestampCheck
extends ChainItem<XmlCV> {
    private final DiagnosticData diagnosticData;
    private final TimestampWrapper timestampWrapper;

    public EvidenceRecordHashTreeRenewalTimestampCheck(I18nProvider i18nProvider, XmlCV result, DiagnosticData diagnosticData, TimestampWrapper timestampWrapper, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.diagnosticData = diagnosticData;
        this.timestampWrapper = timestampWrapper;
    }

    @Override
    protected boolean process() {
        EvidenceRecordWrapper evidenceRecord = this.getRelatedEvidenceRecord(this.timestampWrapper);
        return this.timestampCoversAllOriginalDocuments(evidenceRecord, this.timestampWrapper);
    }

    private EvidenceRecordWrapper getRelatedEvidenceRecord(TimestampWrapper timestampWrapper) {
        for (EvidenceRecordWrapper evidenceRecordWrapper : this.diagnosticData.getEvidenceRecords()) {
            if (!evidenceRecordWrapper.getTimestampList().contains(timestampWrapper)) continue;
            return evidenceRecordWrapper;
        }
        throw new IllegalStateException(String.format("Not found a corresponding evidence record for a time-stamp with Id '%s'", timestampWrapper.getId()));
    }

    private List<String> getCoveredDocuments(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().filter(d -> DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_OBJECT == d.getType() && d.isDataFound()).map(XmlDigestMatcher::getDocumentName).collect(Collectors.toList());
    }

    private boolean timestampCoversAllOriginalDocuments(EvidenceRecordWrapper evidenceRecord, TimestampWrapper timestampWrapper) {
        List<String> evidenceRecordCoveredDocuments = this.getCoveredDocuments(evidenceRecord.getDigestMatchers());
        List<String> timestampCoveredDocuments = this.getCoveredDocuments(timestampWrapper.getDigestMatchers());
        for (String originalDataObject : evidenceRecordCoveredDocuments) {
            if (!timestampCoveredDocuments.contains(originalDataObject)) {
                return false;
            }
            timestampCoveredDocuments.remove(originalDataObject);
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_ER_TST_RN;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        if (this.containsOtherDigests()) {
            return MessageTag.BBB_CV_ER_TST_RN_ANS_2;
        }
        return MessageTag.BBB_CV_ER_TST_RN_ANS_1;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        if (this.containsOtherDigests()) {
            return Indication.FAILED;
        }
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        if (this.containsOtherDigests()) {
            return SubIndication.HASH_FAILURE;
        }
        return SubIndication.SIGNED_DATA_NOT_FOUND;
    }

    private boolean containsOtherDigests() {
        return this.timestampWrapper.getDigestMatchers().stream().anyMatch(d -> DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == d.getType());
    }
}

