/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.cc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.AbstractCryptographicCheck;

public class SignatureAlgorithmReliableCheck
extends AbstractCryptographicCheck {
    private final SignatureAlgorithm signatureAlgorithm;
    private final CryptographicSuite cryptographicSuite;

    public SignatureAlgorithmReliableCheck(I18nProvider i18nProvider, SignatureAlgorithm signatureAlgorithm, XmlCC result, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, result, position, ValidationProcessUtils.getLevelRule(cryptographicSuite.getAcceptableSignatureAlgorithmsLevel()));
        this.signatureAlgorithm = signatureAlgorithm;
        this.cryptographicSuite = cryptographicSuite;
    }

    @Override
    protected boolean process() {
        return CryptographicSuiteUtils.isSignatureAlgorithmReliable(this.cryptographicSuite, this.signatureAlgorithm);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_CAA, this.getName(this.signatureAlgorithm));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_CAA_ANS, new Object[]{this.getName(this.signatureAlgorithm), this.position});
    }
}

