/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.cc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.AbstractCryptographicCheck;
import java.util.Date;

public class SignatureAlgorithmAtValidationTimeCheck
extends AbstractCryptographicCheck {
    private final SignatureAlgorithm signatureAlgorithm;
    private final String keyLength;
    private final Date validationDate;
    private final CryptographicSuite cryptographicSuite;

    public SignatureAlgorithmAtValidationTimeCheck(I18nProvider i18nProvider, SignatureAlgorithm signatureAlgorithm, String keyLength, Date validationDate, XmlCC result, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, result, position, ValidationProcessUtils.getLevelRule(cryptographicSuite.getAlgorithmsExpirationDateLevel()));
        this.signatureAlgorithm = signatureAlgorithm;
        this.keyLength = keyLength;
        this.validationDate = validationDate;
        this.cryptographicSuite = cryptographicSuite;
    }

    @Override
    protected boolean process() {
        return CryptographicSuiteUtils.isSignatureAlgorithmReliableAtTime(this.cryptographicSuite, this.signatureAlgorithm, this.keyLength, this.validationDate);
    }

    @Override
    protected Level getLevel() {
        Date algoExpirationDate = CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.signatureAlgorithm, this.keyLength);
        Date cryptographicSuiteUpdateDate = this.cryptographicSuite.getCryptographicSuiteUpdateDate();
        if (algoExpirationDate != null && cryptographicSuiteUpdateDate != null && cryptographicSuiteUpdateDate.before(algoExpirationDate)) {
            return this.cryptographicSuite.getAlgorithmsExpirationDateAfterUpdateLevel();
        }
        return super.getLevel();
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_AR, this.getName(this.signatureAlgorithm));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        Date algoExpirationDate = CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.signatureAlgorithm, this.keyLength);
        MessageTag messageTag = algoExpirationDate != null && algoExpirationDate.before(this.validationDate) ? MessageTag.ASCCM_AR_ANS_AKSNR : MessageTag.ASCCM_AR_ANS_AKSNR_2;
        return this.buildXmlMessage(messageTag, new Object[]{this.getName(this.signatureAlgorithm), this.keyLength, this.position});
    }
}

