/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.AlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.DigestAlgorithmCryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.DigestMatcherCryptographicCheckerResultCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class DigestAlgorithmObsolescenceValidation<T>
extends AlgorithmObsolescenceValidation<T> {
    private static List<DigestMatcherType> digestMatcherTypesToIgnore = Arrays.asList(DigestMatcherType.COUNTER_SIGNED_SIGNATURE_VALUE, DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_OBJECT, DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_TIME_STAMP, DigestMatcherType.EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE, DigestMatcherType.EVIDENCE_RECORD_MASTER_SIGNATURE);

    protected DigestAlgorithmObsolescenceValidation(I18nProvider i18nProvider, T token, Context context, Date validationDate, ValidationPolicy validationPolicy) {
        super(i18nProvider, token, context, validationDate, validationPolicy);
    }

    protected ChainItem<XmlAOV> buildDigestMatchersValidationChain(ChainItem<XmlAOV> item, List<XmlDigestMatcher> digestMatchers, String tokenId) {
        if (Utils.isCollectionEmpty(digestMatchers)) {
            return item;
        }
        XmlCryptographicValidation cryptographicValidation = null;
        List<XmlDigestMatcher> digestMatchersToProcess = this.getDigestMatchersToProcess(digestMatchers);
        Set<DigestAlgorithm> usedDigestAlgorithms = this.getUsedDigestAlgorithms(digestMatchersToProcess);
        Set<MessageTag> usedPositions = this.getUsedPositions(digestMatchersToProcess);
        for (DigestAlgorithm digestAlgorithm : usedDigestAlgorithms) {
            for (MessageTag position : usedPositions) {
                List<XmlDigestMatcher> digestMatchersGroup = this.getDigestMatchersByAlgorithmAndPosition(digestMatchersToProcess, digestAlgorithm, position);
                if (!Utils.isCollectionNotEmpty(digestMatchersGroup)) continue;
                DigestAlgorithmCryptographicChecker dac = new DigestAlgorithmCryptographicChecker(this.i18nProvider, digestAlgorithm, this.validationDate, position, this.cryptographicSuite);
                XmlCC dacResult = (XmlCC)dac.execute();
                if (item == null) {
                    this.firstItem = this.digestAlgorithmCheckResult(digestMatchersGroup, dacResult, this.cryptographicSuite);
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(this.digestAlgorithmCheckResult(digestMatchersGroup, dacResult, this.cryptographicSuite));
                }
                if (cryptographicValidation != null && (!this.isValid(cryptographicValidation) || Indication.PASSED == dacResult.getConclusion().getIndication())) continue;
                cryptographicValidation = dacResult.getCryptographicValidation();
                cryptographicValidation.setConcernedMaterialDescription(this.getMaterialDescription(digestMatchersGroup));
            }
        }
        this.digestMatchersCryptographicValidation = cryptographicValidation;
        if (this.digestMatchersCryptographicValidation != null) {
            this.digestMatchersCryptographicValidation.setTokenId(tokenId);
        }
        return item;
    }

    private List<XmlDigestMatcher> getDigestMatchersToProcess(List<XmlDigestMatcher> digestMatchers) {
        ArrayList<XmlDigestMatcher> digestMatchersToProcess = new ArrayList<XmlDigestMatcher>();
        for (XmlDigestMatcher digestMatcher : digestMatchers) {
            if (digestMatcher.getDigestMethod() == null && digestMatcherTypesToIgnore.contains((Object)digestMatcher.getType())) continue;
            digestMatchersToProcess.add(digestMatcher);
        }
        if (Utils.isCollectionEmpty(digestMatchersToProcess)) {
            return digestMatchers;
        }
        return digestMatchersToProcess;
    }

    private Set<DigestAlgorithm> getUsedDigestAlgorithms(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().map(XmlDigestAlgoAndValue::getDigestMethod).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<MessageTag> getUsedPositions(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().map(ValidationProcessUtils::getDigestMatcherCryptoPosition).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<XmlDigestMatcher> getDigestMatchersByAlgorithmAndPosition(List<XmlDigestMatcher> digestMatchers, DigestAlgorithm digestAlgorithm, MessageTag position) {
        if (position == null) {
            return Collections.emptyList();
        }
        return digestMatchers.stream().filter(d -> digestAlgorithm == d.getDigestMethod() && position == ValidationProcessUtils.getDigestMatcherCryptoPosition(d) && DigestMatcherType.COUNTER_SIGNED_SIGNATURE_VALUE != d.getType()).collect(Collectors.toList());
    }

    private ChainItem<XmlAOV> digestAlgorithmCheckResult(List<XmlDigestMatcher> digestMatchers, XmlCC ccResult, CryptographicSuite constraint) {
        MessageTag position = ValidationProcessUtils.getDigestMatcherCryptoPosition(digestMatchers);
        return new DigestMatcherCryptographicCheckerResultCheck<XmlAOV>(this.i18nProvider, (XmlAOV)this.result, this.validationDate, position, this.getReferenceNames(digestMatchers), ccResult, constraint);
    }

    private String getMaterialDescription(List<XmlDigestMatcher> digestMatchers) {
        List<String> referenceNames = this.getReferenceNames(digestMatchers);
        if (Utils.isCollectionNotEmpty(referenceNames)) {
            return this.i18nProvider.getMessage(MessageTag.ACCM_DESC_WITH_NAME, new Object[]{this.position, Utils.joinStrings(referenceNames, ", ")});
        }
        return this.i18nProvider.getMessage(this.position, new Object[0]);
    }

    private List<String> getReferenceNames(List<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.stream().map(d -> d.getId() != null ? d.getId() : (d.getUri() != null ? d.getUri() : d.getDocumentName())).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

