/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.OrphanCertificateTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanTokenWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.bbb.aov.CertificateAndChainAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.RevocationDataAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.SignatureAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.TimestampAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.TokenAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.cv.CryptographicVerification;
import eu.europa.esig.dss.validation.process.bbb.fc.SignatureFormatChecking;
import eu.europa.esig.dss.validation.process.bbb.fc.TimestampFormatChecking;
import eu.europa.esig.dss.validation.process.bbb.isc.IdentificationOfTheSigningCertificate;
import eu.europa.esig.dss.validation.process.bbb.sav.RevocationAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.TimestampAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.vci.ValidationContextInitialization;
import eu.europa.esig.dss.validation.process.bbb.xcv.X509CertificateValidation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BasicBuildingBlocks {
    private final I18nProvider i18nProvider;
    private final DiagnosticData diagnosticData;
    private final TokenProxy token;
    private final ValidationPolicy policy;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final Date currentTime;
    private final Context context;

    public BasicBuildingBlocks(I18nProvider i18nProvider, DiagnosticData diagnosticData, TokenProxy token, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Context context) {
        this.i18nProvider = i18nProvider;
        this.diagnosticData = diagnosticData;
        this.token = token;
        this.currentTime = currentTime;
        this.bbbs = bbbs;
        this.policy = policy;
        this.context = context;
    }

    public XmlBasicBuildingBlocks execute() {
        XmlSAV sav;
        XmlCV cv;
        XmlXCV xcv;
        XmlAOV aov;
        XmlVCI vci;
        XmlISC isc;
        XmlBasicBuildingBlocks result = new XmlBasicBuildingBlocks();
        result.setId(this.token.getId());
        result.setType(this.context);
        result.setConclusion(new XmlConclusion());
        XmlFC fc = this.executeFormatChecking();
        if (fc != null) {
            result.setFC(fc);
            this.updateFinalConclusion(result, fc);
        }
        if ((isc = this.executeIdentificationOfTheSigningCertificate()) != null) {
            result.setISC(isc);
            result.setCertificateChain(isc.getCertificateChain());
            this.updateFinalConclusion(result, isc);
        }
        if ((vci = this.executeValidationContextInitialization()) != null) {
            result.setVCI(vci);
            this.updateFinalConclusion(result, vci);
        }
        if ((aov = this.executeAlgorithmObsolescenceValidation()) != null) {
            result.setAOV(aov);
        }
        if ((xcv = this.executeX509CertificateValidation(aov)) != null) {
            result.setXCV(xcv);
            this.addAdditionalInfo(xcv);
            this.updateFinalConclusion(result, xcv);
        }
        if ((cv = this.executeCryptographicVerification()) != null) {
            result.setCV(cv);
            this.updateFinalConclusion(result, cv);
        }
        if ((sav = this.executeSignatureAcceptanceValidation(aov)) != null) {
            result.setSAV(sav);
            this.updateFinalConclusion(result, sav);
        }
        if (result.getConclusion().getIndication() == null) {
            result.getConclusion().setIndication(Indication.PASSED);
        }
        return result;
    }

    private void updateFinalConclusion(XmlBasicBuildingBlocks result, XmlConstraintsConclusion constraintsAndConclusion) {
        XmlConclusion finalConclusion = result.getConclusion();
        XmlConclusion currentConclusion = constraintsAndConclusion.getConclusion();
        if (!Indication.PASSED.equals(currentConclusion.getIndication())) {
            finalConclusion.setIndication(currentConclusion.getIndication());
            finalConclusion.setSubIndication(currentConclusion.getSubIndication());
            finalConclusion.getErrors().addAll(currentConclusion.getErrors());
        }
        finalConclusion.getWarnings().addAll(currentConclusion.getWarnings());
        finalConclusion.getInfos().addAll(currentConclusion.getInfos());
    }

    private XmlFC executeFormatChecking() {
        TimestampFormatChecking fc;
        XmlFC xmlFC;
        if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
            SignatureFormatChecking fc2 = new SignatureFormatChecking(this.i18nProvider, this.diagnosticData, (SignatureWrapper)this.token, this.context, this.policy);
            return (XmlFC)fc2.execute();
        }
        if (Context.TIMESTAMP.equals((Object)this.context) && Utils.isCollectionNotEmpty((xmlFC = (XmlFC)(fc = new TimestampFormatChecking(this.i18nProvider, this.diagnosticData, (TimestampWrapper)this.token, this.context, this.policy)).execute()).getConstraint())) {
            return xmlFC;
        }
        return null;
    }

    private XmlISC executeIdentificationOfTheSigningCertificate() {
        if (!Context.CERTIFICATE.equals((Object)this.context)) {
            IdentificationOfTheSigningCertificate isc = new IdentificationOfTheSigningCertificate(this.i18nProvider, this.token, this.context, this.policy);
            return (XmlISC)isc.execute();
        }
        return null;
    }

    private XmlVCI executeValidationContextInitialization() {
        if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
            ValidationContextInitialization vci = new ValidationContextInitialization(this.i18nProvider, (SignatureWrapper)this.token, this.context, this.policy);
            return (XmlVCI)vci.execute();
        }
        return null;
    }

    private XmlAOV executeAlgorithmObsolescenceValidation() {
        TokenAlgorithmObsolescenceValidation aov = null;
        if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
            aov = new SignatureAlgorithmObsolescenceValidation(this.i18nProvider, (SignatureWrapper)this.token, this.context, this.currentTime, this.policy);
        } else if (Context.TIMESTAMP.equals((Object)this.context)) {
            aov = new TimestampAlgorithmObsolescenceValidation(this.i18nProvider, (TimestampWrapper)this.token, this.currentTime, this.policy);
        } else if (Context.REVOCATION.equals((Object)this.context)) {
            aov = new RevocationDataAlgorithmObsolescenceValidation(this.i18nProvider, (RevocationWrapper)this.token, this.currentTime, this.policy);
        } else if (Context.CERTIFICATE.equals((Object)this.context)) {
            aov = new CertificateAndChainAlgorithmObsolescenceValidation(this.i18nProvider, (CertificateWrapper)this.token, this.context, this.currentTime, this.policy);
        }
        return aov != null ? (XmlAOV)aov.execute() : null;
    }

    private XmlXCV executeX509CertificateValidation(XmlAOV aov) {
        X509CertificateValidation x509CertificateValidation = this.getX509CertificateValidation(aov);
        if (x509CertificateValidation != null) {
            return (XmlXCV)x509CertificateValidation.execute();
        }
        return null;
    }

    private X509CertificateValidation getX509CertificateValidation(XmlAOV aov) {
        if (Context.CERTIFICATE.equals((Object)this.context)) {
            CertificateWrapper certificate = (CertificateWrapper)this.token;
            return new X509CertificateValidation(this.i18nProvider, certificate, this.currentTime, certificate.getNotBefore(), this.context, aov, this.policy);
        }
        CertificateWrapper signingCertificate = this.token.getSigningCertificate();
        if (signingCertificate != null) {
            if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
                return new X509CertificateValidation(this.i18nProvider, signingCertificate, this.currentTime, signingCertificate.getNotBefore(), this.context, aov, this.policy);
            }
            if (Context.TIMESTAMP.equals((Object)this.context)) {
                return new X509CertificateValidation(this.i18nProvider, signingCertificate, this.currentTime, ((TimestampWrapper)this.token).getProductionTime(), this.context, aov, this.policy);
            }
            if (Context.REVOCATION.equals((Object)this.context)) {
                return new X509CertificateValidation(this.i18nProvider, signingCertificate, this.currentTime, ((RevocationWrapper)this.token).getProductionDate(), this.context, aov, this.policy);
            }
        }
        return null;
    }

    private void addAdditionalInfo(XmlXCV xcv) {
        for (XmlSubXCV subXCV : xcv.getSubXCV()) {
            List<OrphanCertificateTokenWrapper> orphanCrossCertificates;
            CertificateWrapper cert = this.diagnosticData.getUsedCertificateById(subXCV.getId());
            List<CertificateWrapper> crossCertificates = this.diagnosticData.getCrossCertificates(cert);
            if (Utils.isCollectionNotEmpty(crossCertificates)) {
                subXCV.getCrossCertificates().addAll(BasicBuildingBlocks.getCertificateWrapperIds(crossCertificates));
            }
            if (Utils.isCollectionNotEmpty(orphanCrossCertificates = this.diagnosticData.getOrphanCrossCertificates(cert))) {
                subXCV.getCrossCertificates().addAll(BasicBuildingBlocks.getOrphanCertificateWrapperIds(orphanCrossCertificates));
            }
            List<CertificateWrapper> equivalentCertificates = this.diagnosticData.getEquivalentCertificates(cert);
            equivalentCertificates.removeAll(crossCertificates);
            if (Utils.isCollectionNotEmpty(equivalentCertificates)) {
                subXCV.getEquivalentCertificates().addAll(BasicBuildingBlocks.getCertificateWrapperIds(equivalentCertificates));
            }
            List<OrphanCertificateTokenWrapper> orphanEquivalentCertificates = this.diagnosticData.getOrphanEquivalentCertificates(cert);
            orphanEquivalentCertificates.removeAll(orphanCrossCertificates);
            if (!Utils.isCollectionNotEmpty(orphanEquivalentCertificates)) continue;
            subXCV.getEquivalentCertificates().addAll(BasicBuildingBlocks.getOrphanCertificateWrapperIds(orphanEquivalentCertificates));
        }
    }

    private static List<String> getCertificateWrapperIds(Collection<CertificateWrapper> tokens) {
        return tokens.stream().map(TokenProxy::getId).collect(Collectors.toList());
    }

    private static List<String> getOrphanCertificateWrapperIds(Collection<OrphanCertificateTokenWrapper> tokens) {
        return tokens.stream().map(OrphanTokenWrapper::getId).collect(Collectors.toList());
    }

    private XmlCV executeCryptographicVerification() {
        if (!Context.CERTIFICATE.equals((Object)this.context)) {
            CryptographicVerification cv = new CryptographicVerification(this.i18nProvider, this.diagnosticData, this.token, this.context, this.policy);
            return (XmlCV)cv.execute();
        }
        return null;
    }

    private XmlSAV executeSignatureAcceptanceValidation(XmlAOV aov) {
        Chain aav = null;
        if (Context.SIGNATURE.equals((Object)this.context) || Context.COUNTER_SIGNATURE.equals((Object)this.context)) {
            aav = new SignatureAcceptanceValidation(this.i18nProvider, this.diagnosticData, this.currentTime, (SignatureWrapper)this.token, this.context, this.bbbs, aov, this.policy);
        } else if (Context.TIMESTAMP.equals((Object)this.context)) {
            aav = new TimestampAcceptanceValidation(this.i18nProvider, this.currentTime, (TimestampWrapper)this.token, aov, this.policy);
        } else if (Context.REVOCATION.equals((Object)this.context)) {
            aav = new RevocationAcceptanceValidation(this.i18nProvider, this.currentTime, (RevocationWrapper)this.token, aov, this.policy);
        }
        return aav != null ? (XmlSAV)aav.execute() : null;
    }
}

