/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.signature;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateChain;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRevocationInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.OrphanCertificateTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanCertificateWrapper;
import eu.europa.esig.dss.diagnostic.OrphanRevocationTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanRevocationWrapper;
import eu.europa.esig.dss.diagnostic.OrphanTokenWrapper;
import eu.europa.esig.dss.diagnostic.RelatedCertificateWrapper;
import eu.europa.esig.dss.diagnostic.RelatedRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationRefWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.SignerDataWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCommitmentTypeIndication;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.MessageType;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignaturePolicyType;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampQualification;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.vpfswatsp.EvidenceRecordPOE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.TimestampPOE;
import eu.europa.esig.validationreport.enums.ConstraintStatus;
import eu.europa.esig.validationreport.enums.ObjectType;
import eu.europa.esig.validationreport.enums.SignatureValidationProcessID;
import eu.europa.esig.validationreport.enums.TypeOfProof;
import eu.europa.esig.validationreport.jaxb.AdditionalValidationReportDataType;
import eu.europa.esig.validationreport.jaxb.AttributeBaseType;
import eu.europa.esig.validationreport.jaxb.CertificateChainType;
import eu.europa.esig.validationreport.jaxb.ConstraintStatusType;
import eu.europa.esig.validationreport.jaxb.CryptoInformationType;
import eu.europa.esig.validationreport.jaxb.IndividualValidationConstraintReportType;
import eu.europa.esig.validationreport.jaxb.ObjectFactory;
import eu.europa.esig.validationreport.jaxb.POEProvisioningType;
import eu.europa.esig.validationreport.jaxb.POEType;
import eu.europa.esig.validationreport.jaxb.RevocationStatusInformationType;
import eu.europa.esig.validationreport.jaxb.SACRLIDType;
import eu.europa.esig.validationreport.jaxb.SACertIDListType;
import eu.europa.esig.validationreport.jaxb.SACertIDType;
import eu.europa.esig.validationreport.jaxb.SACommitmentTypeIndicationType;
import eu.europa.esig.validationreport.jaxb.SAContactInfoType;
import eu.europa.esig.validationreport.jaxb.SACounterSignatureType;
import eu.europa.esig.validationreport.jaxb.SADSSType;
import eu.europa.esig.validationreport.jaxb.SADataObjectFormatType;
import eu.europa.esig.validationreport.jaxb.SAFilterType;
import eu.europa.esig.validationreport.jaxb.SAMessageDigestType;
import eu.europa.esig.validationreport.jaxb.SANameType;
import eu.europa.esig.validationreport.jaxb.SAOCSPIDType;
import eu.europa.esig.validationreport.jaxb.SAOneSignerRoleType;
import eu.europa.esig.validationreport.jaxb.SAReasonType;
import eu.europa.esig.validationreport.jaxb.SARevIDListType;
import eu.europa.esig.validationreport.jaxb.SASigPolicyIdentifierType;
import eu.europa.esig.validationreport.jaxb.SASignatureProductionPlaceType;
import eu.europa.esig.validationreport.jaxb.SASignerRoleType;
import eu.europa.esig.validationreport.jaxb.SASigningTimeType;
import eu.europa.esig.validationreport.jaxb.SASubFilterType;
import eu.europa.esig.validationreport.jaxb.SATimestampType;
import eu.europa.esig.validationreport.jaxb.SAVRIType;
import eu.europa.esig.validationreport.jaxb.SignatureAttributesType;
import eu.europa.esig.validationreport.jaxb.SignatureIdentifierType;
import eu.europa.esig.validationreport.jaxb.SignatureQualityType;
import eu.europa.esig.validationreport.jaxb.SignatureReferenceType;
import eu.europa.esig.validationreport.jaxb.SignatureValidationProcessType;
import eu.europa.esig.validationreport.jaxb.SignatureValidationReportType;
import eu.europa.esig.validationreport.jaxb.SignerInformationType;
import eu.europa.esig.validationreport.jaxb.SignersDocumentType;
import eu.europa.esig.validationreport.jaxb.TypedDataType;
import eu.europa.esig.validationreport.jaxb.VOReferenceType;
import eu.europa.esig.validationreport.jaxb.ValidationConstraintsEvaluationReportType;
import eu.europa.esig.validationreport.jaxb.ValidationObjectListType;
import eu.europa.esig.validationreport.jaxb.ValidationObjectRepresentationType;
import eu.europa.esig.validationreport.jaxb.ValidationObjectType;
import eu.europa.esig.validationreport.jaxb.ValidationReportDataType;
import eu.europa.esig.validationreport.jaxb.ValidationReportType;
import eu.europa.esig.validationreport.jaxb.ValidationStatusType;
import eu.europa.esig.validationreport.jaxb.ValidationTimeInfoType;
import eu.europa.esig.xades.jaxb.xades132.DigestAlgAndValueType;
import eu.europa.esig.xmldsig.jaxb.DigestMethodType;
import eu.europa.esig.xmldsig.jaxb.SignatureValueType;
import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ETSIValidationReportBuilder {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final Date currentTime;
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private final Map<String, SignatureIdentifierType> signatureIdentifierMap = new HashMap<String, SignatureIdentifierType>();
    private final Map<String, ValidationObjectType> validationObjectMap = new HashMap<String, ValidationObjectType>();

    public ETSIValidationReportBuilder(Date currentTime, DiagnosticData diagnosticData, DetailedReport detailedReport) {
        this.currentTime = currentTime;
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
    }

    public ValidationReportType build() {
        ValidationReportType result = this.objectFactory.createValidationReportType();
        if (!this.diagnosticData.getSignatures().isEmpty()) {
            for (SignatureWrapper sigWrapper : this.diagnosticData.getSignatures()) {
                result.getSignatureValidationReport().add(this.getSignatureValidationReport(sigWrapper));
            }
        } else {
            result.getSignatureValidationReport().add(this.noSignatureFoundReport());
        }
        ValidationObjectListType signatureValidationObjects = this.getSignatureValidationObjects();
        if (!signatureValidationObjects.getValidationObject().isEmpty()) {
            result.setSignatureValidationObjects(signatureValidationObjects);
        }
        return result;
    }

    private SignatureValidationReportType getSignatureValidationReport(SignatureWrapper sigWrapper) {
        SignatureValidationReportType signatureValidationReport = this.objectFactory.createSignatureValidationReportType();
        signatureValidationReport.setSignatureIdentifier(this.getSignatureIdentifier(sigWrapper));
        signatureValidationReport.setSignersDocument(this.getSignersDocument(sigWrapper));
        SignatureAttributesType signatureAttributes = this.getSignatureAttributes(sigWrapper);
        if (!signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().isEmpty()) {
            signatureValidationReport.setSignatureAttributes(signatureAttributes);
        }
        signatureValidationReport.setSignerInformation(this.getSignerInformation(sigWrapper));
        signatureValidationReport.setSignatureQuality(this.getSignatureQuality(sigWrapper));
        signatureValidationReport.setSignatureValidationProcess(this.getSignatureValidationProcess(sigWrapper));
        signatureValidationReport.setSignatureValidationStatus(this.getValidationStatus(sigWrapper));
        signatureValidationReport.setValidationTimeInfo(this.getValidationTimeInfo(sigWrapper));
        signatureValidationReport.setValidationConstraintsEvaluationReport(this.getValidationConstraintsEvaluationReport(sigWrapper));
        return signatureValidationReport;
    }

    private SignatureValidationReportType noSignatureFoundReport() {
        SignatureValidationReportType signatureValidationReport = this.objectFactory.createSignatureValidationReportType();
        signatureValidationReport.setSignatureValidationStatus(this.noSignatureFoundValidationStatus());
        return signatureValidationReport;
    }

    private ValidationStatusType noSignatureFoundValidationStatus() {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        validationStatus.setMainIndication(Indication.NO_SIGNATURE_FOUND);
        return validationStatus;
    }

    private ValidationConstraintsEvaluationReportType getValidationConstraintsEvaluationReport(AbstractTokenProxy token) {
        ValidationConstraintsEvaluationReportType validationConstraintsEvaluationReport = this.objectFactory.createValidationConstraintsEvaluationReportType();
        XmlBasicBuildingBlocks bbbResults = this.detailedReport.getBasicBuildingBlockById(token.getId());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.FORMAT_CHECKING, bbbResults.getFC());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.IDENTIFICATION_OF_THE_SIGNING_CERTIFICATE, bbbResults.getISC());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.VALIDATION_CONTEXT_INITIALIZATION, bbbResults.getVCI());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.CRYPTOGRAPHIC_VERIFICATION, bbbResults.getCV());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.SIGNATURE_ACCEPTANCE_VALIDATION, bbbResults.getSAV());
        this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.X509_CERTIFICATE_VALIDATION, bbbResults.getXCV());
        if (token instanceof SignatureWrapper || token instanceof TimestampWrapper) {
            this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.PAST_SIGNATURE_VALIDATION, bbbResults.getPSV());
            this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.PAST_CERTIFICATE_VALIDATION, bbbResults.getPCV());
            this.addBBB(validationConstraintsEvaluationReport, BasicBuildingBlockDefinition.VALIDATION_TIME_SLIDING, bbbResults.getVTS());
        }
        return validationConstraintsEvaluationReport;
    }

    private void addBBB(ValidationConstraintsEvaluationReportType validationConstraintsEvaluationReport, BasicBuildingBlockDefinition bbbUri, XmlConstraintsConclusion constraintConclusion) {
        if (constraintConclusion != null) {
            validationConstraintsEvaluationReport.getValidationConstraint().add(this.getIndividualValidationConstraintReport(bbbUri, constraintConclusion, this.applied()));
        } else {
            validationConstraintsEvaluationReport.getValidationConstraint().add(this.getIndividualValidationConstraintReport(bbbUri, constraintConclusion, this.disabled()));
        }
    }

    private IndividualValidationConstraintReportType getIndividualValidationConstraintReport(BasicBuildingBlockDefinition bbbUri, XmlConstraintsConclusion constraintConclusion, ConstraintStatusType constraintStatusType) {
        IndividualValidationConstraintReportType validationConstraint = this.objectFactory.createIndividualValidationConstraintReportType();
        validationConstraint.setValidationConstraintIdentifier(bbbUri.getUri());
        validationConstraint.setConstraintStatus(constraintStatusType);
        if (constraintConclusion != null) {
            validationConstraint.setValidationStatus(this.getValidationStatus(constraintConclusion.getConclusion()));
        }
        return validationConstraint;
    }

    private ConstraintStatusType applied() {
        return this.constraintStatus(ConstraintStatus.APPLIED);
    }

    private ConstraintStatusType disabled() {
        return this.constraintStatus(ConstraintStatus.DISABLED);
    }

    private ConstraintStatusType constraintStatus(ConstraintStatus status) {
        ConstraintStatusType constraintStatus = this.objectFactory.createConstraintStatusType();
        constraintStatus.setStatus(status);
        return constraintStatus;
    }

    private SignatureValidationReportType getValidationReport(AbstractTokenProxy token) {
        XmlBasicBuildingBlocks tokenBBB = this.detailedReport.getBasicBuildingBlockById(token.getId());
        if (tokenBBB == null) {
            return null;
        }
        SignatureValidationReportType signatureValidationReport = this.objectFactory.createSignatureValidationReportType();
        signatureValidationReport.setSignerInformation(this.getSignerInformation(token));
        signatureValidationReport.setSignatureValidationStatus(this.getValidationStatus(token));
        signatureValidationReport.setValidationConstraintsEvaluationReport(this.getValidationConstraintsEvaluationReport(token));
        TimestampQualification timestampQualification = this.detailedReport.getTimestampQualification(token.getId());
        if (timestampQualification != null) {
            SignatureQualityType signatureQualityType = this.objectFactory.createSignatureQualityType();
            signatureQualityType.getSignatureQualityInformation().add(timestampQualification.getUri());
            signatureValidationReport.setSignatureQuality(signatureQualityType);
        }
        return signatureValidationReport;
    }

    private ValidationTimeInfoType getValidationTimeInfo(SignatureWrapper sigWrapper) {
        ValidationTimeInfoType validationTimeInfoType = this.objectFactory.createValidationTimeInfoType();
        validationTimeInfoType.setValidationTime(this.currentTime);
        XmlProofOfExistence proofOfExistence = this.detailedReport.getBestProofOfExistence(sigWrapper.getId());
        POEType poeType = new POEType();
        poeType.setPOETime(proofOfExistence.getTime());
        poeType.setTypeOfProof(TypeOfProof.VALIDATION);
        String timestampId = proofOfExistence.getTimestampId();
        if (Utils.isStringNotEmpty(timestampId)) {
            EvidenceRecordWrapper evidenceRecordWrapper;
            TimestampWrapper timestampWrapper = this.diagnosticData.getTimestampById(timestampId);
            if (timestampWrapper != null) {
                poeType.setPOEObject(this.getVOReference(this.getTimestampValidationObject(timestampWrapper)));
            }
            if ((evidenceRecordWrapper = this.diagnosticData.getEvidenceRecordById(timestampId)) != null) {
                poeType.setPOEObject(this.getVOReference(this.getEvidenceRecordValidationObject(evidenceRecordWrapper)));
            }
        }
        validationTimeInfoType.setBestSignatureTime(poeType);
        return validationTimeInfoType;
    }

    private SignerInformationType getSignerInformation(AbstractTokenProxy token) {
        CertificateWrapper signingCert = token.getSigningCertificate();
        if (signingCert == null) {
            return null;
        }
        SignerInformationType signerInfo = this.objectFactory.createSignerInformationType();
        XmlStatus pseudoUseStatus = this.getPseudoUseStatus(token);
        if (pseudoUseStatus != null) {
            signerInfo.setPseudonym(this.isPseudoUse(pseudoUseStatus));
        }
        signerInfo.setSigner(signingCert.getReadableCertificateName());
        signerInfo.setSignerCertificate(this.getVOReference(this.getCertificateValidationObject(signingCert)));
        return signerInfo;
    }

    private XmlStatus getPseudoUseStatus(AbstractTokenProxy token) {
        XmlSubXCV signingCertificateXCV = this.detailedReport.getSigningCertificate(token.getId());
        if (signingCertificateXCV != null) {
            List<XmlConstraint> constraints = signingCertificateXCV.getConstraint();
            for (XmlConstraint xmlConstraint : constraints) {
                if (!"BBB_XCV_PSEUDO_USE".equals(xmlConstraint.getName().getKey())) continue;
                return xmlConstraint.getStatus();
            }
        }
        return null;
    }

    private Boolean isPseudoUse(XmlStatus status) {
        return XmlStatus.OK != status && XmlStatus.IGNORED != status;
    }

    private SignatureQualityType getSignatureQuality(SignatureWrapper signatureWrapper) {
        SignatureQualification signatureQualification = this.detailedReport.getSignatureQualification(signatureWrapper.getId());
        if (signatureQualification != null) {
            SignatureQualityType signatureQualityType = this.objectFactory.createSignatureQualityType();
            signatureQualityType.getSignatureQualityInformation().add(signatureQualification.getUri());
            return signatureQualityType;
        }
        return null;
    }

    private VOReferenceType getVOReference(SignatureIdentifierType signatureIdentifier) {
        VOReferenceType voRef = this.objectFactory.createVOReferenceType();
        voRef.getVOReference().add(signatureIdentifier);
        return voRef;
    }

    private VOReferenceType getVOReference(ValidationObjectType validationObject) {
        return this.getVOReference(Collections.singletonList(validationObject));
    }

    private VOReferenceType getVOReference(List<ValidationObjectType> validationObjects) {
        VOReferenceType voRef = this.objectFactory.createVOReferenceType();
        for (ValidationObjectType validationObject : validationObjects) {
            voRef.getVOReference().add(validationObject);
        }
        return voRef;
    }

    private SignatureValidationProcessType getSignatureValidationProcess(SignatureWrapper sigWrapper) {
        SignatureValidationProcessType validationProcess = this.objectFactory.createSignatureValidationProcessType();
        validationProcess.setSignatureValidationProcessID(this.getCurrentProcessId(sigWrapper));
        return validationProcess;
    }

    private SignatureValidationProcessID getCurrentProcessId(SignatureWrapper sigWrapper) {
        SignatureValidationProcessID processId = SignatureValidationProcessID.BASIC;
        Indication indicationLTA = this.detailedReport.getArchiveDataValidationIndication(sigWrapper.getId());
        Indication indicationLTVM = this.detailedReport.getLongTermValidationIndication(sigWrapper.getId());
        if (indicationLTA != null) {
            processId = SignatureValidationProcessID.LTA;
        } else if (indicationLTVM != null) {
            processId = SignatureValidationProcessID.LTVM;
        }
        return processId;
    }

    private ValidationObjectListType getSignatureValidationObjects() {
        ValidationObjectListType validationObjectListType = this.objectFactory.createValidationObjectListType();
        POEExtraction poeExtraction = new POEExtraction();
        poeExtraction.init(this.diagnosticData, this.currentTime);
        List<EvidenceRecordWrapper> evidenceRecords = this.diagnosticData.getEvidenceRecords();
        for (EvidenceRecordWrapper evidenceRecord : evidenceRecords) {
            if (Indication.PASSED != this.detailedReport.getEvidenceRecordValidationIndication(evidenceRecord.getId())) continue;
            poeExtraction.extractPOE(evidenceRecord);
        }
        List<TimestampWrapper> timestampList = this.diagnosticData.getNonEvidenceRecordTimestamps();
        poeExtraction.collectAllPOE(timestampList);
        for (EvidenceRecordWrapper evidenceRecord : evidenceRecords) {
            ValidationObjectType evidenceRecordValidationObject = this.getEvidenceRecordValidationObject(evidenceRecord);
            evidenceRecordValidationObject.setPOE(this.getPOE(evidenceRecord.getId(), poeExtraction));
            validationObjectListType.getValidationObject().add(evidenceRecordValidationObject);
        }
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
            ValidationObjectType timestampValidationObject = this.getTimestampValidationObject(timestamp);
            timestampValidationObject.setPOE(this.getPOE(timestamp.getId(), poeExtraction));
            validationObjectListType.getValidationObject().add(timestampValidationObject);
        }
        for (CertificateWrapper certificate : this.diagnosticData.getUsedCertificates()) {
            ValidationObjectType certificateValidationObject = this.getCertificateValidationObject(certificate);
            certificateValidationObject.setPOE(this.getPOE(certificate.getId(), poeExtraction));
            validationObjectListType.getValidationObject().add(certificateValidationObject);
        }
        for (OrphanCertificateTokenWrapper orphanCertificate : this.diagnosticData.getAllOrphanCertificateObjects()) {
            ValidationObjectType orphanCertificateValidationObject = this.getOrphanCertificateValidationObject(orphanCertificate);
            orphanCertificateValidationObject.setPOE(this.getPOE(orphanCertificate.getId(), poeExtraction));
            validationObjectListType.getValidationObject().add(orphanCertificateValidationObject);
        }
        for (RevocationWrapper revocationData : this.diagnosticData.getAllRevocationData()) {
            ValidationObjectType revocationValidationObject = this.getRevocationValidationObject(revocationData);
            revocationValidationObject.setPOE(this.getPOE(revocationData.getId(), poeExtraction));
            validationObjectListType.getValidationObject().add(revocationValidationObject);
        }
        for (OrphanRevocationTokenWrapper orphanRevocation : this.diagnosticData.getAllOrphanRevocationObjects()) {
            ValidationObjectType orphanRevocationValidationObject = this.getOrphanRevocationValidationObject(orphanRevocation);
            orphanRevocationValidationObject.setPOE(this.getPOE(orphanRevocation.getId(), poeExtraction));
            validationObjectListType.getValidationObject().add(orphanRevocationValidationObject);
        }
        for (SignerDataWrapper signedData : this.diagnosticData.getAllSignerDocuments()) {
            ValidationObjectType signerDataValidationObject = this.getSignerDataValidationObject(signedData);
            signerDataValidationObject.setPOE(this.getPOE(signedData.getId(), poeExtraction));
            validationObjectListType.getValidationObject().add(signerDataValidationObject);
        }
        return validationObjectListType;
    }

    private ValidationObjectType getCertificateValidationObject(CertificateWrapper certificate) {
        ValidationObjectType validationObject = this.validationObjectMap.get(certificate.getId());
        if (validationObject == null) {
            validationObject = this.objectFactory.createValidationObjectType();
            this.validationObjectMap.put(certificate.getId(), validationObject);
            validationObject.setId(certificate.getId());
            validationObject.setObjectType(ObjectType.CERTIFICATE);
            ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
            if (Utils.isArrayNotEmpty(certificate.getBinaries())) {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(certificate.getBinaries());
            } else {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(this.getDigestAlgAndValueType(certificate.getDigestAlgoAndValue()));
            }
            validationObject.setValidationObjectRepresentation(representation);
        }
        return validationObject;
    }

    private DigestAlgAndValueType getDigestAlgAndValueType(XmlDigestAlgoAndValue xmlDigestAlgoAndValue) {
        DigestAlgAndValueType digestAlgAndValueType = new DigestAlgAndValueType();
        digestAlgAndValueType.setDigestMethod(this.getDigestMethodType(xmlDigestAlgoAndValue.getDigestMethod()));
        digestAlgAndValueType.setDigestValue(xmlDigestAlgoAndValue.getDigestValue());
        return digestAlgAndValueType;
    }

    private String getUrn(DigestAlgorithm digestAlgorithm) {
        if (digestAlgorithm != null) {
            if (Utils.isStringNotEmpty(digestAlgorithm.getUri())) {
                return digestAlgorithm.getUri();
            }
            if (Utils.isStringNotEmpty(digestAlgorithm.getOid())) {
                return ValidationProcessUtils.toUrnOid(digestAlgorithm.getOid());
            }
        }
        return "?";
    }

    private POEType getPOE(String tokenId, POEExtraction poeExtraction) {
        String evidenceRecordId;
        POEType poeType = this.objectFactory.createPOEType();
        POE lowestPOE = poeExtraction.getLowestPOE(tokenId);
        poeType.setPOETime(lowestPOE.getTime());
        if (lowestPOE instanceof TimestampPOE) {
            String timestampId = lowestPOE.getPOEProviderId();
            if (Utils.isStringNotEmpty(timestampId)) {
                TimestampWrapper timestampWrapper = this.diagnosticData.getTimestampById(timestampId);
                poeType.setPOEObject(this.getVOReference(this.getTimestampValidationObject(timestampWrapper)));
            }
        } else if (lowestPOE instanceof EvidenceRecordPOE && Utils.isStringNotEmpty(evidenceRecordId = lowestPOE.getPOEProviderId())) {
            EvidenceRecordWrapper evidenceRecord = this.diagnosticData.getEvidenceRecordById(evidenceRecordId);
            poeType.setPOEObject(this.getVOReference(this.getEvidenceRecordValidationObject(evidenceRecord)));
        }
        poeType.setTypeOfProof(TypeOfProof.VALIDATION);
        return poeType;
    }

    private ValidationObjectType getEvidenceRecordValidationObject(EvidenceRecordWrapper evidenceRecord) {
        ValidationObjectType validationObject = this.validationObjectMap.get(evidenceRecord.getId());
        if (validationObject == null) {
            validationObject = this.objectFactory.createValidationObjectType();
            this.validationObjectMap.put(evidenceRecord.getId(), validationObject);
            validationObject.setId(evidenceRecord.getId());
            validationObject.setObjectType(ObjectType.EVIDENCE_RECORD);
            ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
            if (Utils.isArrayNotEmpty(evidenceRecord.getBinaries())) {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(evidenceRecord.getBinaries());
            } else {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(this.getDigestAlgAndValueType(evidenceRecord.getDigestAlgoAndValue()));
            }
            validationObject.setValidationObjectRepresentation(representation);
            validationObject.setPOEProvisioning(this.getPOEProvisioningType(evidenceRecord));
            validationObject.setValidationReport(this.getValidationReport(evidenceRecord));
        }
        return validationObject;
    }

    private POEProvisioningType getPOEProvisioningType(EvidenceRecordWrapper evidenceRecord) {
        POEProvisioningType poeProvisioning = this.objectFactory.createPOEProvisioningType();
        poeProvisioning.setPOETime(evidenceRecord.getFirstTimestamp().getProductionTime());
        for (CertificateWrapper certificateWrapper : evidenceRecord.getCoveredCertificates()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getCertificateValidationObject(certificateWrapper)));
        }
        List<OrphanCertificateTokenWrapper> allOrphanObjectCertificates = this.diagnosticData.getAllOrphanCertificateObjects();
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : evidenceRecord.getCoveredOrphanCertificates()) {
            if (!allOrphanObjectCertificates.contains(orphanCertificateTokenWrapper)) continue;
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper)));
        }
        for (RevocationWrapper revocationWrapper : evidenceRecord.getCoveredRevocations()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getRevocationValidationObject(revocationWrapper)));
        }
        List<OrphanRevocationTokenWrapper> list = this.diagnosticData.getAllOrphanRevocationObjects();
        for (OrphanRevocationTokenWrapper orphanRevocation : evidenceRecord.getCoveredOrphanRevocations()) {
            if (!list.contains(orphanRevocation)) continue;
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getOrphanRevocationValidationObject(orphanRevocation)));
        }
        for (EvidenceRecordWrapper er : evidenceRecord.getCoveredEvidenceRecords()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getEvidenceRecordValidationObject(er)));
        }
        for (TimestampWrapper tst : evidenceRecord.getCoveredTimestamps()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getTimestampValidationObject(tst)));
        }
        for (SignerDataWrapper signerData : evidenceRecord.getCoveredSignedData()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getSignerDataValidationObject(signerData)));
        }
        List<SignatureWrapper> list2 = evidenceRecord.getCoveredSignatures();
        for (SignatureWrapper timestampedSignature : list2) {
            poeProvisioning.getSignatureReference().add(this.getSignatureReference(timestampedSignature));
        }
        return poeProvisioning;
    }

    private SignatureValidationReportType getValidationReport(EvidenceRecordWrapper evidenceRecord) {
        XmlEvidenceRecord xmlEvidenceRecord = this.detailedReport.getXmlEvidenceRecordById(evidenceRecord.getId());
        if (xmlEvidenceRecord == null) {
            return null;
        }
        SignatureValidationReportType signatureValidationReport = this.objectFactory.createSignatureValidationReportType();
        signatureValidationReport.setSignatureValidationStatus(this.getValidationStatus(evidenceRecord));
        return signatureValidationReport;
    }

    private ValidationStatusType getValidationStatus(EvidenceRecordWrapper evidenceRecord) {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        this.fillIndicationSubIndication(validationStatus, evidenceRecord.getId());
        this.fillMessages(validationStatus, evidenceRecord.getId());
        this.addValidationReportData(validationStatus, evidenceRecord);
        return validationStatus;
    }

    private void addValidationReportData(ValidationStatusType validationStatus, EvidenceRecordWrapper evidenceRecord) {
        XmlEvidenceRecord xmlEvidenceRecord;
        XmlValidationProcessEvidenceRecord validationProcessEvidenceRecord;
        XmlAOV xmlAOV;
        XmlCryptographicValidation cryptographicValidation;
        ValidationReportDataType validationReportData = this.getAssociatedValidationReportData(validationStatus);
        if (Indication.PASSED != this.detailedReport.getEvidenceRecordValidationIndication(evidenceRecord.getId())) {
            for (TimestampWrapper timestampWrapper : evidenceRecord.getTimestampList()) {
                if (Indication.PASSED == this.detailedReport.getFinalIndication(timestampWrapper.getId())) continue;
                ValidationObjectType timestampValidationObject = this.getTimestampValidationObject(timestampWrapper);
                validationReportData.getRelatedValidationObject().add(this.getVOReference(timestampValidationObject));
            }
        }
        if ((cryptographicValidation = ValidationProcessUtils.getFinalCryptographicValidation(xmlAOV = (validationProcessEvidenceRecord = (xmlEvidenceRecord = this.detailedReport.getXmlEvidenceRecordById(evidenceRecord.getId())).getValidationProcessEvidenceRecord()).getAOV())) != null) {
            this.fillCryptographicInfo(validationReportData, evidenceRecord, cryptographicValidation);
        }
    }

    private void fillCryptographicInfo(ValidationReportDataType validationReportData, EvidenceRecordWrapper evidenceRecord, XmlCryptographicValidation cryptographicValidation) {
        CryptoInformationType cryptoInformationType = this.objectFactory.createCryptoInformationType();
        cryptoInformationType.setValidationObjectId(this.getVOReference(this.getEvidenceRecordValidationObject(evidenceRecord)));
        cryptoInformationType.setSecureAlgorithm(Indication.PASSED == cryptographicValidation.getConclusion().getIndication());
        XmlCryptographicAlgorithm algorithm = cryptographicValidation.getAlgorithm();
        if (algorithm != null) {
            cryptoInformationType.setAlgorithm(algorithm.getUri());
        }
        cryptoInformationType.setNotAfter(cryptographicValidation.getNotAfter());
        validationReportData.setCryptoInformation(cryptoInformationType);
    }

    private ValidationObjectType getTimestampValidationObject(TimestampWrapper timestamp) {
        ValidationObjectType validationObject = this.validationObjectMap.get(timestamp.getId());
        if (validationObject == null) {
            validationObject = this.objectFactory.createValidationObjectType();
            this.validationObjectMap.put(timestamp.getId(), validationObject);
            validationObject.setId(timestamp.getId());
            validationObject.setObjectType(ObjectType.TIMESTAMP);
            ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
            if (Utils.isArrayNotEmpty(timestamp.getBinaries())) {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(timestamp.getBinaries());
            } else {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(this.getDigestAlgAndValueType(timestamp.getDigestAlgoAndValue()));
            }
            validationObject.setValidationObjectRepresentation(representation);
            validationObject.setPOEProvisioning(this.getPOEProvisioningType(timestamp));
            validationObject.setValidationReport(this.getValidationReport(timestamp));
        }
        return validationObject;
    }

    private POEProvisioningType getPOEProvisioningType(TimestampWrapper timestamp) {
        POEProvisioningType poeProvisioning = this.objectFactory.createPOEProvisioningType();
        poeProvisioning.setPOETime(timestamp.getProductionTime());
        for (CertificateWrapper certificateWrapper : timestamp.getTimestampedCertificates()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getCertificateValidationObject(certificateWrapper)));
        }
        List<OrphanCertificateTokenWrapper> allOrphanObjectCertificates = this.diagnosticData.getAllOrphanCertificateObjects();
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : timestamp.getTimestampedOrphanCertificates()) {
            if (!allOrphanObjectCertificates.contains(orphanCertificateTokenWrapper)) continue;
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper)));
        }
        for (RevocationWrapper revocationWrapper : timestamp.getTimestampedRevocations()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getRevocationValidationObject(revocationWrapper)));
        }
        List<OrphanRevocationTokenWrapper> list = this.diagnosticData.getAllOrphanRevocationObjects();
        for (OrphanRevocationTokenWrapper orphanRevocation : timestamp.getTimestampedOrphanRevocations()) {
            if (!list.contains(orphanRevocation)) continue;
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getOrphanRevocationValidationObject(orphanRevocation)));
        }
        for (EvidenceRecordWrapper er : timestamp.getTimestampedEvidenceRecords()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getEvidenceRecordValidationObject(er)));
        }
        for (TimestampWrapper tst : timestamp.getTimestampedTimestamps()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getTimestampValidationObject(tst)));
        }
        for (SignerDataWrapper signerData : timestamp.getTimestampedSignedData()) {
            poeProvisioning.getValidationObject().add(this.getVOReference(this.getSignerDataValidationObject(signerData)));
        }
        List<SignatureWrapper> list2 = timestamp.getTimestampedSignatures();
        for (SignatureWrapper timestampedSignature : list2) {
            poeProvisioning.getSignatureReference().add(this.getSignatureReference(timestampedSignature));
        }
        return poeProvisioning;
    }

    private SignatureReferenceType getSignatureReference(SignatureWrapper signature) {
        SignatureReferenceType signatureReference = this.objectFactory.createSignatureReferenceType();
        XmlSignatureDigestReference signatureDigestReference = signature.getSignatureDigestReference();
        if (signatureDigestReference != null) {
            signatureReference.setCanonicalizationMethod(signatureDigestReference.getCanonicalizationMethod());
            signatureReference.setDigestMethod(signatureDigestReference.getDigestMethod().getUri());
            signatureReference.setDigestValue(signatureDigestReference.getDigestValue());
        } else if (signature.getFirstFieldName() != null) {
            signatureReference.setPAdESFieldName(signature.getFirstFieldName());
        }
        return signatureReference;
    }

    private ValidationObjectType getSignerDataValidationObject(SignerDataWrapper signedData) {
        ValidationObjectType validationObject = this.validationObjectMap.get(signedData.getId());
        if (validationObject == null) {
            validationObject = this.objectFactory.createValidationObjectType();
            this.validationObjectMap.put(signedData.getId(), validationObject);
            validationObject.setId(signedData.getId());
            validationObject.setObjectType(ObjectType.SIGNED_DATA);
            ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
            representation.getDirectOrBase64OrDigestAlgAndValue().add(this.getDigestAlgAndValueType(signedData.getDigestAlgoAndValue()));
            validationObject.setValidationObjectRepresentation(representation);
        }
        return validationObject;
    }

    private ValidationObjectType getRevocationValidationObject(RevocationWrapper revocationData) {
        ValidationObjectType validationObject = this.validationObjectMap.get(revocationData.getId());
        if (validationObject == null) {
            validationObject = this.objectFactory.createValidationObjectType();
            this.validationObjectMap.put(revocationData.getId(), validationObject);
            validationObject.setId(revocationData.getId());
            if (RevocationType.CRL.equals((Object)revocationData.getRevocationType())) {
                validationObject.setObjectType(ObjectType.CRL);
            } else {
                validationObject.setObjectType(ObjectType.OCSP_RESPONSE);
            }
            ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
            if (Utils.isArrayNotEmpty(revocationData.getBinaries())) {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(revocationData.getBinaries());
            } else {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(this.getDigestAlgAndValueType(revocationData.getDigestAlgoAndValue()));
            }
            validationObject.setValidationObjectRepresentation(representation);
            validationObject.setValidationReport(this.getValidationReport(revocationData));
        }
        return validationObject;
    }

    private ValidationObjectType getOrphanCertificateValidationObject(OrphanCertificateTokenWrapper orphanCertificate) {
        return this.createOrphanToken(orphanCertificate, ObjectType.CERTIFICATE);
    }

    private ValidationObjectType getOrphanRevocationValidationObject(OrphanRevocationTokenWrapper orphanRevocation) {
        ObjectType objectType = RevocationType.CRL.equals((Object)orphanRevocation.getRevocationType()) ? ObjectType.CRL : ObjectType.OCSP_RESPONSE;
        return this.createOrphanToken(orphanRevocation, objectType);
    }

    private ValidationObjectType createOrphanToken(OrphanTokenWrapper<?> orphanToken, ObjectType objectType) {
        ValidationObjectType validationObject = this.validationObjectMap.get(orphanToken.getId());
        if (validationObject == null) {
            validationObject = this.objectFactory.createValidationObjectType();
            this.validationObjectMap.put(orphanToken.getId(), validationObject);
            validationObject.setId(orphanToken.getId());
            validationObject.setObjectType(objectType);
            ValidationObjectRepresentationType representation = this.objectFactory.createValidationObjectRepresentationType();
            if (Utils.isArrayNotEmpty(orphanToken.getBinaries())) {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(orphanToken.getBinaries());
            } else {
                representation.getDirectOrBase64OrDigestAlgAndValue().add(this.getDigestAlgAndValueType(orphanToken.getDigestAlgoAndValue()));
            }
            validationObject.setValidationObjectRepresentation(representation);
        }
        return validationObject;
    }

    private ValidationStatusType getValidationStatus(AbstractTokenProxy token) {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        this.fillIndicationSubIndication(validationStatus, token.getId());
        this.fillMessages(validationStatus, token.getId());
        this.addValidationReportData(validationStatus, token);
        return validationStatus;
    }

    private void fillIndicationSubIndication(ValidationStatusType validationStatus, String tokenId) {
        SubIndication finalSubIndication;
        Indication finalIndication = this.detailedReport.getFinalIndication(tokenId);
        if (finalIndication != null) {
            validationStatus.setMainIndication(finalIndication);
        }
        if ((finalSubIndication = this.detailedReport.getFinalSubIndication(tokenId)) != null) {
            validationStatus.getSubIndication().add(finalSubIndication);
        }
    }

    private void fillMessages(ValidationStatusType validationStatus, String tokenId) {
        this.fillMessagesOfType(validationStatus, this.detailedReport.getAdESValidationErrors(tokenId).stream().map(Message::getValue).collect(Collectors.toList()), MessageType.ERROR);
        this.fillMessagesOfType(validationStatus, this.detailedReport.getAdESValidationWarnings(tokenId).stream().map(Message::getValue).collect(Collectors.toList()), MessageType.WARN);
        this.fillMessagesOfType(validationStatus, this.detailedReport.getAdESValidationInfos(tokenId).stream().map(Message::getValue).collect(Collectors.toList()), MessageType.INFO);
    }

    private ValidationStatusType getValidationStatus(XmlConclusion conclusion) {
        ValidationStatusType validationStatus = this.objectFactory.createValidationStatusType();
        this.fillIndicationSubIndication(validationStatus, conclusion);
        this.fillMessages(validationStatus, conclusion);
        return validationStatus;
    }

    private void fillIndicationSubIndication(ValidationStatusType validationStatus, XmlConclusion conclusion) {
        if (conclusion.getIndication() != null) {
            validationStatus.setMainIndication(conclusion.getIndication());
        }
        if (conclusion.getSubIndication() != null) {
            validationStatus.getSubIndication().add(conclusion.getSubIndication());
        }
    }

    private void fillMessages(ValidationStatusType validationStatus, XmlConclusion conclusion) {
        this.fillMessagesOfType(validationStatus, conclusion.getErrors().stream().map(XmlMessage::getValue).collect(Collectors.toList()), MessageType.ERROR);
        this.fillMessagesOfType(validationStatus, conclusion.getWarnings().stream().map(XmlMessage::getValue).collect(Collectors.toList()), MessageType.WARN);
        this.fillMessagesOfType(validationStatus, conclusion.getInfos().stream().map(XmlMessage::getValue).collect(Collectors.toList()), MessageType.INFO);
    }

    private void fillMessagesOfType(ValidationStatusType validationStatus, List<String> messages, MessageType level) {
        if (Utils.isCollectionNotEmpty(messages)) {
            ValidationReportDataType validationReportData = this.getAssociatedValidationReportData(validationStatus);
            AdditionalValidationReportDataType additionalValidationReportData = this.getAdditionalValidationReportData(validationReportData);
            for (String message : messages) {
                TypedDataType reportData = this.objectFactory.createTypedDataType();
                reportData.setType(level.getUri());
                reportData.setValue(message);
                additionalValidationReportData.getReportData().add(reportData);
            }
        }
    }

    private ValidationReportDataType getAssociatedValidationReportData(ValidationStatusType validationStatus) {
        List<ValidationReportDataType> associatedValidationReportData = validationStatus.getAssociatedValidationReportData();
        if (Utils.isCollectionNotEmpty(associatedValidationReportData)) {
            return associatedValidationReportData.get(0);
        }
        ValidationReportDataType validationReportData = this.objectFactory.createValidationReportDataType();
        associatedValidationReportData.add(validationReportData);
        return validationReportData;
    }

    private AdditionalValidationReportDataType getAdditionalValidationReportData(ValidationReportDataType validationReportData) {
        AdditionalValidationReportDataType additionalValidationReportData = validationReportData.getAdditionalValidationReportData();
        if (additionalValidationReportData == null) {
            additionalValidationReportData = this.objectFactory.createAdditionalValidationReportDataType();
            validationReportData.setAdditionalValidationReportData(additionalValidationReportData);
        }
        return additionalValidationReportData;
    }

    private void addValidationReportData(ValidationStatusType validationStatus, AbstractTokenProxy token) {
        XmlBasicBuildingBlocks basicBuildingBlock = this.detailedReport.getBasicBuildingBlockById(token.getId());
        XmlSubXCV signingCertificate = this.detailedReport.getSigningCertificate(token.getId());
        if (basicBuildingBlock != null || signingCertificate != null) {
            ValidationReportDataType validationReportData = this.getAssociatedValidationReportData(validationStatus);
            if (basicBuildingBlock != null) {
                XmlAOV aov;
                XmlCryptographicValidation cryptographicValidation;
                XmlCertificateChain certificateChain = basicBuildingBlock.getCertificateChain();
                if (certificateChain != null) {
                    this.fillCertificateChainAndTrustAnchor(validationReportData, certificateChain);
                }
                if ((cryptographicValidation = ValidationProcessUtils.getFinalCryptographicValidation(aov = basicBuildingBlock.getAOV())) != null) {
                    this.fillCryptographicInfo(validationReportData, token, cryptographicValidation);
                }
            }
            if (signingCertificate != null && signingCertificate.getRevocationInfo() != null) {
                this.fillRevocationInfo(validationReportData, signingCertificate.getRevocationInfo());
            }
        }
    }

    private void fillCryptographicInfo(ValidationReportDataType validationReportData, AbstractTokenProxy token, XmlCryptographicValidation cryptographicValidation) {
        CryptoInformationType cryptoInformationType = this.objectFactory.createCryptoInformationType();
        if (token instanceof SignatureWrapper) {
            cryptoInformationType.setValidationObjectId(this.getVOReference(this.getSignatureIdentifier((SignatureWrapper)token)));
        } else if (token instanceof TimestampWrapper) {
            cryptoInformationType.setValidationObjectId(this.getVOReference(this.getTimestampValidationObject((TimestampWrapper)token)));
        } else if (token instanceof RevocationWrapper) {
            cryptoInformationType.setValidationObjectId(this.getVOReference(this.getRevocationValidationObject((RevocationWrapper)token)));
        } else {
            throw new IllegalArgumentException(String.format("Unsupported class %s", token.getClass()));
        }
        cryptoInformationType.setSecureAlgorithm(Indication.PASSED == cryptographicValidation.getConclusion().getIndication());
        XmlCryptographicAlgorithm algorithm = cryptographicValidation.getAlgorithm();
        if (algorithm != null) {
            cryptoInformationType.setAlgorithm(algorithm.getUri());
        }
        cryptoInformationType.setNotAfter(cryptographicValidation.getNotAfter());
        validationReportData.setCryptoInformation(cryptoInformationType);
    }

    private void fillRevocationInfo(ValidationReportDataType validationReportData, XmlRevocationInformation revocationInfo) {
        RevocationStatusInformationType revocationStatusInformationType = this.objectFactory.createRevocationStatusInformationType();
        revocationStatusInformationType.setRevocationTime(revocationInfo.getRevocationDate());
        RevocationWrapper revocationWrapper = this.diagnosticData.getRevocationById(revocationInfo.getRevocationId());
        revocationStatusInformationType.setRevocationObject(this.getVOReference(this.getRevocationValidationObject(revocationWrapper)));
        CertificateWrapper certificateWrapper = this.diagnosticData.getCertificateById(revocationInfo.getCertificateId());
        revocationStatusInformationType.setValidationObjectId(this.getVOReference(this.getCertificateValidationObject(certificateWrapper)));
        if (revocationInfo.getReason() != null) {
            revocationStatusInformationType.setRevocationReason(revocationInfo.getReason());
        }
        validationReportData.setRevocationStatusInformation(revocationStatusInformationType);
    }

    private void fillCertificateChainAndTrustAnchor(ValidationReportDataType validationReportData, XmlCertificateChain certificateChain) {
        List<XmlChainItem> chainItem = certificateChain.getChainItem();
        if (Utils.isCollectionEmpty(chainItem)) {
            return;
        }
        CertificateChainType certificateChainType = this.objectFactory.createCertificateChainType();
        VOReferenceType signingCert = null;
        VOReferenceType trustAnchor = null;
        for (int i = 0; i < chainItem.size(); ++i) {
            XmlChainItem currentChainItem = chainItem.get(i);
            CertificateWrapper certificateWrapper = this.diagnosticData.getCertificateById(currentChainItem.getId());
            VOReferenceType currentVORef = this.getVOReference(this.getCertificateValidationObject(certificateWrapper));
            boolean isSigningCert = i == 0;
            boolean isTrustAnchor = certificateWrapper.isTrusted();
            if (isSigningCert || isTrustAnchor) {
                if (isSigningCert) {
                    signingCert = currentVORef;
                }
                if (!isTrustAnchor) continue;
                trustAnchor = currentVORef;
                break;
            }
            certificateChainType.getIntermediateCertificate().add(currentVORef);
        }
        certificateChainType.setSigningCertificate(signingCert);
        certificateChainType.setTrustAnchor(trustAnchor);
        validationReportData.setCertificateChain(certificateChainType);
        validationReportData.setTrustAnchor(trustAnchor);
    }

    private SignatureIdentifierType getSignatureIdentifier(SignatureWrapper sigWrapper) {
        SignatureIdentifierType signatureIdentifier = this.signatureIdentifierMap.get(sigWrapper.getId());
        if (signatureIdentifier == null) {
            signatureIdentifier = this.objectFactory.createSignatureIdentifierType();
            this.signatureIdentifierMap.put(sigWrapper.getId(), signatureIdentifier);
            signatureIdentifier.setId(sigWrapper.getId());
            signatureIdentifier.setDAIdentifier(sigWrapper.getDAIdentifier());
            signatureIdentifier.setDocHashOnly(sigWrapper.isDocHashOnly());
            signatureIdentifier.setHashOnly(sigWrapper.isHashOnly());
            signatureIdentifier.setDigestAlgAndValue(this.getDTBSRDigestAlgAndValue(sigWrapper));
            SignatureValueType sigValue = new SignatureValueType();
            sigValue.setValue(sigWrapper.getSignatureValue());
            signatureIdentifier.setSignatureValue(sigValue);
        }
        return signatureIdentifier;
    }

    private DigestAlgAndValueType getDTBSRDigestAlgAndValue(SignatureWrapper sigWrapper) {
        XmlDigestAlgoAndValue dtbsr = sigWrapper.getDataToBeSignedRepresentation();
        if (dtbsr != null) {
            return this.getDigestAlgAndValueType(sigWrapper.getDataToBeSignedRepresentation());
        }
        return null;
    }

    private SignersDocumentType getSignersDocument(SignatureWrapper sigWrapper) {
        List<SignerDataWrapper> signerDocuments = this.diagnosticData.getSignerDocuments(sigWrapper.getId());
        if (Utils.isCollectionEmpty(signerDocuments)) {
            return null;
        }
        SignersDocumentType signersDocumentType = this.objectFactory.createSignersDocumentType();
        if (Utils.collectionSize(signerDocuments) == 1) {
            SignerDataWrapper signerDocument = signerDocuments.get(0);
            DigestAlgAndValueType digestAlgAndValueType = this.getDigestAlgAndValueType(signerDocument.getDigestAlgoAndValue());
            signersDocumentType.getContent().add(this.objectFactory.createSignersDocumentTypeDigestAlgAndValue(digestAlgAndValueType));
        }
        ArrayList<ValidationObjectType> validationObjectList = new ArrayList<ValidationObjectType>();
        List<XmlSignatureScope> signatureScopes = sigWrapper.getSignatureScopes();
        List signerDataList = signatureScopes.stream().map(s -> new SignerDataWrapper(s.getSignerData())).collect(Collectors.toList());
        for (SignerDataWrapper signerDataWrapper : signerDataList) {
            validationObjectList.add(this.getSignerDataValidationObject(signerDataWrapper));
        }
        signersDocumentType.getContent().add(this.objectFactory.createSignersDocumentTypeSignersDocumentRepresentation(this.getVOReference(validationObjectList)));
        return signersDocumentType;
    }

    private SignatureAttributesType getSignatureAttributes(SignatureWrapper sigWrapper) {
        SignatureAttributesType sigAttributes = this.objectFactory.createSignatureAttributesType();
        this.addSigningTime(sigAttributes, sigWrapper);
        this.addSigningCertificate(sigAttributes, sigWrapper);
        this.addDataObjectFormat(sigAttributes, sigWrapper);
        this.addCommitmentTypeIndications(sigAttributes, sigWrapper);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.CONTENT_TIMESTAMP);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP);
        this.addSigPolicyIdentifier(sigAttributes, sigWrapper);
        this.addProductionPlace(sigAttributes, sigWrapper);
        this.addSignerRoles(sigAttributes, sigWrapper);
        this.addCounterSignatures(sigAttributes, sigWrapper);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.SIGNATURE_TIMESTAMP);
        this.addCompleteCertificateRefs(sigAttributes, sigWrapper.foundCertificates());
        this.addCompleteRevocationRefs(sigAttributes, sigWrapper.foundRevocations());
        this.addAttributeCertificateRefs(sigAttributes, sigWrapper.foundCertificates());
        this.addAttributeRevocationRefs(sigAttributes, sigWrapper.foundRevocations());
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.VALIDATION_DATA_TIMESTAMP);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP);
        this.addCertificateValues(sigAttributes, sigWrapper.foundCertificates());
        this.addRevocationValues(sigAttributes, sigWrapper.foundRevocations());
        this.addAttrAuthoritiesCertValues(sigAttributes, sigWrapper.foundCertificates());
        this.addAttributeRevocationValues(sigAttributes, sigWrapper.foundRevocations());
        this.addTimeStampValidationData(sigAttributes, sigWrapper.foundCertificates(), sigWrapper.foundRevocations());
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.ARCHIVE_TIMESTAMP);
        this.addMessageDigest(sigAttributes, sigWrapper);
        this.addDSS(sigAttributes, sigWrapper);
        this.addVRI(sigAttributes, sigWrapper);
        this.addTimestampsByType(sigAttributes, sigWrapper, TimestampType.DOCUMENT_TIMESTAMP);
        this.addReason(sigAttributes, sigWrapper);
        this.addSignerName(sigAttributes, sigWrapper);
        this.addContactInfo(sigAttributes, sigWrapper);
        this.addSubFilter(sigAttributes, sigWrapper);
        this.addSignatureByteRange(sigAttributes, sigWrapper);
        this.addFilter(sigAttributes, sigWrapper);
        return sigAttributes;
    }

    private void addAttrAuthoritiesCertValues(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        ArrayList<ValidationObjectType> validationObjectTypes = new ArrayList<ValidationObjectType>();
        for (CertificateWrapper certificateWrapper : foundCertificates.getRelatedCertificatesByOrigin(CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES)) {
            validationObjectTypes.add(this.getCertificateValidationObject(certificateWrapper));
        }
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : foundCertificates.getOrphanCertificatesByOrigin(CertificateOrigin.ATTR_AUTHORITIES_CERT_VALUES)) {
            validationObjectTypes.add(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper));
        }
        if (Utils.isCollectionNotEmpty(validationObjectTypes)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttrAuthoritiesCertValues(this.buildAttributeObjectList(validationObjectTypes)));
        }
    }

    private void addTimeStampValidationData(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates, FoundRevocationsProxy foundRevocations) {
        ArrayList<ValidationObjectType> validationObjectTypes = new ArrayList<ValidationObjectType>();
        for (CertificateWrapper certificateWrapper : foundCertificates.getRelatedCertificatesByOrigin(CertificateOrigin.TIMESTAMP_VALIDATION_DATA)) {
            validationObjectTypes.add(this.getCertificateValidationObject(certificateWrapper));
        }
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : foundCertificates.getOrphanCertificatesByOrigin(CertificateOrigin.TIMESTAMP_VALIDATION_DATA)) {
            validationObjectTypes.add(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper));
        }
        for (RevocationWrapper revocationWrapper : foundRevocations.getRelatedRevocationsByOrigin(RevocationOrigin.TIMESTAMP_VALIDATION_DATA)) {
            validationObjectTypes.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : foundRevocations.getOrphanRevocationsByOrigin(RevocationOrigin.TIMESTAMP_VALIDATION_DATA)) {
            validationObjectTypes.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        if (Utils.isCollectionNotEmpty(validationObjectTypes)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeTimeStampValidationData(this.buildAttributeObjectList(validationObjectTypes)));
        }
    }

    private void addCertificateValues(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        ArrayList<ValidationObjectType> validationObjectTypes = new ArrayList<ValidationObjectType>();
        for (CertificateWrapper certificateWrapper : foundCertificates.getRelatedCertificatesByOrigin(CertificateOrigin.CERTIFICATE_VALUES)) {
            validationObjectTypes.add(this.getCertificateValidationObject(certificateWrapper));
        }
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : foundCertificates.getOrphanCertificatesByOrigin(CertificateOrigin.CERTIFICATE_VALUES)) {
            validationObjectTypes.add(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper));
        }
        for (CertificateWrapper certificateWrapper : foundCertificates.getRelatedCertificatesByOrigin(CertificateOrigin.ANY_VALIDATION_DATA)) {
            validationObjectTypes.add(this.getCertificateValidationObject(certificateWrapper));
        }
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : foundCertificates.getOrphanCertificatesByOrigin(CertificateOrigin.ANY_VALIDATION_DATA)) {
            validationObjectTypes.add(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper));
        }
        if (Utils.isCollectionNotEmpty(validationObjectTypes)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCertificateValues(this.buildAttributeObjectList(validationObjectTypes)));
        }
    }

    private void addAttributeCertificateRefs(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        List<RelatedCertificateWrapper> relatedCerts = foundCertificates.getRelatedCertificatesByRefOrigin(CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
        List<OrphanCertificateWrapper> orphanCerts = foundCertificates.getOrphanCertificatesByRefOrigin(CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
        if (Utils.isCollectionNotEmpty(relatedCerts) || Utils.isCollectionNotEmpty(orphanCerts)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttributeCertificateRefs(this.buildCertIDListType(relatedCerts, orphanCerts)));
        }
    }

    private void addCompleteCertificateRefs(SignatureAttributesType sigAttributes, FoundCertificatesProxy foundCertificates) {
        List<RelatedCertificateWrapper> relatedCerts = foundCertificates.getRelatedCertificatesByRefOrigin(CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
        List<OrphanCertificateWrapper> orphanCerts = foundCertificates.getOrphanCertificatesByRefOrigin(CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
        if (Utils.isCollectionNotEmpty(relatedCerts) || Utils.isCollectionNotEmpty(orphanCerts)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCompleteCertificateRefs(this.buildCertIDListType(relatedCerts, orphanCerts)));
        }
    }

    private void addSigningCertificate(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        FoundCertificatesProxy foundCertificates = sigWrapper.foundCertificates();
        List<RelatedCertificateWrapper> relatedCerts = foundCertificates.getRelatedCertificatesByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        List<OrphanCertificateWrapper> orphanCerts = foundCertificates.getOrphanCertificatesByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        if (Utils.isCollectionNotEmpty(relatedCerts) || Utils.isCollectionNotEmpty(orphanCerts)) {
            JAXBElement<SACertIDListType> signingCertAttribute = this.objectFactory.createSignatureAttributesTypeSigningCertificate(this.buildCertIDListType(relatedCerts, orphanCerts));
            if (sigWrapper.isBLevelTechnicallyValid()) {
                signingCertAttribute.getValue().setSigned(true);
            }
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(signingCertAttribute);
        }
    }

    private AttributeBaseType buildAttributeObjectList(List<ValidationObjectType> validationObjects) {
        AttributeBaseType attributeBaseType = this.objectFactory.createAttributeBaseType();
        for (ValidationObjectType validationObjectType : validationObjects) {
            attributeBaseType.getAttributeObject().add(this.getVOReference(Collections.singletonList(validationObjectType)));
        }
        return attributeBaseType;
    }

    private SACertIDListType buildCertIDListType(List<RelatedCertificateWrapper> relatedCerts, List<OrphanCertificateWrapper> orphanCerts) {
        SACertIDListType certIdList = this.objectFactory.createSACertIDListType();
        ArrayList<ValidationObjectType> validationObjects = new ArrayList<ValidationObjectType>();
        if (Utils.isCollectionNotEmpty(relatedCerts)) {
            for (CertificateWrapper certificateWrapper : relatedCerts) {
                validationObjects.add(this.getCertificateValidationObject(certificateWrapper));
            }
        }
        if (Utils.isCollectionNotEmpty(orphanCerts)) {
            List<OrphanCertificateTokenWrapper> allOrphanCertificates = this.diagnosticData.getAllOrphanCertificateObjects();
            for (OrphanCertificateWrapper orphanCert : orphanCerts) {
                if (orphanCert == null) continue;
                if (Utils.isCollectionNotEmpty(orphanCert.getReferences()) && !allOrphanCertificates.contains(orphanCert)) {
                    for (CertificateRefWrapper certRef : orphanCert.getReferences()) {
                        certIdList.getCertID().add(this.buildCertIDType(certRef.getDigestAlgoAndValue(), certRef.getIssuerSerial()));
                    }
                    continue;
                }
                validationObjects.add(this.getOrphanCertificateValidationObject(orphanCert));
            }
        }
        if (Utils.isCollectionNotEmpty(validationObjects)) {
            certIdList.getAttributeObject().add(this.getVOReference(validationObjects));
        }
        return certIdList;
    }

    private SACertIDType buildCertIDType(XmlDigestAlgoAndValue digestAlgoAndValue, byte[] issuerSerial) {
        SACertIDType certIDType = this.objectFactory.createSACertIDType();
        certIDType.setDigestMethod(this.getDigestMethodType(digestAlgoAndValue.getDigestMethod()));
        certIDType.setDigestValue(digestAlgoAndValue.getDigestValue());
        if (issuerSerial != null) {
            certIDType.setX509IssuerSerial(issuerSerial);
        }
        return certIDType;
    }

    private void addCompleteRevocationRefs(SignatureAttributesType sigAttributes, FoundRevocationsProxy revocationsProxy) {
        List<RelatedRevocationWrapper> relatedRevs = revocationsProxy.getRelatedRevocationsByRefOrigin(RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        List<OrphanRevocationWrapper> orphanRevs = revocationsProxy.getOrphanRevocationsByRefOrigin(RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        if (Utils.isCollectionNotEmpty(relatedRevs) || Utils.isCollectionNotEmpty(orphanRevs)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCompleteRevocationRefs(this.buildRevIDListType(relatedRevs, orphanRevs)));
        }
    }

    private void addAttributeRevocationRefs(SignatureAttributesType sigAttributes, FoundRevocationsProxy revocationsProxy) {
        List<RelatedRevocationWrapper> relatedRevs = revocationsProxy.getRelatedRevocationsByRefOrigin(RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        List<OrphanRevocationWrapper> orphanRevs = revocationsProxy.getOrphanRevocationsByRefOrigin(RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        if (Utils.isCollectionNotEmpty(relatedRevs) || Utils.isCollectionNotEmpty(orphanRevs)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttributeRevocationRefs(this.buildRevIDListType(relatedRevs, orphanRevs)));
        }
    }

    private SARevIDListType buildRevIDListType(List<RelatedRevocationWrapper> relatedRevs, List<OrphanRevocationWrapper> orphanRevs) {
        SARevIDListType revIDListType = this.objectFactory.createSARevIDListType();
        ArrayList<ValidationObjectType> validationObjects = new ArrayList<ValidationObjectType>();
        if (Utils.isCollectionNotEmpty(relatedRevs)) {
            for (RevocationWrapper revocationWrapper : relatedRevs) {
                validationObjects.add(this.getRevocationValidationObject(revocationWrapper));
            }
        }
        if (Utils.isCollectionNotEmpty(orphanRevs)) {
            List<OrphanRevocationTokenWrapper> allOrphanRevocations = this.diagnosticData.getAllOrphanRevocationObjects();
            for (OrphanRevocationWrapper orphanRev : orphanRevs) {
                if (orphanRev == null) continue;
                if (Utils.isCollectionNotEmpty(orphanRev.getReferences()) && !allOrphanRevocations.contains(orphanRev)) {
                    for (RevocationRefWrapper revRef : orphanRev.getReferences()) {
                        Serializable revID = RevocationType.CRL.equals((Object)orphanRev.getRevocationType()) ? this.buildCRLID(revRef.getDigestAlgoAndValue()) : this.buildOCSPID(revRef);
                        if (revID == null) continue;
                        revIDListType.getCRLIDOrOCSPID().add(revID);
                    }
                    continue;
                }
                validationObjects.add(this.getOrphanRevocationValidationObject(orphanRev));
            }
        }
        if (Utils.isCollectionNotEmpty(validationObjects)) {
            revIDListType.getAttributeObject().add(this.getVOReference(validationObjects));
        }
        return revIDListType;
    }

    private SACRLIDType buildCRLID(XmlDigestAlgoAndValue digestAlgoAndValue) {
        SACRLIDType sacrlidType = this.objectFactory.createSACRLIDType();
        sacrlidType.setDigestMethod(this.getDigestMethodType(digestAlgoAndValue.getDigestMethod()));
        sacrlidType.setDigestValue(digestAlgoAndValue.getDigestValue());
        return sacrlidType;
    }

    private SAOCSPIDType buildOCSPID(RevocationRefWrapper revRef) {
        if (Utils.isStringNotEmpty(revRef.getResponderIdName()) || Utils.isArrayNotEmpty(revRef.getResponderIdKey())) {
            SAOCSPIDType saocspidType = this.objectFactory.createSAOCSPIDType();
            saocspidType.setProducedAt(revRef.getProductionTime());
            if (Utils.isStringNotEmpty(revRef.getResponderIdName())) {
                saocspidType.setResponderIDByName(revRef.getResponderIdName());
            } else {
                saocspidType.setResponderIDByKey(revRef.getResponderIdKey());
            }
            return saocspidType;
        }
        return null;
    }

    private DigestMethodType getDigestMethodType(DigestAlgorithm digestAlgorithm) {
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(this.getUrn(digestAlgorithm));
        return digestMethodType;
    }

    private void addRevocationValues(SignatureAttributesType sigAttributes, FoundRevocationsProxy foundRevocations) {
        ArrayList<ValidationObjectType> validationObjects = new ArrayList<ValidationObjectType>();
        for (RevocationWrapper revocationWrapper : foundRevocations.getRelatedRevocationsByOrigin(RevocationOrigin.REVOCATION_VALUES)) {
            validationObjects.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : foundRevocations.getOrphanRevocationsByOrigin(RevocationOrigin.REVOCATION_VALUES)) {
            validationObjects.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        for (RevocationWrapper revocationWrapper : foundRevocations.getRelatedRevocationsByOrigin(RevocationOrigin.ANY_VALIDATION_DATA)) {
            validationObjects.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : foundRevocations.getOrphanRevocationsByOrigin(RevocationOrigin.ANY_VALIDATION_DATA)) {
            validationObjects.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        if (Utils.isCollectionNotEmpty(validationObjects)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeRevocationValues(this.buildAttributeObjectList(validationObjects)));
        }
    }

    private void addAttributeRevocationValues(SignatureAttributesType sigAttributes, FoundRevocationsProxy foundRevocations) {
        ArrayList<ValidationObjectType> validationObjects = new ArrayList<ValidationObjectType>();
        for (RevocationWrapper revocationWrapper : foundRevocations.getRelatedRevocationsByOrigin(RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES)) {
            validationObjects.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : foundRevocations.getOrphanRevocationsByOrigin(RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES)) {
            validationObjects.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        if (Utils.isCollectionNotEmpty(validationObjects)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeAttributeRevocationValues(this.buildAttributeObjectList(validationObjects)));
        }
    }

    private void addMessageDigest(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        XmlDigestMatcher messageDigest = sigWrapper.getMessageDigest();
        if (messageDigest != null && messageDigest.getDigestValue() != null) {
            SAMessageDigestType messageDigestType = this.objectFactory.createSAMessageDigestType();
            messageDigestType.setDigest(messageDigest.getDigestValue());
            this.setSignedIfValid(sigWrapper, messageDigestType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeMessageDigest(messageDigestType));
        }
    }

    private void addTimestampsByType(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper, TimestampType timestampType) {
        List<TimestampWrapper> timestampListByType = sigWrapper.getTimestampListByType(timestampType);
        boolean isSigned = sigWrapper.isBLevelTechnicallyValid() && timestampType.isContentTimestamp();
        for (TimestampWrapper timestampWrapper : timestampListByType) {
            SATimestampType timestamp = this.getSATimestampType(timestampWrapper);
            JAXBElement<SATimestampType> wrap = this.wrap(timestampType, timestamp);
            if (isSigned) {
                wrap.getValue().setSigned(isSigned);
            }
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(wrap);
        }
    }

    private SATimestampType getSATimestampType(TimestampWrapper timestampWrapper) {
        SATimestampType timestamp = this.objectFactory.createSATimestampType();
        timestamp.setTimeStampValue(timestampWrapper.getProductionTime());
        timestamp.getAttributeObject().add(this.getVOReference(this.getTimestampValidationObject(timestampWrapper)));
        return timestamp;
    }

    private JAXBElement<SATimestampType> wrap(TimestampType timestampType, SATimestampType timestamp) {
        switch (timestampType) {
            case SIGNATURE_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeSignatureTimeStamp(timestamp);
            }
            case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeIndividualDataObjectsTimeStamp(timestamp);
            }
            case ALL_DATA_OBJECTS_TIMESTAMP: 
            case CONTENT_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeAllDataObjectsTimeStamp(timestamp);
            }
            case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeRefsOnlyTimeStamp(timestamp);
            }
            case VALIDATION_DATA_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeSigAndRefsTimeStamp(timestamp);
            }
            case ARCHIVE_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeArchiveTimeStamp(timestamp);
            }
            case DOCUMENT_TIMESTAMP: {
                return this.objectFactory.createSignatureAttributesTypeDocTimeStamp(timestamp);
            }
        }
        throw new IllegalArgumentException("Unsupported timestamp type " + (Object)((Object)timestampType));
    }

    private void addSigPolicyIdentifier(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String policyId = sigWrapper.getPolicyId();
        if (Utils.isStringNotEmpty(policyId) && !SignaturePolicyType.IMPLICIT_POLICY.name().equals(policyId)) {
            SASigPolicyIdentifierType saSigPolicyIdentifierType = this.objectFactory.createSASigPolicyIdentifierType();
            saSigPolicyIdentifierType.setSigPolicyId(policyId);
            this.setSignedIfValid(sigWrapper, saSigPolicyIdentifierType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSigPolicyIdentifier(saSigPolicyIdentifierType));
        }
    }

    private void addDataObjectFormat(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String contentType = sigWrapper.getContentType();
        String mimeType = sigWrapper.getMimeType();
        if (Utils.isStringNotEmpty(contentType) || Utils.isStringNotEmpty(mimeType)) {
            SADataObjectFormatType dataObjectFormatType = this.objectFactory.createSADataObjectFormatType();
            if (Utils.isStringNotEmpty(contentType)) {
                dataObjectFormatType.setContentType(contentType);
            }
            if (Utils.isStringNotEmpty(mimeType)) {
                dataObjectFormatType.setMimeType(mimeType);
            }
            this.setSignedIfValid(sigWrapper, dataObjectFormatType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeDataObjectFormat(dataObjectFormatType));
        }
    }

    private void addCommitmentTypeIndications(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<XmlCommitmentTypeIndication> commitmentTypeIndications = sigWrapper.getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            for (XmlCommitmentTypeIndication commitmentTypeIndication : commitmentTypeIndications) {
                SACommitmentTypeIndicationType commitmentType = this.objectFactory.createSACommitmentTypeIndicationType();
                commitmentType.setCommitmentTypeIdentifier(commitmentTypeIndication.getIdentifier());
                this.setSignedIfValid(sigWrapper, commitmentType);
                sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCommitmentTypeIndication(commitmentType));
            }
        }
    }

    private void addSignerRoles(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<XmlSignerRole> signerRoles = sigWrapper.getSignerRoles();
        if (Utils.isCollectionNotEmpty(signerRoles)) {
            SASignerRoleType signerRoleType = this.objectFactory.createSASignerRoleType();
            for (XmlSignerRole role : signerRoles) {
                SAOneSignerRoleType oneSignerRole = this.objectFactory.createSAOneSignerRoleType();
                oneSignerRole.setRole(role.getRole());
                oneSignerRole.setEndorsementType(role.getCategory());
                signerRoleType.getRoleDetails().add(oneSignerRole);
            }
            this.setSignedIfValid(sigWrapper, signerRoleType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSignerRole(signerRoleType));
        }
    }

    private void addCounterSignatures(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        Set<SignatureWrapper> counterSignatures = this.diagnosticData.getAllCounterSignaturesForMasterSignature(sigWrapper);
        for (SignatureWrapper counterSignature : counterSignatures) {
            SACounterSignatureType saCounterSignatureType = this.objectFactory.createSACounterSignatureType();
            saCounterSignatureType.getAttributeObject().add(this.getVOReference(this.getSignatureIdentifier(counterSignature)));
            SignatureReferenceType signatureReference = this.getSignatureReference(counterSignature);
            saCounterSignatureType.setCounterSignature(signatureReference);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeCounterSignature(saCounterSignatureType));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addProductionPlace(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        SASignatureProductionPlaceType sigProductionPlace = this.objectFactory.createSASignatureProductionPlaceType();
        if (sigWrapper.getPDFRevision() != null) {
            String location = sigWrapper.getLocation();
            if (!Utils.isStringNotEmpty(location)) return;
            sigProductionPlace.getAddressString().add(location);
        } else {
            if (!sigWrapper.isSignatureProductionPlacePresent()) return;
            List<String> postalAddress = sigWrapper.getPostalAddress();
            String streetAddress = sigWrapper.getStreetAddress();
            String city = sigWrapper.getCity();
            String stateOrProvince = sigWrapper.getStateOrProvince();
            String postOfficeBoxNumber = sigWrapper.getPostOfficeBoxNumber();
            String postalCode = sigWrapper.getPostalCode();
            String countryName = sigWrapper.getCountryName();
            if (Utils.isCollectionEmpty(postalAddress) && Utils.areAllStringsEmpty(streetAddress, city, stateOrProvince, postOfficeBoxNumber, postalCode, countryName)) {
                return;
            }
            if (Utils.isStringNotEmpty(countryName)) {
                sigProductionPlace.getAddressString().add(countryName);
            }
            if (Utils.isStringNotEmpty(stateOrProvince)) {
                sigProductionPlace.getAddressString().add(stateOrProvince);
            }
            if (Utils.isStringNotEmpty(city)) {
                sigProductionPlace.getAddressString().add(city);
            }
            if (Utils.isStringNotEmpty(streetAddress)) {
                sigProductionPlace.getAddressString().add(streetAddress);
            }
            if (Utils.isCollectionNotEmpty(postalAddress)) {
                sigProductionPlace.getAddressString().addAll(postalAddress);
            }
            if (Utils.isStringNotEmpty(postalCode)) {
                sigProductionPlace.getAddressString().add(postalCode);
            }
            if (Utils.isStringNotEmpty(postOfficeBoxNumber)) {
                sigProductionPlace.getAddressString().add(postOfficeBoxNumber);
            }
        }
        this.setSignedIfValid(sigWrapper, sigProductionPlace);
        sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSignatureProductionPlace(sigProductionPlace));
    }

    private void addFilter(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String filter = sigWrapper.getFilter();
        if (Utils.isStringNotEmpty(filter)) {
            SAFilterType filterType = this.objectFactory.createSAFilterType();
            filterType.setFilter(filter);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeFilter(filterType));
        }
    }

    private void addSubFilter(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String subFilter = sigWrapper.getSubFilter();
        if (Utils.isStringNotEmpty(subFilter)) {
            SASubFilterType subFilterType = this.objectFactory.createSASubFilterType();
            subFilterType.setSubFilterElement(subFilter);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSubFilter(subFilterType));
        }
    }

    private void addContactInfo(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String contactInfo = sigWrapper.getContactInfo();
        if (Utils.isStringNotEmpty(contactInfo)) {
            SAContactInfoType contactInfoType = this.objectFactory.createSAContactInfoType();
            contactInfoType.setContactInfoElement(contactInfo);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeContactInfo(contactInfoType));
        }
    }

    private void addSignerName(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String signerName = sigWrapper.getSignerName();
        if (Utils.isStringNotEmpty(signerName)) {
            SANameType nameType = this.objectFactory.createSANameType();
            nameType.setNameElement(signerName);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeName(nameType));
        }
    }

    private void addReason(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        String reason = sigWrapper.getReason();
        if (Utils.isStringNotEmpty(reason)) {
            SAReasonType reasonType = this.objectFactory.createSAReasonType();
            reasonType.setReasonElement(reason);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeReason(reasonType));
        }
    }

    private void addSignatureByteRange(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        List<BigInteger> signatureByteRange = sigWrapper.getSignatureByteRange();
        if (Utils.isCollectionNotEmpty(signatureByteRange)) {
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeByteRange(signatureByteRange));
        }
    }

    private void addDSS(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        ArrayList<ValidationObjectType> certificateValidationObjects = new ArrayList<ValidationObjectType>();
        for (CertificateWrapper certificateWrapper : sigWrapper.foundCertificates().getRelatedCertificatesByOrigin(CertificateOrigin.DSS_DICTIONARY)) {
            certificateValidationObjects.add(this.getCertificateValidationObject(certificateWrapper));
        }
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : sigWrapper.foundCertificates().getOrphanCertificatesByOrigin(CertificateOrigin.DSS_DICTIONARY)) {
            certificateValidationObjects.add(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper));
        }
        ArrayList<ValidationObjectType> crlValidationObjects = new ArrayList<ValidationObjectType>();
        for (RevocationWrapper revocationWrapper : sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.DSS_DICTIONARY)) {
            crlValidationObjects.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.DSS_DICTIONARY)) {
            crlValidationObjects.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        ArrayList<ValidationObjectType> arrayList = new ArrayList<ValidationObjectType>();
        for (RevocationWrapper revocationWrapper : sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.DSS_DICTIONARY)) {
            arrayList.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.DSS_DICTIONARY)) {
            arrayList.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        if (Utils.isCollectionNotEmpty(certificateValidationObjects) || Utils.isCollectionNotEmpty(crlValidationObjects) || Utils.isCollectionNotEmpty(arrayList)) {
            SADSSType sADSSType = this.objectFactory.createSADSSType();
            if (Utils.isCollectionNotEmpty(certificateValidationObjects)) {
                sADSSType.setCerts(this.getVOReference(certificateValidationObjects));
            }
            if (Utils.isCollectionNotEmpty(crlValidationObjects)) {
                sADSSType.setCRLs(this.getVOReference(crlValidationObjects));
            }
            if (Utils.isCollectionNotEmpty(arrayList)) {
                sADSSType.setOCSPs(this.getVOReference(arrayList));
            }
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeDSS(sADSSType));
        }
    }

    private void addVRI(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        ArrayList<ValidationObjectType> certificateValidationObjects = new ArrayList<ValidationObjectType>();
        for (CertificateWrapper certificateWrapper : sigWrapper.foundCertificates().getRelatedCertificatesByOrigin(CertificateOrigin.VRI_DICTIONARY)) {
            certificateValidationObjects.add(this.getCertificateValidationObject(certificateWrapper));
        }
        for (OrphanCertificateTokenWrapper orphanCertificateTokenWrapper : sigWrapper.foundCertificates().getOrphanCertificatesByOrigin(CertificateOrigin.VRI_DICTIONARY)) {
            certificateValidationObjects.add(this.getOrphanCertificateValidationObject(orphanCertificateTokenWrapper));
        }
        ArrayList<ValidationObjectType> crlValidationObjects = new ArrayList<ValidationObjectType>();
        for (RevocationWrapper revocationWrapper : sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.VRI_DICTIONARY)) {
            crlValidationObjects.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.CRL, RevocationOrigin.VRI_DICTIONARY)) {
            crlValidationObjects.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        ArrayList<ValidationObjectType> arrayList = new ArrayList<ValidationObjectType>();
        for (RevocationWrapper revocationWrapper : sigWrapper.foundRevocations().getRelatedRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.VRI_DICTIONARY)) {
            arrayList.add(this.getRevocationValidationObject(revocationWrapper));
        }
        for (OrphanRevocationTokenWrapper orphanRevocationTokenWrapper : sigWrapper.foundRevocations().getOrphanRevocationsByTypeAndOrigin(RevocationType.OCSP, RevocationOrigin.VRI_DICTIONARY)) {
            arrayList.add(this.getOrphanRevocationValidationObject(orphanRevocationTokenWrapper));
        }
        if (Utils.isCollectionNotEmpty(certificateValidationObjects) || Utils.isCollectionNotEmpty(crlValidationObjects) || Utils.isCollectionNotEmpty(arrayList)) {
            SAVRIType sAVRIType = this.objectFactory.createSAVRIType();
            if (Utils.isCollectionNotEmpty(certificateValidationObjects)) {
                sAVRIType.setCerts(this.getVOReference(certificateValidationObjects));
            }
            if (Utils.isCollectionNotEmpty(crlValidationObjects)) {
                sAVRIType.setCRLs(this.getVOReference(crlValidationObjects));
            }
            if (Utils.isCollectionNotEmpty(arrayList)) {
                sAVRIType.setOCSPs(this.getVOReference(arrayList));
            }
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeVRI(sAVRIType));
        }
    }

    private void addSigningTime(SignatureAttributesType sigAttributes, SignatureWrapper sigWrapper) {
        Date signingTime = sigWrapper.getClaimedSigningTime();
        if (signingTime != null) {
            SASigningTimeType saSigningTimeType = this.objectFactory.createSASigningTimeType();
            saSigningTimeType.setTime(signingTime);
            this.setSignedIfValid(sigWrapper, saSigningTimeType);
            sigAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat().add(this.objectFactory.createSignatureAttributesTypeSigningTime(saSigningTimeType));
        }
    }

    private void setSignedIfValid(SignatureWrapper sigWrapper, AttributeBaseType attribute) {
        if (sigWrapper.isBLevelTechnicallyValid()) {
            attribute.setSigned(true);
        }
    }
}

