/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor.certificate;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustServiceProvider;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.jaxb.object.Message;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlChainItem;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlConnectionDetails;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlDetails;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlMessage;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlRevocation;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSignature;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSimpleCertificateReport;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSubject;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlTrustAnchor;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleReportForCertificateBuilder {
    private final DiagnosticData diagnosticData;
    private final DetailedReport detailedReport;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final String certificateId;

    public SimpleReportForCertificateBuilder(DiagnosticData diagnosticData, DetailedReport detailedReport, ValidationPolicy policy, Date currentTime, String certificateId) {
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
        this.policy = policy;
        this.currentTime = currentTime;
        this.certificateId = certificateId;
    }

    public XmlSimpleCertificateReport build() {
        XmlSimpleCertificateReport simpleReport = new XmlSimpleCertificateReport();
        this.addPolicyNode(simpleReport);
        this.addValidationTime(simpleReport);
        simpleReport.setValidationTime(this.currentTime);
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        XmlChainItem targetCertificate = this.getChainItem(certificate, false);
        this.addQualifications(targetCertificate, certificate);
        this.addQWACValidationDetails(targetCertificate, certificate);
        simpleReport.setCertificate(targetCertificate);
        ArrayList<XmlChainItem> chain = new ArrayList<XmlChainItem>();
        boolean trustAnchorReached = false;
        List<CertificateWrapper> certificateChain = certificate.getCertificateChain();
        for (CertificateWrapper cert : certificateChain) {
            chain.add(this.getChainItem(cert, trustAnchorReached |= cert.isTrusted()));
        }
        targetCertificate.setChain(chain);
        this.addConnectionDetails(simpleReport);
        return simpleReport;
    }

    private void addPolicyNode(XmlSimpleCertificateReport report) {
        XmlValidationPolicy xmlPolicy = new XmlValidationPolicy();
        xmlPolicy.setPolicyName(this.policy.getPolicyName());
        xmlPolicy.setPolicyDescription(this.policy.getPolicyDescription());
        report.setValidationPolicy(xmlPolicy);
    }

    private void addValidationTime(XmlSimpleCertificateReport report) {
        report.setValidationTime(this.currentTime);
    }

    private XmlChainItem getChainItem(CertificateWrapper certificate, boolean trustAnchorReached) {
        XmlChainItem item = new XmlChainItem();
        item.setId(certificate.getId());
        item.setSubject(this.getSubject(certificate));
        CertificateWrapper signingCertificate = certificate.getSigningCertificate();
        if (signingCertificate != null) {
            item.setIssuerId(signingCertificate.getId());
        }
        item.setNotBefore(certificate.getNotBefore());
        item.setNotAfter(certificate.getNotAfter());
        item.setKeyUsages(certificate.getKeyUsages());
        item.setExtendedKeyUsages(this.getReadable(certificate.getExtendedKeyUsages()));
        item.setAiaUrls(this.emptyToNull(certificate.getCAIssuersAccessUrls()));
        item.setOcspUrls(this.emptyToNull(certificate.getOCSPAccessUrls()));
        item.setCrlUrls(this.emptyToNull(certificate.getCRLDistributionPoints()));
        item.setCpsUrls(this.emptyToNull(certificate.getCpsUrls()));
        item.setPdsUrls(null);
        XmlRevocation revocation = new XmlRevocation();
        CertificateRevocationWrapper revocationData = this.diagnosticData.getLatestRevocationDataForCertificate(certificate);
        if (revocationData != null) {
            revocation.setThisUpdate(revocationData.getThisUpdate());
            revocation.setRevocationDate(revocationData.getRevocationDate());
            revocation.setRevocationReason(revocationData.getReason());
        }
        item.setRevocation(revocation);
        if (certificate.isTrusted()) {
            List<XmlTrustServiceProvider> trustServiceProviders = this.filterByCertificateId(certificate.getTrustServiceProviders(), certificate.getId());
            ArrayList<XmlTrustAnchor> trustAnchors = new ArrayList<XmlTrustAnchor>();
            for (XmlTrustServiceProvider xmlTrustServiceProvider : trustServiceProviders) {
                List<XmlTrustService> trustServices = xmlTrustServiceProvider.getTrustServices();
                Set<String> uniqueServiceNames = this.getUniqueServiceNames(trustServices);
                for (String serviceName : uniqueServiceNames) {
                    XmlTrustAnchor trustAnchor = new XmlTrustAnchor();
                    if (xmlTrustServiceProvider.getTL() != null) {
                        trustAnchor.setCountryCode(xmlTrustServiceProvider.getTL().getCountryCode());
                        trustAnchor.setTslType(xmlTrustServiceProvider.getTL().getTSLType());
                    }
                    trustAnchor.setTrustServiceProvider(this.getEnOrFirst(xmlTrustServiceProvider.getTSPNames()));
                    List<String> tspRegistrationIdentifiers = xmlTrustServiceProvider.getTSPRegistrationIdentifiers();
                    if (Utils.isCollectionNotEmpty(tspRegistrationIdentifiers)) {
                        trustAnchor.setTrustServiceProviderRegistrationId(tspRegistrationIdentifiers.get(0));
                    }
                    trustAnchor.setTrustServiceName(serviceName);
                    trustAnchors.add(trustAnchor);
                }
            }
            item.setTrustAnchors(trustAnchors);
            item.setTrustStartDate(certificate.getTrustStartDate());
            item.setTrustSunsetDate(certificate.getTrustSunsetDate());
        } else {
            item.setTrustAnchors(null);
        }
        XmlConclusion conclusion = this.detailedReport.getCertificateXCVConclusion(certificate.getId());
        if (conclusion != null) {
            item.setIndication(conclusion.getIndication());
            item.setSubIndication(conclusion.getSubIndication());
        } else if (certificate.isTrusted() || trustAnchorReached) {
            item.setIndication(Indication.PASSED);
        } else {
            item.setIndication(Indication.INDETERMINATE);
            item.setSubIndication(SubIndication.NO_CERTIFICATE_CHAIN_FOUND);
        }
        XmlDetails validationDetails = this.getValidationDetails(certificate.getId());
        if (this.isNotEmpty(validationDetails)) {
            item.setX509ValidationDetails(validationDetails);
        }
        return item;
    }

    private String getEnOrFirst(List<XmlLangAndValue> langAndValues) {
        if (Utils.isCollectionNotEmpty(langAndValues)) {
            for (XmlLangAndValue langAndValue : langAndValues) {
                if (langAndValue.getLang() == null || !"en".equalsIgnoreCase(langAndValue.getLang())) continue;
                return langAndValue.getValue();
            }
            return langAndValues.get(0).getValue();
        }
        return null;
    }

    private List<XmlTrustServiceProvider> filterByCertificateId(List<XmlTrustServiceProvider> trustServiceProviders, String certificateId) {
        ArrayList<XmlTrustServiceProvider> result = new ArrayList<XmlTrustServiceProvider>();
        for (XmlTrustServiceProvider xmlTrustServiceProvider : trustServiceProviders) {
            List<XmlTrustService> trustServices = xmlTrustServiceProvider.getTrustServices();
            boolean foundCertId = false;
            for (XmlTrustService xmlTrustService : trustServices) {
                if (!Utils.areStringsEqual(certificateId, xmlTrustService.getServiceDigitalIdentifier().getId())) continue;
                foundCertId = true;
                break;
            }
            if (!foundCertId) continue;
            result.add(xmlTrustServiceProvider);
        }
        return result;
    }

    private List<String> getReadable(List<XmlOID> oids) {
        if (Utils.isCollectionNotEmpty(oids)) {
            ArrayList<String> result = new ArrayList<String>();
            for (XmlOID xmlOID : oids) {
                if (Utils.isStringNotEmpty(xmlOID.getDescription())) {
                    result.add(xmlOID.getDescription());
                    continue;
                }
                result.add(xmlOID.getValue());
            }
            return result;
        }
        return null;
    }

    private Set<String> getUniqueServiceNames(List<XmlTrustService> trustServices) {
        HashSet<String> result = new HashSet<String>();
        for (XmlTrustService xmlTrustService : trustServices) {
            result.add(this.getEnOrFirst(xmlTrustService.getServiceNames()));
        }
        return result;
    }

    private XmlSubject getSubject(CertificateWrapper certificate) {
        XmlSubject subject = new XmlSubject();
        subject.setCommonName(certificate.getCommonName());
        subject.setPseudonym(certificate.getPseudo());
        subject.setSurname(certificate.getSurname());
        subject.setGivenName(certificate.getGivenName());
        subject.setOrganizationName(certificate.getOrganizationName());
        subject.setOrganizationUnit(certificate.getOrganizationalUnit());
        subject.setEmail(certificate.getEmail());
        subject.setLocality(certificate.getLocality());
        subject.setState(certificate.getState());
        subject.setCountry(certificate.getCountryName());
        return subject;
    }

    private List<String> emptyToNull(List<String> listUrls) {
        if (Utils.isCollectionEmpty(listUrls)) {
            return null;
        }
        return listUrls;
    }

    private void addQualifications(XmlChainItem chainItem, CertificateWrapper certificate) {
        XmlDetails qualificationDetailsAtValidationTime;
        chainItem.setQualificationAtIssuance(this.detailedReport.getCertificateQualificationAtIssuance(certificate.getId()));
        chainItem.setQualificationAtValidation(this.detailedReport.getCertificateQualificationAtValidation(certificate.getId()));
        XmlDetails qualificationDetailsAtIssuanceTime = this.getCertificateQualificationDetailsAtIssuanceTime(certificate.getId());
        if (this.isNotEmpty(qualificationDetailsAtIssuanceTime)) {
            chainItem.setQualificationDetailsAtIssuance(qualificationDetailsAtIssuanceTime);
        }
        if (this.isNotEmpty(qualificationDetailsAtValidationTime = this.getCertificateQualificationDetailsAtValidationTime(certificate.getId()))) {
            chainItem.setQualificationDetailsAtValidation(qualificationDetailsAtValidationTime);
        }
        Boolean enactedMRA = null;
        List<TrustServiceWrapper> trustServices = certificate.getTrustServices();
        for (TrustServiceWrapper trustServiceWrapper : trustServices) {
            if (!trustServiceWrapper.isEnactedMRA()) continue;
            enactedMRA = true;
            break;
        }
        chainItem.setEnactedMRA(enactedMRA);
    }

    private void addQWACValidationDetails(XmlChainItem chainItem, CertificateWrapper certificate) {
        this.addQWACProfile(chainItem, certificate);
        this.addTLSBindingSignature(chainItem);
    }

    private void addQWACProfile(XmlChainItem chainItem, CertificateWrapper certificate) {
        chainItem.setQwacProfile(this.detailedReport.getCertificateQWACProfile(certificate.getId()));
        XmlDetails qwacValidationDetails = this.getQWACValidationDetails(certificate.getId());
        if (this.isNotEmpty(qwacValidationDetails)) {
            chainItem.setQwacDetails(qwacValidationDetails);
        }
    }

    private XmlDetails getValidationDetails(String tokenId) {
        XmlDetails validationDetails = new XmlDetails();
        validationDetails.getError().addAll(this.convert(this.detailedReport.getAdESValidationErrors(tokenId)));
        validationDetails.getWarning().addAll(this.convert(this.detailedReport.getAdESValidationWarnings(tokenId)));
        validationDetails.getInfo().addAll(this.convert(this.detailedReport.getAdESValidationInfos(tokenId)));
        return validationDetails;
    }

    private XmlDetails getCertificateQualificationDetailsAtIssuanceTime(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getCertificateQualificationErrorsAtIssuanceTime(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getCertificateQualificationWarningsAtIssuanceTime(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getCertificateQualificationInfosAtIssuanceTime(tokenId)));
        return qualificationDetails;
    }

    private XmlDetails getCertificateQualificationDetailsAtValidationTime(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getCertificateQualificationErrorsAtValidationTime(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getCertificateQualificationWarningsAtValidationTime(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getCertificateQualificationInfosAtValidationTime(tokenId)));
        return qualificationDetails;
    }

    private XmlDetails getQWACValidationDetails(String tokenId) {
        XmlDetails qualificationDetails = new XmlDetails();
        qualificationDetails.getError().addAll(this.convert(this.detailedReport.getQWACValidationErrors(tokenId)));
        qualificationDetails.getWarning().addAll(this.convert(this.detailedReport.getQWACValidationWarnings(tokenId)));
        qualificationDetails.getInfo().addAll(this.convert(this.detailedReport.getQWACValidationInfos(tokenId)));
        return qualificationDetails;
    }

    private void addTLSBindingSignature(XmlChainItem chainItem) {
        SignatureWrapper bindingSignature = this.diagnosticData.getTLSCertificateBindingSignature();
        if (bindingSignature != null) {
            XmlSignature xmlSignature = new XmlSignature();
            xmlSignature.setId(bindingSignature.getId());
            xmlSignature.setUrl(this.diagnosticData.getTLSCertificateBindingUrl());
            xmlSignature.setSigningTime(bindingSignature.getClaimedSigningTime());
            xmlSignature.setSignatureFormat(bindingSignature.getSignatureFormat());
            this.addSignatureScope(bindingSignature, xmlSignature);
            this.addFinalIndication(bindingSignature, xmlSignature);
            this.addAdESValidationDetails(bindingSignature, xmlSignature);
            this.addChain(bindingSignature, xmlSignature);
            chainItem.setTLSBindingSignature(xmlSignature);
        }
    }

    private void addSignatureScope(SignatureWrapper signature, XmlSignature xmlSignature) {
        List<XmlSignatureScope> signatureScopes = signature.getSignatureScopes();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (XmlSignatureScope signatureScope : signatureScopes) {
                xmlSignature.getSignatureScope().add(this.getXmlSignatureScope(signatureScope));
            }
        }
    }

    private void addFinalIndication(SignatureWrapper signature, XmlSignature xmlSignature) {
        xmlSignature.setIndication(this.detailedReport.getFinalIndication(signature.getId()));
        SubIndication subIndication = this.detailedReport.getFinalSubIndication(signature.getId());
        if (subIndication != null) {
            xmlSignature.setSubIndication(subIndication);
        }
    }

    private void addAdESValidationDetails(SignatureWrapper signature, XmlSignature xmlSignature) {
        XmlDetails validationDetails = this.getValidationDetails(signature.getId());
        if (this.isNotEmpty(validationDetails)) {
            xmlSignature.setAdESValidationDetails(validationDetails);
        }
    }

    private eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSignatureScope getXmlSignatureScope(XmlSignatureScope signatureScope) {
        eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSignatureScope xmlSignatureScope = new eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSignatureScope();
        xmlSignatureScope.setId(signatureScope.getSignerData().getId());
        xmlSignatureScope.setName(signatureScope.getName());
        xmlSignatureScope.setScope(signatureScope.getScope());
        xmlSignatureScope.setValue(signatureScope.getDescription());
        return xmlSignatureScope;
    }

    private void addChain(SignatureWrapper bindingSignature, XmlSignature xmlSignature) {
        List<CertificateWrapper> certificateChain = bindingSignature.getCertificateChain();
        if (Utils.isCollectionEmpty(certificateChain)) {
            return;
        }
        boolean trustAnchorReached = false;
        ArrayList<XmlChainItem> chain = new ArrayList<XmlChainItem>();
        for (CertificateWrapper cert : certificateChain) {
            XmlChainItem chainItem = this.getChainItem(cert, trustAnchorReached |= cert.isTrusted());
            if (bindingSignature.getSigningCertificate() != null && bindingSignature.getSigningCertificate().getId().equals(cert.getId())) {
                this.addQualifications(chainItem, cert);
                this.addQWACProfile(chainItem, cert);
            }
            chain.add(chainItem);
        }
        xmlSignature.setChain(chain);
    }

    private List<XmlMessage> convert(Collection<Message> messages) {
        return messages.stream().map(m -> {
            XmlMessage xmlMessage = new XmlMessage();
            xmlMessage.setKey(m.getKey());
            xmlMessage.setValue(m.getValue());
            return xmlMessage;
        }).collect(Collectors.toList());
    }

    private void addConnectionDetails(XmlSimpleCertificateReport simpleReport) {
        if (this.diagnosticData.getWebsiteUrl() != null) {
            XmlConnectionDetails xmlConnectionDetails = new XmlConnectionDetails();
            xmlConnectionDetails.setUrl(this.diagnosticData.getWebsiteUrl());
            xmlConnectionDetails.setTLSCertificateBindingLink(this.diagnosticData.getTLSCertificateBindingUrl());
            simpleReport.setConnectionDetails(xmlConnectionDetails);
        }
    }

    private boolean isNotEmpty(XmlDetails details) {
        return Utils.isCollectionNotEmpty(details.getError()) || Utils.isCollectionNotEmpty(details.getWarning()) || Utils.isCollectionNotEmpty(details.getInfo());
    }
}

