/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.timedependent.MutableTimeDependentValues;
import eu.europa.esig.dss.model.tsl.MRA;
import eu.europa.esig.dss.model.tsl.ServiceEquivalence;
import eu.europa.esig.dss.tsl.function.converter.TrustServiceEquivalenceConverter;
import eu.europa.esig.trustedlist.jaxb.mra.MutualRecognitionAgreementInformationType;
import eu.europa.esig.trustedlist.jaxb.mra.TrustServiceEquivalenceInformationType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class MRAConverter
implements Function<MutualRecognitionAgreementInformationType, MRA> {
    private TrustServiceEquivalenceConverter converter = new TrustServiceEquivalenceConverter();

    @Override
    public MRA apply(MutualRecognitionAgreementInformationType t) {
        MRA result = new MRA();
        if (t.getTechnicalType() != null) {
            result.setTechnicalType(t.getTechnicalType().toString());
        }
        if (t.getVersion() != null) {
            result.setVersion(t.getVersion().toString());
        }
        result.setPointingContractingPartyLegislation(t.getPointingContractingPartyLegislation());
        result.setPointedContractingPartyLegislation(t.getPointedContractingPartyLegislation());
        ArrayList<MutableTimeDependentValues<ServiceEquivalence>> serviceEquivalences = new ArrayList<MutableTimeDependentValues<ServiceEquivalence>>();
        List<TrustServiceEquivalenceInformationType> trustServiceEquivalenceInformations = t.getTrustServiceEquivalenceInformation();
        for (TrustServiceEquivalenceInformationType trustServiceEquivalenceInformationType : trustServiceEquivalenceInformations) {
            serviceEquivalences.add(this.converter.apply(trustServiceEquivalenceInformationType));
        }
        result.setServiceEquivalence(serviceEquivalences);
        return result;
    }
}

