/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function;

import eu.europa.esig.dss.tsl.function.TrustServiceProviderPredicate;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.tsl.InternationalNamesType;
import eu.europa.esig.trustedlist.jaxb.tsl.MultiLangNormStringType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPType;

public class TrustServiceProviderByTSPName
implements TrustServiceProviderPredicate {
    private final String tspName;

    public TrustServiceProviderByTSPName(String tspName) {
        this.tspName = tspName;
    }

    @Override
    public boolean test(TSPType trustServiceProvider) {
        if (trustServiceProvider != null && Utils.isStringNotEmpty(this.tspName)) {
            TSPInformationType tspInformation = trustServiceProvider.getTSPInformation();
            InternationalNamesType currentTspNames = tspInformation.getTSPName();
            for (MultiLangNormStringType name : currentTspNames.getName()) {
                if (!Utils.areStringsEqualIgnoreCase(this.tspName, name.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

