/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache;

import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.CacheType;
import eu.europa.esig.dss.tsl.cache.CachedResult;
import eu.europa.esig.dss.tsl.cache.state.CacheStateEnum;
import eu.europa.esig.dss.tsl.cache.state.CachedEntry;
import eu.europa.esig.dss.tsl.cache.state.CachedExceptionWrapper;
import eu.europa.esig.dss.utils.Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCache<R extends CachedResult> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCache.class);
    private Map<CacheKey, CachedEntry<R>> cachedEntriesMap = new ConcurrentHashMap<CacheKey, CachedEntry<R>>();

    protected AbstractCache() {
    }

    public Set<CacheKey> getKeys() {
        return this.cachedEntriesMap.keySet();
    }

    public CachedEntry<R> get(CacheKey cacheKey) {
        LOG.trace("Extracting the result for key [{}]...", (Object)cacheKey);
        CachedEntry<R> cacheWrapper = this.cachedEntriesMap.get(cacheKey);
        if (cacheWrapper != null) {
            LOG.trace("Return result for the key [{}]...", (Object)cacheKey);
            return cacheWrapper;
        }
        LOG.trace("A result for key [{}] is not found in the cache. Return empty object.", (Object)cacheKey);
        CachedEntry emptyEntry = new CachedEntry();
        this.cachedEntriesMap.put(cacheKey, emptyEntry);
        return emptyEntry;
    }

    public void update(CacheKey cacheKey, R result) {
        LOG.trace("Update result for the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cachedEntry = this.get(cacheKey);
        cachedEntry.update(result);
    }

    public void expire(CacheKey cacheKey) {
        LOG.trace("Update state to EXPIRED for an entry with the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cachedEntry = this.get(cacheKey);
        cachedEntry.expire();
    }

    public void remove(CacheKey cacheKey) {
        LOG.trace("Removing value for the key [{}] from cache...", (Object)cacheKey);
        CachedEntry<R> removedEntry = this.cachedEntriesMap.remove(cacheKey);
        if (removedEntry != null) {
            LOG.info("The cachedEntry with the key [{}], type [{}], last state transition time [{}] and status [{}], has been REMOVED from the cache.", new Object[]{cacheKey, this.getCacheType(), removedEntry.getLastStateTransitionTime(), removedEntry.getCurrentState()});
        } else {
            LOG.warn("Cannot remove the value for key [{}]. Object does not exist!", (Object)cacheKey);
        }
    }

    public void sync(CacheKey cacheKey) {
        LOG.trace("Update state to SYNCHRONIZED for an entry with the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cachedEntry = this.get(cacheKey);
        cachedEntry.sync();
    }

    public boolean isRefreshNeeded(CacheKey cacheKey) {
        LOG.trace("Checking if the update is required for an entry with the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cachedEntry = this.get(cacheKey);
        boolean refreshNeeded = cachedEntry.isRefreshNeeded();
        LOG.trace("Is update required for the entry with key [{}] ? {}", (Object)cacheKey, (Object)refreshNeeded);
        return refreshNeeded;
    }

    public boolean isDesync(CacheKey cacheKey) {
        LOG.trace("Checking if the cache entry is desynchronized with the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cachedEntry = this.get(cacheKey);
        boolean desync = cachedEntry.isDesync();
        LOG.trace("Is cache entry desynchronized with key [{}] ? {}", (Object)cacheKey, (Object)desync);
        return desync;
    }

    public boolean isEmpty(CacheKey cacheKey) {
        LOG.trace("Checking if an entry with the key [{}] is empty", (Object)cacheKey);
        CachedEntry<R> cachedEntry = this.get(cacheKey);
        boolean isEmpty = cachedEntry.isEmpty();
        LOG.trace("Is the entry with key [{}] empty ? {}", (Object)cacheKey, (Object)isEmpty);
        return isEmpty;
    }

    public void error(CacheKey cacheKey, Exception e) {
        LOG.trace("Updating state to ERROR for an entry with the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cacheWrapper = this.get(cacheKey);
        CachedExceptionWrapper wrappedException = new CachedExceptionWrapper(e);
        cacheWrapper.error(wrappedException);
    }

    public void toBeDeleted(CacheKey cacheKey) {
        LOG.trace("Update state to TO_BE_DELETED for an entry with the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cacheWrapper = this.get(cacheKey);
        cacheWrapper.toBeDeleted();
    }

    public boolean isToBeDeleted(CacheKey cacheKey) {
        LOG.trace("Checking if the status TO_BE_DELETED for an entry with the key [{}]...", (Object)cacheKey);
        CachedEntry<R> cachedEntry = this.get(cacheKey);
        boolean toBeDeleted = cachedEntry.isToBeDeleted();
        LOG.trace("Is TO_BE_DELETED status for the entry with key [{}] ? {}", (Object)cacheKey, (Object)toBeDeleted);
        return toBeDeleted;
    }

    protected abstract CacheType getCacheType();

    public String dump() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append("Cache ");
        sb.append((Object)this.getCacheType());
        if (Utils.isMapEmpty(this.cachedEntriesMap)) {
            sb.append(" : EMPTY");
        } else {
            sb.append(" : (nb entries : ");
            sb.append(this.cachedEntriesMap.size());
            sb.append(")\n");
            for (Map.Entry<CacheKey, CachedEntry<R>> mapEntry : this.cachedEntriesMap.entrySet()) {
                CacheKey key = mapEntry.getKey();
                CachedEntry<R> value = mapEntry.getValue();
                String currentKey = key.getKey();
                CacheStateEnum currentState = value.getCurrentState();
                String date = "?";
                Date lastStateTransitionTime = value.getLastStateTransitionTime();
                if (lastStateTransitionTime != null) {
                    date = sdf.format(lastStateTransitionTime);
                }
                sb.append(String.format("%-70.70s -> %-25.25s @ %.20s", currentKey, currentState, date));
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

