/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.source;

import eu.europa.esig.dss.service.http.proxy.ProxyConfig;
import eu.europa.esig.dss.service.http.proxy.ProxyProperties;
import eu.europa.esig.dss.standalone.source.PropertyReader;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;

public class ProxyConfiguration {
    private static ProxyConfig config = null;

    public static ProxyConfig proxyConfig() {
        if (config == null) {
            boolean httpEnabled = Utils.isTrue(PropertyReader.getBooleanProperty("proxy.http.enabled"));
            boolean httpsEnabled = Utils.isTrue(PropertyReader.getBooleanProperty("proxy.https.enabled"));
            if (!httpEnabled && !httpsEnabled) {
                return null;
            }
            config = new ProxyConfig();
            if (httpEnabled) {
                List<String> httpExcludedHosts;
                char[] httpPassword;
                String httpUser;
                int httpPort;
                String httpScheme;
                ProxyProperties httpProperties = new ProxyProperties();
                String httpHost = PropertyReader.getProperty("proxy.http.host");
                if (Utils.isStringNotEmpty(httpHost)) {
                    httpProperties.setHost(httpHost);
                }
                if (Utils.isStringNotEmpty(httpScheme = PropertyReader.getProperty("proxy.http.scheme"))) {
                    httpProperties.setScheme(httpScheme);
                }
                if ((httpPort = PropertyReader.getIntProperty("proxy.http.port")) != -1) {
                    httpProperties.setPort(httpPort);
                }
                if (Utils.isStringNotEmpty(httpUser = PropertyReader.getProperty("proxy.http.user"))) {
                    httpProperties.setUser(httpUser);
                }
                if (Utils.isArrayNotEmpty(httpPassword = PropertyReader.getCharArrayProperty("proxy.http.password"))) {
                    httpProperties.setPassword(httpPassword);
                }
                if (Utils.isCollectionNotEmpty(httpExcludedHosts = PropertyReader.getPropertyAsList("proxy.http.exclude"))) {
                    httpProperties.setExcludedHosts(httpExcludedHosts);
                }
                config.setHttpProperties(httpProperties);
            }
            if (httpsEnabled) {
                List<String> httpsExcludedHosts;
                char[] httpsPassword;
                String httpsUser;
                int httpsPort;
                String httpsScheme;
                ProxyProperties httpsProperties = new ProxyProperties();
                String httpsHost = PropertyReader.getProperty("proxy.https.host");
                if (Utils.isStringNotEmpty(httpsHost)) {
                    httpsProperties.setHost(httpsHost);
                }
                if (Utils.isStringNotEmpty(httpsScheme = PropertyReader.getProperty("proxy.https.scheme"))) {
                    httpsProperties.setScheme(httpsScheme);
                }
                if ((httpsPort = PropertyReader.getIntProperty("proxy.https.port")) != -1) {
                    httpsProperties.setPort(httpsPort);
                }
                if (Utils.isStringNotEmpty(httpsUser = PropertyReader.getProperty("proxy.https.user"))) {
                    httpsProperties.setUser(httpsUser);
                }
                if (Utils.isArrayNotEmpty(httpsPassword = PropertyReader.getCharArrayProperty("proxy.https.password"))) {
                    httpsProperties.setPassword(httpsPassword);
                }
                if (Utils.isCollectionNotEmpty(httpsExcludedHosts = PropertyReader.getPropertyAsList("proxy.https.exclude"))) {
                    httpsProperties.setExcludedHosts(httpsExcludedHosts);
                }
                config.setHttpsProperties(httpsProperties);
            }
        }
        return config;
    }
}

