/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.scope;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.spi.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.TimestampScopeFinder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import java.util.Collections;
import java.util.List;

public class DetachedTimestampScopeFinder
extends AbstractSignatureScopeFinder
implements TimestampScopeFinder {
    protected DSSDocument timestampedData;

    public void setTimestampedData(DSSDocument timestampedData) {
        this.timestampedData = timestampedData;
    }

    @Override
    public List<SignatureScope> findTimestampScope(TimestampToken timestampToken) {
        if (timestampToken.isMessageImprintDataIntact()) {
            return this.getTimestampSignatureScopeForDocument(this.timestampedData);
        }
        return Collections.emptyList();
    }

    protected List<SignatureScope> getTimestampSignatureScopeForDocument(DSSDocument document) {
        String documentName = document.getName();
        if (document instanceof DigestDocument) {
            return Collections.singletonList(new DigestSignatureScope(documentName, document));
        }
        return Collections.singletonList(new FullSignatureScope(documentName, document));
    }
}

