/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.policy.crypto.xml;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteCatalogue;
import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteFactory;
import eu.europa.esig.dss.policy.crypto.xml.CryptographicSuiteXmlFacade;
import eu.europa.esig.dss.policy.crypto.xml.jaxb.SecuritySuitabilityPolicyType;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class CryptographicSuiteXmlFactory
implements CryptographicSuiteFactory {
    private static final String DEFAULT_CRYPTOGRAPHIC_SUITES_LOCATION = "/suite/dss-crypto-suite.xml";

    @Override
    public boolean isSupported(DSSDocument cryptographicSuiteDocument) {
        boolean bl;
        block8: {
            InputStream is = cryptographicSuiteDocument.openStream();
            try {
                SecuritySuitabilityPolicyType suitabilityPolicyType = (SecuritySuitabilityPolicyType)CryptographicSuiteXmlFacade.newFacade().unmarshall(is, false);
                boolean bl2 = bl = suitabilityPolicyType != null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JAXBException | IOException | XMLStreamException | SAXException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    @Override
    public CryptographicSuiteCatalogue loadDefaultCryptographicSuite() {
        return this.loadCryptographicSuite(CryptographicSuiteXmlFactory.class.getResourceAsStream(DEFAULT_CRYPTOGRAPHIC_SUITES_LOCATION));
    }

    @Override
    public CryptographicSuiteCatalogue loadCryptographicSuite(DSSDocument cryptographicSuiteDocument) {
        return this.loadCryptographicSuite(cryptographicSuiteDocument.openStream());
    }

    @Override
    public CryptographicSuiteCatalogue loadCryptographicSuite(InputStream cryptographicSuiteInputStream) {
        CryptographicSuiteCatalogue cryptographicSuiteCatalogue;
        block8: {
            InputStream is = cryptographicSuiteInputStream;
            try {
                cryptographicSuiteCatalogue = CryptographicSuiteXmlFacade.newFacade().getCryptographicSuite(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(String.format("Unable to load the default policy document. Reason : %s", e.getMessage()), e);
                }
            }
            is.close();
        }
        return cryptographicSuiteCatalogue;
    }
}

