/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.modifications;

import eu.europa.esig.dss.pades.validation.PdfObjectKey;
import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfObject;
import eu.europa.esig.dss.pdf.PdfSimpleObject;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModificationsFilter;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.modifications.PdfObjectTree;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPdfObjectModificationsFinder
implements PdfObjectModificationsFinder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPdfObjectModificationsFinder.class);
    private int maximumObjectVerificationDeepness = 500;
    private boolean laxNumericComparison = true;
    private PdfObjectModificationsFilter pdfObjectModificationsFilter;

    public void setMaximumObjectVerificationDeepness(int maximumObjectVerificationDeepness) {
        this.maximumObjectVerificationDeepness = maximumObjectVerificationDeepness;
    }

    public void setLaxNumericComparison(boolean laxNumericComparison) {
        this.laxNumericComparison = laxNumericComparison;
    }

    public PdfObjectModificationsFilter getPdfObjectModificationsFilter() {
        if (this.pdfObjectModificationsFilter == null) {
            this.pdfObjectModificationsFilter = new PdfObjectModificationsFilter();
        }
        return this.pdfObjectModificationsFilter;
    }

    public void setPdfObjectModificationsFilter(PdfObjectModificationsFilter pdfObjectModificationsFilter) {
        Objects.requireNonNull(pdfObjectModificationsFilter, "PdfObjectModificationsFilter cannot be null!");
        this.pdfObjectModificationsFilter = pdfObjectModificationsFilter;
    }

    @Override
    public PdfObjectModifications find(PdfDocumentReader originalRevisionReader, PdfDocumentReader finalRevisionReader) {
        Set<ObjectModification> objectModifications = this.findObjectModifications(originalRevisionReader, finalRevisionReader);
        return this.getPdfObjectModificationsFilter().filter(objectModifications);
    }

    private Set<ObjectModification> findObjectModifications(PdfDocumentReader originalRevisionReader, PdfDocumentReader finalRevisionReader) {
        LinkedHashSet<ObjectModification> modifications = new LinkedHashSet<ObjectModification>();
        PdfDict signedCatalogDict = originalRevisionReader.getCatalogDictionary();
        PdfDict finalCatalogDict = finalRevisionReader.getCatalogDictionary();
        this.compareObjectsRecursively(modifications, new HashSet<PdfObjectTreeReference>(), new PdfObjectTree("Catalog"), "Catalog", signedCatalogDict, finalCatalogDict);
        return modifications;
    }

    public PdfObjectModifications find(PdfDict originalRevisionDict, PdfDict finalRevisionDict) {
        LinkedHashSet<ObjectModification> objectModifications = new LinkedHashSet<ObjectModification>();
        this.compareDictsRecursively(objectModifications, new HashSet<PdfObjectTreeReference>(), new PdfObjectTree(), originalRevisionDict, finalRevisionDict);
        return this.getPdfObjectModificationsFilter().filter(objectModifications);
    }

    private void compareDictsRecursively(Set<ObjectModification> modifications, Set<PdfObjectTreeReference> processedObjects, PdfObjectTree objectTree, PdfDict signedDict, PdfDict finalDict) {
        String[] signedRevObjNames = signedDict.list();
        String[] finalRevObjNames = finalDict.list();
        for (String objectName : signedRevObjNames) {
            PdfObjectKey objectKey;
            PdfObjectTree currentObjectTree = objectTree.copy();
            if (this.isProcessedReference(processedObjects, currentObjectTree, objectName, objectKey = signedDict.getObjectKey(objectName))) continue;
            currentObjectTree.addKey(objectName);
            this.addProcessedReference(processedObjects, currentObjectTree, objectName, objectKey);
            this.compareObjectsRecursively(modifications, processedObjects, currentObjectTree, objectName, signedDict.getObject(objectName), finalDict.getObject(objectName));
        }
        List<String> signedRevKeyList = Arrays.asList(signedRevObjNames);
        for (String objectName : finalRevObjNames) {
            PdfObjectTree currentObjectTree = objectTree.copy();
            if (signedRevKeyList.contains(objectName)) continue;
            currentObjectTree.addKey(objectName);
            PdfObject finalObject = finalDict.getObject(objectName);
            if (finalObject instanceof PdfDict || finalObject instanceof PdfArray) {
                PdfObjectKey objectKey = finalDict.getObjectKey(objectName);
                this.addProcessedReference(processedObjects, currentObjectTree, objectName, objectKey);
                modifications.add(ObjectModification.create(currentObjectTree, finalDict.getObject(objectName)));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Added entry with key '{}'.", (Object)currentObjectTree);
                continue;
            }
            modifications.add(ObjectModification.modify(currentObjectTree, null, finalObject));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Added parameter with key name '{}'.", (Object)objectTree);
        }
        this.compareDictStreams(modifications, objectTree, signedDict, finalDict);
    }

    private void compareObjectsRecursively(Set<ObjectModification> modifications, Set<PdfObjectTreeReference> processedObjects, PdfObjectTree objectTree, String name, PdfObject signedObject, PdfObject finalObject) {
        if (this.maximumObjectVerificationDeepness < objectTree.getChainDeepness()) {
            String errorMessage = "Maximum objects verification deepness has been reached : {}. Chain of objects is skipped.";
            if (this.maximumObjectVerificationDeepness == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(errorMessage, (Object)this.maximumObjectVerificationDeepness);
                }
            } else {
                LOG.warn("Maximum objects verification deepness has been reached : {}. Chain of objects is skipped.", (Object)this.maximumObjectVerificationDeepness);
            }
            return;
        }
        if (signedObject == null && finalObject != null) {
            if (finalObject instanceof PdfDict || finalObject instanceof PdfArray) {
                modifications.add(ObjectModification.create(objectTree, finalObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Added entry with key '{}'.", (Object)objectTree);
                }
            } else {
                modifications.add(ObjectModification.modify(objectTree, null, finalObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Added parameter with key name '{}'.", (Object)objectTree);
                }
            }
        } else if (signedObject != null && finalObject == null) {
            if (signedObject instanceof PdfDict || signedObject instanceof PdfArray) {
                modifications.add(ObjectModification.delete(objectTree, signedObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleted entry with key '{}'.", (Object)objectTree);
                }
            } else {
                modifications.add(ObjectModification.modify(objectTree, signedObject, null));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleted parameter with key name '{}'.", (Object)objectTree);
                }
            }
        } else if (signedObject != null && finalObject != null) {
            if (signedObject instanceof PdfDict && finalObject instanceof PdfDict) {
                this.compareDictsRecursively(modifications, processedObjects, objectTree, (PdfDict)signedObject, (PdfDict)finalObject);
            } else if (signedObject instanceof PdfArray && finalObject instanceof PdfArray) {
                PdfArray signedArray = (PdfArray)signedObject;
                PdfArray finalArray = (PdfArray)finalObject;
                this.compareArraysRecursively(modifications, processedObjects, objectTree, name, signedArray, finalArray, true);
                this.compareArraysRecursively(modifications, processedObjects, objectTree, name, finalArray, signedArray, false);
            } else if (signedObject instanceof PdfSimpleObject && finalObject instanceof PdfSimpleObject) {
                PdfSimpleObject signedSimpleObject = (PdfSimpleObject)signedObject;
                PdfSimpleObject finalSimpleObject = (PdfSimpleObject)finalObject;
                this.compareSimpleObjects(modifications, objectTree, signedSimpleObject, finalSimpleObject);
            } else if (signedObject.getClass() != finalObject.getClass()) {
                modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object with key name '{}' of type '{}' has been modified to type '{}'.", objectTree, signedObject.getClass(), finalObject.getClass());
                }
            } else {
                modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                LOG.warn("Unsupported comparison of objects of type '{}' with key name '{}'", (Object)signedObject.getClass(), (Object)objectTree);
            }
        }
    }

    private void compareSimpleObjects(Set<ObjectModification> modifications, PdfObjectTree objectTree, PdfSimpleObject signedObject, PdfSimpleObject finalObject) {
        Object signedObjectValue = signedObject.getValue();
        Object finalObjectValue = finalObject.getValue();
        if (signedObjectValue == null && finalObjectValue != null) {
            modifications.add(ObjectModification.modify(objectTree, null, finalObject));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added object value with key '{}'.", (Object)objectTree);
            }
        } else if (signedObjectValue != null && finalObjectValue == null) {
            modifications.add(ObjectModification.modify(objectTree, signedObject, null));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted object value with key '{}'.", (Object)objectTree);
            }
        } else if (signedObjectValue != null && finalObjectValue != null) {
            if (signedObjectValue instanceof String && finalObjectValue instanceof String) {
                if (!signedObjectValue.equals(finalObjectValue)) {
                    modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Object changed with key '{}'.", (Object)objectTree);
                    }
                }
            } else if (signedObjectValue instanceof Number && finalObjectValue instanceof Number) {
                if (!signedObjectValue.equals(finalObjectValue)) {
                    if (!this.laxNumericComparison) {
                        modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Object changed with key '{}'.", (Object)objectTree);
                        }
                    } else if (((Number)signedObjectValue).floatValue() != ((Number)finalObjectValue).floatValue()) {
                        modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Object changed with key '{}'.", (Object)objectTree);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Number object with key changed type '{}'. Set #setLaxNumericComparison(false) to return a warning.", (Object)objectTree);
                    }
                }
            } else if (signedObjectValue instanceof Boolean && finalObjectValue instanceof Boolean) {
                if (!signedObjectValue.equals(finalObjectValue)) {
                    modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Object changed with key '{}'.", (Object)objectTree);
                    }
                }
            } else if (signedObject.getClass() != finalObject.getClass()) {
                modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object with key name '{}' of type '{}' has been modified to type '{}'.", objectTree, signedObject.getClass(), finalObject.getClass());
                }
            } else {
                modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                LOG.warn("Unsupported comparison of objects of type '{}' with key name '{}'", (Object)signedObject.getClass(), (Object)objectTree);
            }
        }
    }

    private void compareArraysRecursively(Set<ObjectModification> modifications, Set<PdfObjectTreeReference> processedObjects, PdfObjectTree objectTree, String name, PdfArray firstArray, PdfArray secondArray, boolean signedFirst) {
        for (int i = 0; i < firstArray.size(); ++i) {
            PdfObjectTree currentObjectTree = objectTree.copy();
            PdfObject signedRevObject = firstArray.getObject(i);
            PdfObject finalRevObject = null;
            PdfObjectKey objectKey = firstArray.getObjectKey(i);
            if (objectKey != null) {
                for (int j = 0; j < secondArray.size(); ++j) {
                    PdfObjectKey finalObjectKey = secondArray.getObjectKey(j);
                    if (!objectKey.equals(finalObjectKey)) continue;
                    finalRevObject = secondArray.getObject(j);
                }
            } else if (i < secondArray.size()) {
                finalRevObject = secondArray.getObject(i);
            }
            if (this.isProcessedReference(processedObjects, currentObjectTree, name, objectKey)) continue;
            this.addProcessedReference(processedObjects, currentObjectTree, name, objectKey);
            this.compareObjectsRecursively(modifications, processedObjects, currentObjectTree, name, signedFirst ? signedRevObject : finalRevObject, signedFirst ? finalRevObject : signedRevObject);
        }
    }

    private boolean isProcessedReference(Set<PdfObjectTreeReference> processedObjects, PdfObjectTree objectTree, String name, PdfObjectKey objectKey) {
        return processedObjects.contains(new PdfObjectTreeReference(name, objectKey)) || objectTree.isProcessedReference(objectKey);
    }

    private void addProcessedReference(Set<PdfObjectTreeReference> processedObjects, PdfObjectTree objectTree, String name, PdfObjectKey objectKey) {
        if (objectKey != null) {
            processedObjects.add(new PdfObjectTreeReference(name, objectKey));
            objectTree.addReference(objectKey);
        }
    }

    private void compareDictStreams(Set<ObjectModification> modifications, PdfObjectTree objectTree, PdfDict signedDict, PdfDict finalDict) {
        PdfObjectTree currentObjectTree = objectTree.copy();
        currentObjectTree.setStream();
        long signedStreamSize = this.getRawStreamSizeSecurely(signedDict);
        long finalStreamSize = this.getRawStreamSizeSecurely(finalDict);
        if (signedStreamSize == -1L && finalStreamSize > -1L) {
            modifications.add(ObjectModification.create(currentObjectTree, finalDict));
            if (LOG.isDebugEnabled()) {
                LOG.debug("A stream has been added '{}'.", (Object)currentObjectTree);
            }
        } else if (signedStreamSize > -1L && finalStreamSize == -1L) {
            modifications.add(ObjectModification.delete(currentObjectTree, signedDict));
            if (LOG.isDebugEnabled()) {
                LOG.debug("A stream has been removed '{}'.", (Object)currentObjectTree);
            }
        } else if (signedStreamSize != finalStreamSize) {
            modifications.add(ObjectModification.modify(currentObjectTree, signedDict, finalDict));
            if (LOG.isDebugEnabled()) {
                LOG.debug("A stream has been modified '{}'.", (Object)currentObjectTree);
            }
        } else if (signedStreamSize > -1L && finalStreamSize > -1L) {
            try (InputStream signedStream = this.getRawInputStreamSecurely(signedDict);
                 InputStream finalStream = this.getRawInputStreamSecurely(finalDict);){
                if (!Utils.compareInputStreams(signedStream, finalStream)) {
                    modifications.add(ObjectModification.modify(currentObjectTree, signedDict, finalDict));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("A stream has been modified '{}'.", (Object)currentObjectTree);
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to compare underlying stream binaries. Reason : {}", (Object)e.getMessage());
            }
        }
    }

    private long getRawStreamSizeSecurely(PdfDict pdfDict) {
        try {
            return pdfDict.getRawStreamSize();
        }
        catch (IOException e) {
            LOG.warn("Unable to read the underlying stream binaries. Reason : {}", (Object)e.getMessage());
            return -1L;
        }
    }

    private InputStream getRawInputStreamSecurely(PdfDict pdfDict) throws IOException {
        InputStream stream = pdfDict.createRawInputStream();
        if (stream != null) {
            return stream;
        }
        return new ByteArrayInputStream(DSSUtils.EMPTY_BYTE_ARRAY);
    }

    private static class PdfObjectTreeReference {
        private final String objectName;
        private final PdfObjectKey objectKey;

        private PdfObjectTreeReference(String objectName, PdfObjectKey objectKey) {
            this.objectName = objectName;
            this.objectKey = objectKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PdfObjectTreeReference that = (PdfObjectTreeReference)o;
            return Objects.equals(this.objectName, that.objectName) && Objects.equals(this.objectKey, that.objectKey);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.objectName);
            result = 31 * result + Objects.hashCode(this.objectKey);
            return result;
        }
    }
}

