/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.policy.crypto;

import eu.europa.esig.dss.model.policy.crypto.CryptographicSuiteEvaluation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CryptographicSuiteAlgorithm
implements Serializable {
    private static final long serialVersionUID = -273833860519018516L;
    private String algorithmIdentifierName;
    private List<String> algorithmIdentifierOIDs;
    private List<String> algorithmIdentifierURIs;
    private List<CryptographicSuiteEvaluation> evaluationList;
    private List<String> informationTextList;

    public String getAlgorithmIdentifierName() {
        return this.algorithmIdentifierName;
    }

    public void setAlgorithmIdentifierName(String algorithmIdentifierName) {
        this.algorithmIdentifierName = algorithmIdentifierName;
    }

    public List<String> getAlgorithmIdentifierOIDs() {
        return this.algorithmIdentifierOIDs;
    }

    public void setAlgorithmIdentifierOIDs(List<String> algorithmIdentifierOIDs) {
        this.algorithmIdentifierOIDs = algorithmIdentifierOIDs;
    }

    public List<String> getAlgorithmIdentifierURIs() {
        return this.algorithmIdentifierURIs;
    }

    public void setAlgorithmIdentifierURIs(List<String> algorithmIdentifierURIs) {
        this.algorithmIdentifierURIs = algorithmIdentifierURIs;
    }

    public List<CryptographicSuiteEvaluation> getEvaluationList() {
        return this.evaluationList;
    }

    public void setEvaluationList(List<CryptographicSuiteEvaluation> evaluationList) {
        this.evaluationList = evaluationList;
    }

    public List<String> getInformationTextList() {
        return this.informationTextList;
    }

    public void setInformationTextList(List<String> informationTextList) {
        this.informationTextList = informationTextList;
    }

    public static CryptographicSuiteAlgorithm copy(CryptographicSuiteAlgorithm algorithm) {
        if (algorithm == null) {
            return null;
        }
        CryptographicSuiteAlgorithm copy = new CryptographicSuiteAlgorithm();
        copy.algorithmIdentifierName = algorithm.algorithmIdentifierName;
        if (algorithm.algorithmIdentifierOIDs != null) {
            copy.algorithmIdentifierOIDs = new ArrayList<String>(algorithm.algorithmIdentifierOIDs);
        }
        if (algorithm.algorithmIdentifierURIs != null) {
            copy.algorithmIdentifierURIs = new ArrayList<String>(algorithm.algorithmIdentifierURIs);
        }
        if (algorithm.evaluationList != null) {
            copy.evaluationList = algorithm.evaluationList.stream().map(CryptographicSuiteEvaluation::copy).collect(Collectors.toList());
        }
        if (algorithm.informationTextList != null) {
            copy.informationTextList = new ArrayList<String>(algorithm.informationTextList);
        }
        return copy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CryptographicSuiteAlgorithm algorithm = (CryptographicSuiteAlgorithm)object;
        return Objects.equals(this.algorithmIdentifierName, algorithm.algorithmIdentifierName) && Objects.equals(this.algorithmIdentifierOIDs, algorithm.algorithmIdentifierOIDs) && Objects.equals(this.algorithmIdentifierURIs, algorithm.algorithmIdentifierURIs) && Objects.equals(this.evaluationList, algorithm.evaluationList) && Objects.equals(this.informationTextList, algorithm.informationTextList);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.algorithmIdentifierName);
        result = 31 * result + Objects.hashCode(this.algorithmIdentifierOIDs);
        result = 31 * result + Objects.hashCode(this.algorithmIdentifierURIs);
        result = 31 * result + Objects.hashCode(this.evaluationList);
        result = 31 * result + Objects.hashCode(this.informationTextList);
        return result;
    }

    public String toString() {
        return "CryptographicSuiteAlgorithm [algorithmIdentifierName='" + this.algorithmIdentifierName + '\'' + ", algorithmIdentifierOIDs=" + this.algorithmIdentifierOIDs + ", algorithmIdentifierURIs=" + this.algorithmIdentifierURIs + ", evaluationList=" + this.evaluationList + ", informationTextList=" + this.informationTextList + ']';
    }
}

