/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.spi.validation.SignatureProperties;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jose4j.json.internal.json_simple.JSONArray;

public class JAdESEtsiUHeader
implements SignatureProperties<EtsiUComponent> {
    private static final long serialVersionUID = 2141375341919119408L;
    private final JWS jws;
    private List<EtsiUComponent> components;

    public JAdESEtsiUHeader(JWS jws) {
        this.jws = jws;
    }

    @Override
    public boolean isExist() {
        return Utils.isCollectionNotEmpty(this.getAttributes());
    }

    @Override
    public List<EtsiUComponent> getAttributes() {
        if (this.components == null) {
            this.components = new ArrayList<EtsiUComponent>();
            List<Object> etsiUContent = DSSJsonUtils.getEtsiU(this.jws);
            if (Utils.isCollectionNotEmpty(etsiUContent)) {
                for (int ii = 0; ii < etsiUContent.size(); ++ii) {
                    Object item = etsiUContent.get(ii);
                    EtsiUComponent etsiUComponent = EtsiUComponent.build(item, ii);
                    if (etsiUComponent == null) continue;
                    this.components.add(etsiUComponent);
                }
            }
        }
        return this.components;
    }

    public void addComponent(String headerName, Object value, boolean base64UrlEncoded) {
        List<Object> etsiU = this.getEtsiUToEdit();
        Object etsiEntry = this.getComponent(headerName, value, base64UrlEncoded);
        etsiU.add(etsiEntry);
    }

    private Object getComponent(String name, Object value, boolean base64UrlEncoded) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put(name, value);
        return base64UrlEncoded ? DSSJsonUtils.toBase64Url(jsonObject) : jsonObject;
    }

    public void removeComponent(String headerName) {
        List<Object> etsiU = this.getEtsiUToEdit();
        if (Utils.isCollectionNotEmpty(etsiU)) {
            ListIterator<Object> iterator2 = this.getBackwardIterator(etsiU);
            while (iterator2.hasPrevious()) {
                this.removeLastIfMatches(iterator2, headerName);
            }
        }
    }

    public boolean removeLastComponent(String ... headerName) {
        List<Object> etsiU = this.getEtsiUToEdit();
        if (Utils.isCollectionNotEmpty(etsiU)) {
            ListIterator<Object> iterator2 = this.getBackwardIterator(etsiU);
            return this.removeLastIfMatches(iterator2, headerName);
        }
        return false;
    }

    private ListIterator<Object> getBackwardIterator(List<Object> etsiU) {
        return etsiU.listIterator(etsiU.size());
    }

    private boolean removeLastIfMatches(ListIterator<?> iterator2, String ... headerName) {
        Object object = iterator2.previous();
        Map<String, Object> etsiUComponent = DSSJsonUtils.parseEtsiUComponent(object);
        if (etsiUComponent != null) {
            if (Arrays.stream(headerName).anyMatch(etsiUComponent::containsKey)) {
                iterator2.remove();
                return true;
            }
        }
        return false;
    }

    public void replaceComponent(EtsiUComponent attribute) {
        List<Object> etsiU = this.getEtsiUToEdit();
        ListIterator<Object> iterator2 = etsiU.listIterator();
        while (iterator2.hasNext()) {
            int position = iterator2.nextIndex();
            Object item = iterator2.next();
            EtsiUComponent currentComponent = EtsiUComponent.build(item, position);
            if (!attribute.equals(currentComponent)) continue;
            iterator2.set(attribute.getComponent());
            break;
        }
    }

    private List<Object> getEtsiUToEdit() {
        Map<String, Object> unprotected = this.jws.getUnprotected();
        if (unprotected == null) {
            unprotected = new HashMap<String, Object>();
            this.jws.setUnprotected(unprotected);
        }
        this.clearCachedAttributes();
        return (List)unprotected.computeIfAbsent("etsiU", k -> new JSONArray());
    }

    private void clearCachedAttributes() {
        this.components = null;
    }
}

