/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.extension;

import eu.europa.esig.dss.enumerations.JWSSerializationType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.extension.AbstractDocumentExtender;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import eu.europa.esig.dss.jades.signature.JAdESService;
import eu.europa.esig.dss.jades.validation.JWSDocumentAnalyzerFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESDocumentExtender
extends AbstractDocumentExtender<JAdESSignatureParameters, JAdESTimestampParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESDocumentExtender.class);

    JAdESDocumentExtender() {
    }

    public JAdESDocumentExtender(DSSDocument document) {
        Objects.requireNonNull(document, "Document to be extended cannot be null!");
        this.document = document;
    }

    @Override
    protected DocumentSignatureService<JAdESSignatureParameters, JAdESTimestampParameters> createSignatureService() {
        Objects.requireNonNull(this.certificateVerifier, "Please provide CertificateVerifier or corresponding JAdESService!");
        JAdESService service = new JAdESService(this.certificateVerifier);
        service.setTspSource(this.tspSource);
        return service;
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return new JWSDocumentAnalyzerFactory().isSupported(dssDocument);
    }

    @Override
    protected JAdESSignatureParameters emptySignatureParameters() {
        JAdESSignatureParameters emptyParameters = new JAdESSignatureParameters();
        LOG.info("No JAdES related signature parameters found within the configuration. Fallback to '{}' JwsSerializationType", (Object)JWSSerializationType.JSON_SERIALIZATION);
        emptyParameters.setJwsSerializationType(JWSSerializationType.JSON_SERIALIZATION);
        return emptyParameters;
    }

    @Override
    protected boolean isSupportedParameters(SerializableSignatureParameters parameters) {
        return parameters instanceof JAdESSignatureParameters;
    }

    @Override
    protected boolean isSupportedService(DocumentSignatureService<?, ?> service) {
        return service instanceof JAdESService;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.JAdES;
    }
}

