/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.jades.HTTPHeader;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.Objects;

public class HTTPHeaderDigest
extends HTTPHeader {
    private final DSSDocument messageBodyDocument;

    public HTTPHeaderDigest(DSSDocument messageBodyDocument, DigestAlgorithm digestAlgorithm) {
        super("Digest", HTTPHeaderDigest.buildInstanceDigestValue(messageBodyDocument, digestAlgorithm));
        this.messageBodyDocument = messageBodyDocument;
    }

    private static String buildInstanceDigestValue(DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(document, "DSSDocument shall be provided!");
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm shall be provided!");
        String jwsHttpHeaderAlgo = digestAlgorithm.getHttpHeaderAlgo();
        if (jwsHttpHeaderAlgo == null) {
            throw new IllegalArgumentException(String.format("The DigestAlgorithm '%s' is not supported for 'sigD' HTTP_HEADERS mechanism. See RFC 5843 for more information.", digestAlgorithm));
        }
        StringBuilder stringBuilder = new StringBuilder(jwsHttpHeaderAlgo);
        stringBuilder.append("=");
        byte[] digest = document.getDigestValue(digestAlgorithm);
        String base64EncodedDigest = Utils.toBase64(digest);
        stringBuilder.append(base64EncodedDigest);
        return stringBuilder.toString();
    }

    public DSSDocument getMessageBodyDocument() {
        return this.messageBodyDocument;
    }
}

