/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.extension;

import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.extension.SignedDocumentExtenderFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.spi.extension.DocumentExtender;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import java.util.Objects;
import java.util.ServiceLoader;

public abstract class SignedDocumentExtender
implements DocumentExtender {
    protected CertificateVerifier certificateVerifier;
    protected TSPSource tspSource;
    protected DocumentSignatureService<?, ?>[] services;

    protected SignedDocumentExtender() {
    }

    public static SignedDocumentExtender fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<SignedDocumentExtenderFactory> serviceLoaders = ServiceLoader.load(SignedDocumentExtenderFactory.class);
        for (SignedDocumentExtenderFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    public void setServices(DocumentSignatureService<?, ?> ... services) {
        this.services = services;
    }

    public abstract SignatureForm getSignatureForm();

    public boolean isASiC() {
        return false;
    }
}

