/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.xml.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.evidencerecord.common.validation.ArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformation;
import eu.europa.esig.dss.evidencerecord.common.validation.CryptographicInformationType;
import eu.europa.esig.dss.evidencerecord.common.validation.EvidenceRecordParser;
import eu.europa.esig.dss.evidencerecord.common.validation.timestamp.EvidenceRecordTimestampIdentifierBuilder;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSAttribute;
import eu.europa.esig.dss.evidencerecord.xml.definition.XMLERSPath;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlArchiveTimeStampChainObject;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlArchiveTimeStampObject;
import eu.europa.esig.dss.evidencerecord.xml.validation.XmlSequenceObject;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.tsp.TimestampIdentifierBuilder;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlEvidenceRecordParser
implements EvidenceRecordParser {
    private static final Logger LOG = LoggerFactory.getLogger(XmlEvidenceRecordParser.class);
    private final Element evidenceRecordElement;
    private String filename;
    private EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper;

    public XmlEvidenceRecordParser(Element evidenceRecordElement) {
        this.evidenceRecordElement = evidenceRecordElement;
    }

    public XmlEvidenceRecordParser setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public XmlEvidenceRecordParser setEmbeddedEvidenceRecordHelper(EmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper) {
        this.embeddedEvidenceRecordHelper = embeddedEvidenceRecordHelper;
        return this;
    }

    public List<XmlArchiveTimeStampChainObject> parse() {
        NodeList archiveTimeStampSequenceList = DomUtils.getNodeList(this.evidenceRecordElement, XMLERSPath.ARCHIVE_TIME_STAMP_CHAIN_PATH);
        if (archiveTimeStampSequenceList != null && archiveTimeStampSequenceList.getLength() > 0) {
            XmlArchiveTimeStampChainObject[] result = new XmlArchiveTimeStampChainObject[archiveTimeStampSequenceList.getLength()];
            for (int i = 0; i < archiveTimeStampSequenceList.getLength(); ++i) {
                Element archiveTimeStampChainElement = (Element)archiveTimeStampSequenceList.item(i);
                XmlArchiveTimeStampChainObject archiveTimeStampChain = this.getXmlArchiveTimeStampChainObject(archiveTimeStampChainElement, i);
                int order = archiveTimeStampChain.getOrder();
                result[order - 1] = archiveTimeStampChain;
            }
            return Arrays.asList(result);
        }
        return Collections.emptyList();
    }

    private XmlArchiveTimeStampChainObject getXmlArchiveTimeStampChainObject(Element archiveTimeStampChain, int archiveTimeStampChainOrder) {
        XmlArchiveTimeStampChainObject archiveTimeStampChainObject = new XmlArchiveTimeStampChainObject(archiveTimeStampChain);
        archiveTimeStampChainObject.setDigestAlgorithm(this.getDigestAlgorithm(archiveTimeStampChain));
        archiveTimeStampChainObject.setCanonicalizationMethod(this.getCanonicalizationMethod(archiveTimeStampChain));
        archiveTimeStampChainObject.setOrder(this.getOrderAttributeValue(archiveTimeStampChain));
        archiveTimeStampChainObject.setArchiveTimeStamps(this.getXmlArchiveTimeStamps(archiveTimeStampChain, archiveTimeStampChainOrder));
        return archiveTimeStampChainObject;
    }

    private List<? extends ArchiveTimeStampObject> getXmlArchiveTimeStamps(Element archiveTimeStampChain, int archiveTimeStampChainOrder) {
        NodeList archiveTimeStampList = DomUtils.getNodeList(archiveTimeStampChain, XMLERSPath.ARCHIVE_TIME_STAMP_PATH);
        if (archiveTimeStampList != null && archiveTimeStampList.getLength() > 0) {
            XmlArchiveTimeStampObject[] result = new XmlArchiveTimeStampObject[archiveTimeStampList.getLength()];
            for (int i = 0; i < archiveTimeStampList.getLength(); ++i) {
                Element archiveTimeStampElement = (Element)archiveTimeStampList.item(i);
                XmlArchiveTimeStampObject archiveTimeStamp = this.getXmlArchiveTimeStampObject(archiveTimeStampElement, archiveTimeStampChainOrder, i);
                int order = archiveTimeStamp.getOrder();
                result[order - 1] = archiveTimeStamp;
            }
            return Arrays.asList(result);
        }
        return Collections.emptyList();
    }

    private XmlArchiveTimeStampObject getXmlArchiveTimeStampObject(Element archiveTimeStampElement, int archiveTimeStampChainOrder, int archieTimeStampOrder) {
        XmlArchiveTimeStampObject archiveTimeStampObject = new XmlArchiveTimeStampObject(archiveTimeStampElement);
        archiveTimeStampObject.setHashTree(this.getHashTree(archiveTimeStampElement));
        archiveTimeStampObject.setTimestampToken(this.getTimestampToken(archiveTimeStampElement, archiveTimeStampChainOrder, archieTimeStampOrder));
        archiveTimeStampObject.setCryptographicInformationList(this.getCryptographicInformationList(archiveTimeStampElement));
        archiveTimeStampObject.setOrder(this.getOrderAttributeValue(archiveTimeStampElement));
        return archiveTimeStampObject;
    }

    private TimestampToken getTimestampToken(Element archiveTimeStampElement, int archiveTimeStampChainOrder, int archieTimeStampOrder) {
        Element timeStampTokenElement = DomUtils.getElement(archiveTimeStampElement, XMLERSPath.TIME_STAMP_TOKEN_PATH);
        if (timeStampTokenElement == null) {
            throw new IllegalInputException("TimeStampToken shall be defined!");
        }
        String base64EncodedTimeStamp = timeStampTokenElement.getTextContent();
        if (!Utils.isBase64Encoded(base64EncodedTimeStamp)) {
            throw new IllegalInputException("The content of TimeStampToken shall be represented by a base64-encoded value!");
        }
        try {
            byte[] binaries = Utils.fromBase64(base64EncodedTimeStamp);
            EvidenceRecordTimestampIdentifierBuilder identifierBuilder = new EvidenceRecordTimestampIdentifierBuilder(binaries).setArchiveTimeStampChainOrder(archiveTimeStampChainOrder).setArchiveTimeStampOrder(archieTimeStampOrder).setFilename(this.filename);
            if (this.embeddedEvidenceRecordHelper != null) {
                identifierBuilder = identifierBuilder.setEvidenceRecordAttributeOrder(this.embeddedEvidenceRecordHelper.getOrderOfAttribute()).setEvidenceRecordWithinAttributeOrder(this.embeddedEvidenceRecordHelper.getOrderWithinAttribute());
            }
            return new TimestampToken(binaries, TimestampType.EVIDENCE_RECORD_TIMESTAMP, new ArrayList<TimestampedReference>(), (TimestampIdentifierBuilder)identifierBuilder);
        }
        catch (Exception e) {
            LOG.warn("Unable to create a time-stamp token. Reason : {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private List<XmlSequenceObject> getHashTree(Element archiveTimeStampElement) {
        NodeList hashTree = DomUtils.getNodeList(archiveTimeStampElement, XMLERSPath.HASH_TREE_SEQUENCE_PATH);
        if (hashTree != null && hashTree.getLength() > 0) {
            XmlSequenceObject[] result = new XmlSequenceObject[hashTree.getLength()];
            for (int i = 0; i < hashTree.getLength(); ++i) {
                Element sequenceElement = (Element)hashTree.item(i);
                XmlSequenceObject digestValueGroup = this.getDigestValueGroup(sequenceElement);
                int order = digestValueGroup.getOrder();
                result[order - 1] = digestValueGroup;
            }
            return Arrays.asList(result);
        }
        return Collections.emptyList();
    }

    private XmlSequenceObject getDigestValueGroup(Element sequenceElement) {
        XmlSequenceObject digestValueGroup = new XmlSequenceObject(sequenceElement);
        digestValueGroup.setDigestValues(this.getDigestValues(sequenceElement));
        digestValueGroup.setOrder(this.getOrderAttributeValue(sequenceElement));
        return digestValueGroup;
    }

    private List<byte[]> getDigestValues(Element sequenceElement) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        NodeList digestValueList = DomUtils.getNodeList(sequenceElement, XMLERSPath.DIGEST_VALUE_PATH);
        for (int i = 0; i < digestValueList.getLength(); ++i) {
            Element digestValueElement = (Element)digestValueList.item(i);
            String textContent = digestValueElement.getTextContent();
            if (!Utils.isBase64Encoded(textContent)) {
                throw new IllegalInputException("DigestValue is not base64-encoded!");
            }
            result.add(Utils.fromBase64(textContent));
        }
        return result;
    }

    private int getOrderAttributeValue(Element element) {
        String order = element.getAttribute(XMLERSAttribute.ORDER.getAttributeName());
        if (Utils.isStringDigits(order)) {
            return Integer.parseInt(order);
        }
        throw new IllegalInputException("The Order attribute shall be defined!");
    }

    private DigestAlgorithm getDigestAlgorithm(Element archiveTimeStampChainElement) {
        Element digestMethod = DomUtils.getElement(archiveTimeStampChainElement, XMLERSPath.DIGEST_METHOD_PATH);
        if (digestMethod == null) {
            throw new IllegalInputException("The DigestMethod element shall be present!");
        }
        String digestMethodValue = digestMethod.getAttribute(XMLERSAttribute.ALGORITHM.getAttributeName());
        if (Utils.isStringEmpty(digestMethodValue)) {
            throw new IllegalInputException("The Algorithm attribute shall be defined!");
        }
        return DigestAlgorithm.forXML(digestMethodValue);
    }

    private String getCanonicalizationMethod(Element archiveTimeStampChainElement) {
        Element canonicalizationMethod = DomUtils.getElement(archiveTimeStampChainElement, XMLERSPath.CANONICALIZATION_METHOD_PATH);
        if (canonicalizationMethod == null) {
            throw new IllegalInputException("The CanonicalizationMethod element shall be present!");
        }
        String canonicalizationAttribute = canonicalizationMethod.getAttribute(XMLERSAttribute.ALGORITHM.getAttributeName());
        if (Utils.isStringEmpty(canonicalizationAttribute)) {
            throw new IllegalInputException("The Algorithm attribute shall be defined!");
        }
        return canonicalizationAttribute;
    }

    private List<CryptographicInformation> getCryptographicInformationList(Element archiveTimeStampElement) {
        NodeList cryptographicInformationNodeList = DomUtils.getNodeList(archiveTimeStampElement, XMLERSPath.CRYPTOGRAPHIC_INFORMATION_PATH);
        if (cryptographicInformationNodeList == null || cryptographicInformationNodeList.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<CryptographicInformation> cryptographicInformationList = new ArrayList<CryptographicInformation>();
        for (int i = 0; i < cryptographicInformationNodeList.getLength(); ++i) {
            Element cryptographicInformationElement = (Element)cryptographicInformationNodeList.item(i);
            String type = cryptographicInformationElement.getAttribute(XMLERSAttribute.TYPE.getAttributeName());
            if (Utils.isStringEmpty(type)) {
                LOG.warn("Type attribute shall be defined within CryptographicInformation element! Element is skipped.");
                continue;
            }
            CryptographicInformationType cryptographicInformationType = CryptographicInformationType.fromLabel(type);
            String textContent = cryptographicInformationElement.getTextContent();
            if (!Utils.isBase64Encoded(textContent)) {
                LOG.warn("Value within CryptographicInformation element shall be base64-encoded! Element is skipped.");
                continue;
            }
            cryptographicInformationList.add(new CryptographicInformation(Utils.fromBase64(textContent), cryptographicInformationType));
        }
        return cryptographicInformationList;
    }
}

