/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.evidencerecord.common.validation;

import java.util.Objects;

public enum CryptographicInformationType {
    CRL("CRL"),
    OCSP("OCSP"),
    SCVP("SCVP"),
    CERT("CERT");

    private final String label;

    private CryptographicInformationType(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public static CryptographicInformationType fromLabel(String label) {
        Objects.requireNonNull(label, "Label shall be provided!");
        for (CryptographicInformationType type : CryptographicInformationType.values()) {
            if (!label.equals(type.label)) continue;
            return type;
        }
        return null;
    }
}

