/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureProfile;
import java.util.Objects;

public enum SignatureLevel {
    XML_NOT_ETSI(SignatureForm.XAdES, SignatureProfile.NOT_ETSI),
    XAdES_BES(SignatureForm.XAdES, SignatureProfile.EXTENDED_BES),
    XAdES_EPES(SignatureForm.XAdES, SignatureProfile.EXTENDED_EPES),
    XAdES_T(SignatureForm.XAdES, SignatureProfile.EXTENDED_T),
    XAdES_LT(SignatureForm.XAdES, SignatureProfile.EXTENDED_LT),
    XAdES_C(SignatureForm.XAdES, SignatureProfile.EXTENDED_C),
    XAdES_X(SignatureForm.XAdES, SignatureProfile.EXTENDED_X),
    XAdES_XL(SignatureForm.XAdES, SignatureProfile.EXTENDED_XL),
    XAdES_A(SignatureForm.XAdES, SignatureProfile.EXTENDED_A),
    XAdES_ERS(SignatureForm.XAdES, SignatureProfile.EXTENDED_ERS),
    XAdES_BASELINE_B(SignatureForm.XAdES, SignatureProfile.BASELINE_B),
    XAdES_BASELINE_T(SignatureForm.XAdES, SignatureProfile.BASELINE_T),
    XAdES_BASELINE_LT(SignatureForm.XAdES, SignatureProfile.BASELINE_LT),
    XAdES_BASELINE_LTA(SignatureForm.XAdES, SignatureProfile.BASELINE_LTA),
    CMS_NOT_ETSI(SignatureForm.CAdES, SignatureProfile.NOT_ETSI),
    CAdES_BES(SignatureForm.CAdES, SignatureProfile.EXTENDED_BES),
    CAdES_EPES(SignatureForm.CAdES, SignatureProfile.EXTENDED_EPES),
    CAdES_T(SignatureForm.CAdES, SignatureProfile.EXTENDED_T),
    CAdES_LT(SignatureForm.CAdES, SignatureProfile.EXTENDED_LT),
    CAdES_C(SignatureForm.CAdES, SignatureProfile.EXTENDED_C),
    CAdES_X(SignatureForm.CAdES, SignatureProfile.EXTENDED_X),
    CAdES_XL(SignatureForm.CAdES, SignatureProfile.EXTENDED_XL),
    CAdES_A(SignatureForm.CAdES, SignatureProfile.EXTENDED_A),
    CAdES_ERS(SignatureForm.CAdES, SignatureProfile.EXTENDED_ERS),
    CAdES_BASELINE_B(SignatureForm.CAdES, SignatureProfile.BASELINE_B),
    CAdES_BASELINE_T(SignatureForm.CAdES, SignatureProfile.BASELINE_T),
    CAdES_BASELINE_LT(SignatureForm.CAdES, SignatureProfile.BASELINE_LT),
    CAdES_BASELINE_LTA(SignatureForm.CAdES, SignatureProfile.BASELINE_LTA),
    PDF_NOT_ETSI(SignatureForm.PAdES, SignatureProfile.NOT_ETSI),
    PKCS7_B(SignatureForm.PKCS7, SignatureProfile.NOT_ETSI),
    PKCS7_T(SignatureForm.PKCS7, SignatureProfile.NOT_ETSI),
    PKCS7_LT(SignatureForm.PKCS7, SignatureProfile.NOT_ETSI),
    PKCS7_LTA(SignatureForm.PKCS7, SignatureProfile.NOT_ETSI),
    PAdES_BES(SignatureForm.PAdES, SignatureProfile.EXTENDED_BES),
    PAdES_EPES(SignatureForm.PAdES, SignatureProfile.EXTENDED_EPES),
    PAdES_LTV(SignatureForm.PAdES, SignatureProfile.EXTENDED_LTV),
    PAdES_BASELINE_B(SignatureForm.PAdES, SignatureProfile.BASELINE_B),
    PAdES_BASELINE_T(SignatureForm.PAdES, SignatureProfile.BASELINE_T),
    PAdES_BASELINE_LT(SignatureForm.PAdES, SignatureProfile.BASELINE_LT),
    PAdES_BASELINE_LTA(SignatureForm.PAdES, SignatureProfile.BASELINE_LTA),
    JSON_NOT_ETSI(SignatureForm.JAdES, SignatureProfile.NOT_ETSI),
    JAdES_BASELINE_B(SignatureForm.JAdES, SignatureProfile.BASELINE_B),
    JAdES_BASELINE_T(SignatureForm.JAdES, SignatureProfile.BASELINE_T),
    JAdES_BASELINE_LT(SignatureForm.JAdES, SignatureProfile.BASELINE_LT),
    JAdES_BASELINE_LTA(SignatureForm.JAdES, SignatureProfile.BASELINE_LTA),
    UNKNOWN(null, SignatureProfile.NOT_ETSI);

    private final SignatureForm signatureForm;
    private final SignatureProfile signatureProfile;

    private SignatureLevel(SignatureForm signatureForm, SignatureProfile signatureProfile) {
        this.signatureForm = signatureForm;
        this.signatureProfile = signatureProfile;
    }

    public static SignatureLevel valueByName(String name) {
        return SignatureLevel.valueOf(name.replace('-', '_'));
    }

    public String toString() {
        return super.toString().replace('_', '-');
    }

    public SignatureForm getSignatureForm() {
        if (this.signatureForm == null) {
            throw new UnsupportedOperationException(String.format("The signature level '%s' is not supported!", new Object[]{this}));
        }
        return this.signatureForm;
    }

    public SignatureProfile getSignatureProfile() {
        if (this.signatureProfile == null) {
            throw new UnsupportedOperationException(String.format("The signature level '%s' is not supported!", new Object[]{this}));
        }
        return this.signatureProfile;
    }

    public static SignatureLevel getSignatureLevel(SignatureForm signatureForm, SignatureProfile signatureProfile) {
        for (SignatureLevel currentLevel : SignatureLevel.values()) {
            if (!Objects.equals((Object)signatureForm, (Object)currentLevel.getSignatureForm()) || !Objects.equals((Object)signatureProfile, (Object)currentLevel.getSignatureProfile())) continue;
            return currentLevel;
        }
        return null;
    }
}

