/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms;

import eu.europa.esig.dss.cms.CMSSignedAttributeTableGenerator;
import eu.europa.esig.dss.cms.operator.CustomMessageDigestCalculatorProvider;
import eu.europa.esig.dss.cms.operator.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;

public class CMSSignerInfoGeneratorBuilder {
    protected CertificateToken signingCertificate;
    protected DigestAlgorithm digestAlgorithm;
    protected AttributeTable signedAttributes;
    protected AttributeTable unsignedAttributes;

    public CMSSignerInfoGeneratorBuilder setSigningCertificate(CertificateToken signingCertificate) {
        this.signingCertificate = signingCertificate;
        return this;
    }

    public CMSSignerInfoGeneratorBuilder setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public CMSSignerInfoGeneratorBuilder setSignedAttributes(AttributeTable signedAttributes) {
        this.signedAttributes = signedAttributes;
        return this;
    }

    public CMSSignerInfoGeneratorBuilder setUnsignedAttributes(AttributeTable unsignedAttributes) {
        this.unsignedAttributes = unsignedAttributes;
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner) {
        return this.build(null, contentSigner);
    }

    public SignerInfoGenerator build(DSSDocument toSignDocument, ContentSigner contentSigner) {
        DigestCalculatorProvider digestCalculatorProvider = this.getDigestCalculatorProvider(toSignDocument);
        SignerInfoGeneratorBuilder signerInfoGeneratorBuilder = this.getSignerInfoGeneratorBuilder(digestCalculatorProvider);
        return this.getSignerInfoGenerator(signerInfoGeneratorBuilder, contentSigner);
    }

    protected DigestCalculatorProvider getDigestCalculatorProvider(DSSDocument toSignDocument) {
        if (this.digestAlgorithm != null) {
            return new CustomMessageDigestCalculatorProvider(this.digestAlgorithm, toSignDocument.getDigestValue(this.digestAlgorithm));
        }
        if (toSignDocument instanceof DigestDocument) {
            return new PrecomputedDigestCalculatorProvider(toSignDocument);
        }
        return new BcDigestCalculatorProvider();
    }

    protected SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider) {
        if (DSSASN1Utils.isEmpty(this.signedAttributes)) {
            this.signedAttributes = null;
        }
        CMSSignedAttributeTableGenerator signedAttributeGenerator = new CMSSignedAttributeTableGenerator(this.signedAttributes);
        if (DSSASN1Utils.isEmpty(this.unsignedAttributes)) {
            this.unsignedAttributes = null;
        }
        SimpleAttributeTableGenerator unsignedAttributeGenerator = new SimpleAttributeTableGenerator(this.unsignedAttributes);
        SignerInfoGeneratorBuilder sigInfoGeneratorBuilder = new SignerInfoGeneratorBuilder(digestCalculatorProvider);
        sigInfoGeneratorBuilder.setSignedAttributeGenerator(signedAttributeGenerator);
        sigInfoGeneratorBuilder.setUnsignedAttributeGenerator(unsignedAttributeGenerator);
        return sigInfoGeneratorBuilder;
    }

    private SignerInfoGenerator getSignerInfoGenerator(SignerInfoGeneratorBuilder signerInfoGeneratorBuilder, ContentSigner contentSigner) {
        try {
            if (this.signingCertificate != null) {
                X509CertificateHolder certHolder = DSSASN1Utils.getX509CertificateHolder(this.signingCertificate);
                return signerInfoGeneratorBuilder.build(contentSigner, certHolder);
            }
            SignerId signerId = new SignerId(DSSUtils.EMPTY_BYTE_ARRAY);
            return signerInfoGeneratorBuilder.build(contentSigner, signerId.getSubjectKeyIdentifier());
        }
        catch (OperatorCreationException e) {
            throw new DSSException(String.format("Unable to create a SignerInfoGenerator. Reason : %s", e.getMessage()), e);
        }
    }
}

