/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestAttribute;
import eu.europa.esig.dss.asic.xades.definition.ManifestElement;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithXAdESManifestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithXAdESManifestBuilder.class);
    private List<DSSDocument> documents;
    private List<ManifestEntry> entries;
    private String manifestFilename;

    public ASiCEWithXAdESManifestBuilder setDocuments(List<DSSDocument> documents) {
        this.documents = documents;
        return this;
    }

    public ASiCEWithXAdESManifestBuilder setEntries(List<ManifestEntry> entries) {
        this.entries = entries;
        return this;
    }

    public ASiCEWithXAdESManifestBuilder setManifestFilename(String manifestFilename) {
        this.manifestFilename = manifestFilename;
        return this;
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = DomUtils.createElementNS(documentDom, ManifestNamespace.NS, ManifestElement.MANIFEST);
        DomUtils.setAttributeNS(manifestDom, ManifestNamespace.NS, ManifestAttribute.VERSION, "1.2");
        documentDom.appendChild(manifestDom);
        Element rootDom = DomUtils.addElement(documentDom, manifestDom, ManifestNamespace.NS, ManifestElement.FILE_ENTRY);
        DomUtils.setAttributeNS(rootDom, ManifestNamespace.NS, ManifestAttribute.FULL_PATH, "/");
        DomUtils.setAttributeNS(rootDom, ManifestNamespace.NS, ManifestAttribute.MEDIA_TYPE, MimeTypeEnum.ASICE.getMimeTypeString());
        for (ManifestEntry entry : this.getEntries()) {
            Objects.requireNonNull(entry, "ManifestEntry cannot be null!");
            Objects.requireNonNull(entry.getUri(), "ManifestEntry#Uri cannot be null! Please define the document's name.");
            Element fileDom = DomUtils.addElement(documentDom, manifestDom, ManifestNamespace.NS, ManifestElement.FILE_ENTRY);
            DomUtils.setAttributeNS(fileDom, ManifestNamespace.NS, ManifestAttribute.FULL_PATH, entry.getUri());
            MimeType mimeType = entry.getMimeType();
            if (mimeType == null) {
                LOG.warn("No MimeType is defined for a manifest entry with URI '{}'! Using a default MimeType...", (Object)entry.getUri());
                mimeType = MimeTypeEnum.BINARY;
            }
            DomUtils.setAttributeNS(fileDom, ManifestNamespace.NS, ManifestAttribute.MEDIA_TYPE, mimeType.getMimeTypeString());
        }
        return DomUtils.createDssDocumentFromDomDocument(documentDom, this.manifestFilename);
    }

    private List<ManifestEntry> getEntries() {
        if (Utils.isCollectionNotEmpty(this.documents) && Utils.isCollectionNotEmpty(this.entries)) {
            throw new IllegalArgumentException("Either DSSDocuments or ManifestEntries shall be provided!");
        }
        if (Utils.isCollectionNotEmpty(this.documents)) {
            return ASiCUtils.toSimpleManifestEntries(this.documents);
        }
        if (Utils.isCollectionNotEmpty(this.entries)) {
            return this.entries;
        }
        throw new NullPointerException("Either DSSDocuments or ManifestEntries shall be provided!");
    }
}

