/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.jmail;

import com.sanctionco.jmail.Email;
import com.sanctionco.jmail.TopLevelDomain;
import com.sanctionco.jmail.disposable.DisposableDomainSource;
import com.sanctionco.jmail.dns.DNSLookupUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ValidationRules {
    private static final Set<String> reservedTopLevelDomains = new HashSet<String>(Arrays.asList("test", "invalid", "example", "localhost"));
    private static final Set<TopLevelDomain> reservedExampleTlds = new HashSet<TopLevelDomain>(Arrays.asList(TopLevelDomain.DOT_COM, TopLevelDomain.DOT_NET, TopLevelDomain.DOT_ORG));

    private ValidationRules() {
    }

    public static boolean disallowIpDomain(Email email) {
        return !email.isIpAddress();
    }

    public static boolean requireTopLevelDomain(Email email) {
        return email.isIpAddress() || !email.topLevelDomain().equals(TopLevelDomain.NONE);
    }

    public static boolean disallowSingleCharacterTopLevelDomains(Email email) {
        return email.topLevelDomain().equals(TopLevelDomain.NONE) || email.topLevelDomain().stringValue().length() > 1;
    }

    public static boolean disallowExplicitSourceRouting(Email email) {
        return email.explicitSourceRoutes().size() <= 0;
    }

    public static boolean disallowQuotedIdentifiers(Email email) {
        return !email.hasIdentifier();
    }

    public static boolean requireOnlyTopLevelDomains(Email email, Set<TopLevelDomain> allowed) {
        return allowed.contains(email.topLevelDomain());
    }

    public static boolean disallowObsoleteWhitespace(Email email) {
        return !email.containsWhitespace();
    }

    public static boolean disallowReservedDomains(Email email) {
        List<String> domainParts = email.domainParts();
        if (reservedTopLevelDomains.contains(domainParts.get(domainParts.size() - 1).toLowerCase())) {
            return false;
        }
        return domainParts.size() <= 1 || !"example".equals(domainParts.get(domainParts.size() - 2).toLowerCase()) || !reservedExampleTlds.contains(email.topLevelDomain());
    }

    public static boolean requireValidMXRecord(Email email) {
        return DNSLookupUtil.hasMXRecord(email.domainWithoutComments());
    }

    public static boolean requireValidMXRecord(Email email, int initialTimeout, int numRetries) {
        return DNSLookupUtil.hasMXRecord(email.domainWithoutComments(), initialTimeout, numRetries);
    }

    public static boolean disallowDisposableDomains(Email email, DisposableDomainSource disposableDomainSource) {
        return email.isIpAddress() || !disposableDomainSource.isDisposableDomain(email.domainWithoutComments());
    }

    public static boolean requireAscii(Email email) {
        return email.isAscii();
    }
}

