/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftspwatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class TimestampDigestAlgorithmValidationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final TimestampWrapper timestamp;
    private final XmlCryptographicValidation cvResult;
    private final Date currentTime;

    public TimestampDigestAlgorithmValidationCheck(I18nProvider i18nProvider, T result, TimestampWrapper timestamp, XmlCryptographicValidation cvResult, Date currentTime, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.timestamp = timestamp;
        this.cvResult = cvResult;
        this.currentTime = currentTime;
    }

    @Override
    protected boolean process() {
        return this.cvResult != null && this.isValidConclusion(this.cvResult.getConclusion());
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ARCH_ICHFCRLPOET;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ARCH_ICHFCRLPOET_ANS;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.currentTime);
        if (this.process()) {
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_DM_WITH_ID, new Object[]{this.timestamp.getMessageImprint().getDigestMethod(), dateTime, MessageTag.ACCM_POS_MESS_IMP, this.timestamp.getId()});
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_ID, new Object[]{this.timestamp.getMessageImprint().getDigestMethod(), dateTime, MessageTag.ACCM_POS_MESS_IMP, this.timestamp.getId()});
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.cvResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.cvResult.getConclusion().getSubIndication();
    }
}

