/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;

public class BasicTimestampValidationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    protected final TimestampWrapper timestamp;
    private final XmlValidationProcessBasicTimestamp timestampValidationResult;

    public BasicTimestampValidationCheck(I18nProvider i18nProvider, T result, TimestampWrapper timestamp, XmlValidationProcessBasicTimestamp timestampValidationResult, LevelRule constraint) {
        this(i18nProvider, result, timestamp, timestampValidationResult, constraint, null);
    }

    protected BasicTimestampValidationCheck(I18nProvider i18nProvider, T result, TimestampWrapper timestamp, XmlValidationProcessBasicTimestamp timestampValidationResult, LevelRule constraint, String bbbId) {
        super(i18nProvider, result, constraint, bbbId);
        this.timestamp = timestamp;
        this.timestampValidationResult = timestampValidationResult;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.TST_BBB;
    }

    @Override
    protected boolean process() {
        return this.isValid(this.timestampValidationResult);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_IBSVPTC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_IBSVPTC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.timestampValidationResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.timestampValidationResult.getConclusion().getSubIndication();
    }
}

