/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class TimestampGenerationTimeNotAfterRevocationTimeCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final TimestampWrapper contentTimestamp;
    private final Date signingCertificateRevocationTime;

    public TimestampGenerationTimeNotAfterRevocationTimeCheck(I18nProvider i18nProvider, T result, TimestampWrapper contentTimestamp, Date signingCertificateRevocationTime, LevelRule constraint) {
        super(i18nProvider, result, constraint, contentTimestamp.getId());
        this.contentTimestamp = contentTimestamp;
        this.signingCertificateRevocationTime = signingCertificateRevocationTime;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.CNT_TST_BBB;
    }

    @Override
    protected boolean process() {
        return this.contentTimestamp.getProductionTime() != null && !this.contentTimestamp.getProductionTime().after(this.signingCertificateRevocationTime);
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.REVOKED;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BSV_ICTGTNASCRT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BSV_ICTGTNASCRT_ANS;
    }

    @Override
    protected String buildAdditionalInfo() {
        String tstGenerationTime = this.contentTimestamp.getProductionTime() == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.contentTimestamp.getProductionTime());
        String revocationTime = this.signingCertificateRevocationTime == null ? " ? " : ValidationProcessUtils.getFormattedDate(this.signingCertificateRevocationTime);
        return this.i18nProvider.getMessage(MessageTag.TIMESTAMP_AND_REVOCATION_TIME, this.contentTimestamp.getId(), tstGenerationTime, revocationTime);
    }
}

