/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustServiceCondition;
import java.util.List;

public class TrustServiceQSCDPostEIDASConsistency
implements TrustServiceCondition {
    @Override
    public boolean isConsistent(TrustServiceWrapper trustService) {
        if (EIDASUtils.isPostEIDAS(trustService.getStartDate())) {
            boolean qcPostEIDAS;
            List<String> capturedQualifiers = trustService.getCapturedQualifierUris();
            boolean qcPreEIDAS = ServiceQualification.isQcWithSSCD(capturedQualifiers) || ServiceQualification.isQcNoSSCD(capturedQualifiers);
            boolean bl = qcPostEIDAS = ServiceQualification.isQcWithQSCD(capturedQualifiers) || ServiceQualification.isQcNoQSCD(capturedQualifiers);
            if (qcPreEIDAS) {
                return qcPostEIDAS;
            }
        }
        return true;
    }
}

