/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.signature.qwac;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateQualificationProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusionWithProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlQWACProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.CertQualificationAtTimeForQWACBlock;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.QWACForTLSBindingCertificateValidationBlock;
import eu.europa.esig.dss.validation.process.qualification.signature.SignatureQualificationBlock;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TLSBindingSignatureQualificationBlock
extends SignatureQualificationBlock {
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final SignatureWrapper bindingSignature;
    private final String websiteUrl;

    public TLSBindingSignatureQualificationBlock(I18nProvider i18nProvider, Map<String, XmlBasicBuildingBlocks> bbbs, XmlConstraintsConclusionWithProofOfExistence etsi319102validation, SignatureWrapper bindingSignature, List<XmlTLAnalysis> tlAnalysis, String websiteUrl) {
        super(i18nProvider, etsi319102validation, bindingSignature.getSigningCertificate(), tlAnalysis);
        this.bbbs = bbbs;
        this.bindingSignature = bindingSignature;
        this.websiteUrl = websiteUrl;
    }

    @Override
    protected void initChain() {
        super.initChain();
        QWACForTLSBindingCertificateValidationBlock qwacForTLSBindingValidationBlock = new QWACForTLSBindingCertificateValidationBlock(this.i18nProvider, this.bestSignatureTime, this.bindingSignature, this.signingCertificate, this.bbbs, this.getCertificateQualification(), this.websiteUrl);
        XmlQWACProcess qwacProcess = (XmlQWACProcess)qwacForTLSBindingValidationBlock.execute();
        ((XmlValidationSignatureQualification)this.result).setQWACProcess(qwacProcess);
    }

    private XmlCertificateQualificationProcess getCertificateQualification() {
        XmlCertificateQualificationProcess xmlCertificateQualificationProcess = new XmlCertificateQualificationProcess();
        xmlCertificateQualificationProcess.getValidationCertificateQualification().addAll(((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification());
        if (Utils.isCollectionEmpty(((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification())) {
            xmlCertificateQualificationProcess.setConclusion(this.getConclusion(Indication.FAILED));
            return xmlCertificateQualificationProcess;
        }
        for (XmlValidationCertificateQualification certificateQualificationAtTime : ((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification()) {
            if (this.isValid(certificateQualificationAtTime)) continue;
            ((XmlValidationSignatureQualification)this.result).setConclusion(this.getConclusion(certificateQualificationAtTime.getConclusion()));
            return xmlCertificateQualificationProcess;
        }
        xmlCertificateQualificationProcess.setConclusion(this.getConclusion(Indication.PASSED));
        return xmlCertificateQualificationProcess;
    }

    private XmlConclusion getConclusion(Indication indication) {
        XmlConclusion xmlConclusion = new XmlConclusion();
        xmlConclusion.setIndication(indication);
        return xmlConclusion;
    }

    private XmlConclusion getConclusion(XmlConclusion conclusion) {
        XmlConclusion xmlConclusion = new XmlConclusion();
        xmlConclusion.setIndication(conclusion.getIndication());
        xmlConclusion.setSubIndication(conclusion.getSubIndication());
        xmlConclusion.getErrors().addAll(new ArrayList<XmlMessage>(conclusion.getErrors()));
        xmlConclusion.getWarnings().addAll(new ArrayList<XmlMessage>(conclusion.getWarnings()));
        xmlConclusion.getInfos().addAll(new ArrayList<XmlMessage>(conclusion.getInfos()));
        return xmlConclusion;
    }

    @Override
    protected CertQualificationAtTimeBlock getCertQualificationAtIssuanceTimeBlock(List<TrustServiceWrapper> acceptableServices) {
        return new CertQualificationAtTimeForQWACBlock(this.i18nProvider, ValidationTime.CERTIFICATE_ISSUANCE_TIME, this.signingCertificate, acceptableServices);
    }

    @Override
    protected CertQualificationAtTimeBlock getCertQualificationAtSigningTimeBlock(List<TrustServiceWrapper> acceptableServices, Date signingTime) {
        return new CertQualificationAtTimeForQWACBlock(this.i18nProvider, ValidationTime.VALIDATION_TIME, signingTime, this.signingCertificate, acceptableServices);
    }
}

