/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.enumerations.ExtendedKeyUsage;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class QWAC2ExtKeyUsageCheck
extends ChainItem<XmlValidationQWACProcess> {
    private final CertificateWrapper certificate;

    public QWAC2ExtKeyUsageCheck(I18nProvider i18nProvider, XmlValidationQWACProcess result, CertificateWrapper certificate, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        List<XmlOID> extendedKeyUsages = this.certificate.getExtendedKeyUsages();
        return Utils.collectionSize(extendedKeyUsages) == 1 && ExtendedKeyUsage.TSL_BINDING_MOD.getOid().equals(extendedKeyUsages.get(0).getValue());
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QWAC2_EXT_KEY_USAGE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QWAC2_EXT_KEY_USAGE_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

