/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateQualificationProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.AcceptableBuildingBlockConclusionCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableListOfTrustedListsCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListPresenceCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServicesFilterFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CertificateQualificationBlock
extends Chain<XmlCertificateQualificationProcess> {
    protected final XmlConclusion buildingBlocksConclusion;
    protected final Date validationTime;
    protected final CertificateWrapper signingCertificate;
    protected final List<XmlTLAnalysis> tlAnalysis;

    public CertificateQualificationBlock(I18nProvider i18nProvider, XmlConclusion buildingBlocksConclusion, Date validationTime, CertificateWrapper signingCertificate, List<XmlTLAnalysis> tlAnalysis) {
        super(i18nProvider, new XmlCertificateQualificationProcess());
        Objects.requireNonNull(validationTime, "The validationTime shall be provided!");
        Objects.requireNonNull(signingCertificate, "The signingCertificate shall be provided!");
        ((XmlCertificateQualificationProcess)this.result).setId(signingCertificate.getId());
        this.buildingBlocksConclusion = buildingBlocksConclusion;
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.tlAnalysis = tlAnalysis;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CERT_QUALIFICATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCertificateQualificationProcess> item = this.firstItem = this.isAcceptableBuildingBlockConclusion(this.buildingBlocksConclusion);
        HashSet<String> acceptableTLUrls = new HashSet<String>();
        List<TrustServiceWrapper> originalTSPs = this.signingCertificate.getTrustServices();
        if (this.signingCertificate.isTrustedListReached()) {
            Set listOfTrustedListUrls = originalTSPs.stream().filter(t -> t.getListOfTrustedLists() != null).map(t -> t.getListOfTrustedLists().getUrl()).collect(Collectors.toSet());
            HashSet<Object> acceptableLOTLUrls = new HashSet<Object>();
            for (Object lotlURL : listOfTrustedListUrls) {
                XmlTLAnalysis lotlAnalysis = this.getTlAnalysis((String)lotlURL);
                if (lotlAnalysis == null) continue;
                AcceptableListOfTrustedListsCheck<XmlCertificateQualificationProcess> acceptableLOTL = this.isAcceptableLOTL(lotlAnalysis);
                item = item.setNextItem(acceptableLOTL);
                if (!acceptableLOTL.process()) continue;
                acceptableLOTLUrls.add(lotlURL);
            }
            Set trustedListUrls = originalTSPs.stream().filter(t -> t.getTrustedList() != null && (t.getListOfTrustedLists() == null || acceptableLOTLUrls.contains(t.getListOfTrustedLists().getUrl()))).map(t -> t.getTrustedList().getUrl()).collect(Collectors.toSet());
            if (Utils.isCollectionNotEmpty(trustedListUrls)) {
                for (String tlURL : trustedListUrls) {
                    XmlTLAnalysis currentTL = this.getTlAnalysis(tlURL);
                    if (currentTL == null) continue;
                    AcceptableTrustedListCheck<XmlCertificateQualificationProcess> acceptableTL = this.isAcceptableTL(currentTL);
                    item = item.setNextItem(acceptableTL);
                    if (!acceptableTL.process()) continue;
                    acceptableTLUrls.add(tlURL);
                }
            }
        }
        item = item.setNextItem(this.isAcceptableTLPresent(acceptableTLUrls));
        if (Utils.isCollectionNotEmpty(acceptableTLUrls)) {
            TrustServiceFilter filter = TrustServicesFilterFactory.createFilterByUrls(acceptableTLUrls);
            List<TrustServiceWrapper> acceptableServices = filter.filter(originalTSPs);
            CertQualificationAtTimeBlock certQualAtIssuanceBlock = this.getCertQualificationAtIssuanceTimeBlock(acceptableServices);
            ((XmlCertificateQualificationProcess)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtIssuanceBlock.execute());
            CertQualificationAtTimeBlock certQualAtValidationTimeBlock = this.getCertQualificationAtValidationTimeBlock(acceptableServices);
            ((XmlCertificateQualificationProcess)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtValidationTimeBlock.execute());
        }
    }

    protected CertQualificationAtTimeBlock getCertQualificationAtIssuanceTimeBlock(List<TrustServiceWrapper> acceptableServices) {
        return new CertQualificationAtTimeBlock(this.i18nProvider, ValidationTime.CERTIFICATE_ISSUANCE_TIME, this.signingCertificate, acceptableServices);
    }

    protected CertQualificationAtTimeBlock getCertQualificationAtValidationTimeBlock(List<TrustServiceWrapper> acceptableServices) {
        return new CertQualificationAtTimeBlock(this.i18nProvider, ValidationTime.VALIDATION_TIME, this.validationTime, this.signingCertificate, acceptableServices);
    }

    private XmlTLAnalysis getTlAnalysis(String url) {
        if (Utils.isCollectionNotEmpty(this.tlAnalysis)) {
            for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
                if (!Utils.areStringsEqual(url, xmlTLAnalysis.getURL())) continue;
                return xmlTLAnalysis;
            }
        }
        return null;
    }

    @Override
    protected void addAdditionalInfo() {
        this.setIndication();
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlCertificateQualificationProcess)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty(conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty(conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private AcceptableListOfTrustedListsCheck<XmlCertificateQualificationProcess> isAcceptableLOTL(XmlTLAnalysis xmlLOTLAnalysis) {
        return new AcceptableListOfTrustedListsCheck<XmlCertificateQualificationProcess>(this.i18nProvider, (XmlCertificateQualificationProcess)this.result, xmlLOTLAnalysis, this.getWarnLevelRule());
    }

    private AcceptableTrustedListCheck<XmlCertificateQualificationProcess> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlCertificateQualificationProcess>(this.i18nProvider, (XmlCertificateQualificationProcess)this.result, xmlTLAnalysis, this.getWarnLevelRule());
    }

    private ChainItem<XmlCertificateQualificationProcess> isAcceptableTLPresent(Set<String> acceptableUrls) {
        return new AcceptableTrustedListPresenceCheck<XmlCertificateQualificationProcess>(this.i18nProvider, (XmlCertificateQualificationProcess)this.result, acceptableUrls, this.getFailLevelRule());
    }

    private ChainItem<XmlCertificateQualificationProcess> isAcceptableBuildingBlockConclusion(XmlConclusion buildingBlocksConclusion) {
        return new AcceptableBuildingBlockConclusionCheck<XmlCertificateQualificationProcess>(this.i18nProvider, (XmlCertificateQualificationProcess)this.result, buildingBlocksConclusion, this.getWarnLevelRule());
    }
}

