/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationIssuerTrustedCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final CertificateWrapper certificate;
    private final Date currentTime;
    private final LevelRule revocationIssuerSunsetDateConstraint;

    public RevocationIssuerTrustedCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, Date currentTime, LevelRule revocationIssuerSunsetDateConstraint, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.currentTime = currentTime;
        this.revocationIssuerSunsetDateConstraint = revocationIssuerSunsetDateConstraint;
    }

    @Override
    protected boolean process() {
        return this.certificate != null && ValidationProcessUtils.isTrustAnchor(this.certificate, this.currentTime, this.revocationIssuerSunsetDateConstraint);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_ICRDIT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_ICRDIT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return null;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.certificate != null) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_ID, this.certificate.getId());
        }
        return null;
    }
}

