/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationAfterCertificateIssuanceCheck
extends ChainItem<XmlRAC> {
    private final CertificateWrapper certificate;
    private final RevocationWrapper revocationData;

    public RevocationAfterCertificateIssuanceCheck(I18nProvider i18nProvider, XmlRAC result, CertificateWrapper certificate, RevocationWrapper revocationData, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.revocationData = revocationData;
    }

    @Override
    protected boolean process() {
        Date certNotBefore = this.certificate.getNotBefore();
        Date thisUpdate = this.revocationData.getThisUpdate();
        return certNotBefore != null && thisUpdate != null && certNotBefore.compareTo(thisUpdate) <= 0;
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_INFO, ValidationProcessUtils.getFormattedDate(this.revocationData.getThisUpdate()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter()));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_REVOC_AFTER_CERT_NOT_BEFORE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_REVOC_AFTER_CERT_NOT_BEFORE_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

