/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlStatus;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.DigestAlgorithmCryptographicChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class SigningCertificateRefDigestAlgorithmCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final List<CertificateRefWrapper> certificateRefs;
    private final String certificateId;
    private final Date validationDate;
    private final Context context;
    private final SubContext subContext;
    private final ValidationPolicy validationPolicy;
    private final LevelRule constraint;
    private XmlCC cryptographicValidationResult;

    public SigningCertificateRefDigestAlgorithmCheck(I18nProvider i18nProvider, T result, Date validationDate, List<CertificateRefWrapper> certificateRefs, String certificateId, Context context, SubContext subContext, ValidationPolicy validationPolicy, LevelRule constraint) {
        super(i18nProvider, result, constraint, certificateId);
        this.certificateRefs = certificateRefs;
        this.certificateId = certificateId;
        this.validationPolicy = validationPolicy;
        this.validationDate = validationDate;
        this.context = context;
        this.subContext = subContext;
        this.constraint = constraint;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.AOV_XCV;
    }

    @Override
    protected boolean process() {
        XmlCC ccResult = this.validateCertReferences();
        return ccResult != null && this.isValid(ccResult);
    }

    protected XmlCC validateCertReferences() {
        if (this.cryptographicValidationResult != null) {
            return this.cryptographicValidationResult;
        }
        for (CertificateRefWrapper certificateRefWrapper : this.certificateRefs) {
            DigestAlgorithm digestAlgorithm = certificateRefWrapper.getDigestMethod();
            if (digestAlgorithm == null) continue;
            XmlCC dacResult = this.getSigningCertificateDigestCryptographicCheckResult(certificateRefWrapper);
            if (this.cryptographicValidationResult == null || !this.isValid(this.cryptographicValidationResult)) {
                this.cryptographicValidationResult = dacResult;
            }
            if (!this.isValid(this.cryptographicValidationResult)) continue;
            break;
        }
        return this.cryptographicValidationResult;
    }

    private XmlCC getSigningCertificateDigestCryptographicCheckResult(CertificateRefWrapper certificateRef) {
        CryptographicSuite certificateConstraint = this.validationPolicy.getCertificateCryptographicConstraint(this.context, this.subContext);
        DigestAlgorithmCryptographicChecker dac = new DigestAlgorithmCryptographicChecker(this.i18nProvider, certificateRef.getDigestMethod(), this.validationDate, MessageTag.ACCM_POS_SIG_CERT_REF, certificateConstraint);
        return (XmlCC)dac.execute();
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ACCM, new Object[]{MessageTag.ACCM_POS_SIG_CERT_REF});
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.extractXmlMessage();
    }

    protected String getErrorMessage() {
        XmlMessage errorMessage = this.buildErrorMessage();
        return errorMessage != null ? errorMessage.getValue() : "";
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        if (this.cryptographicValidationResult != null) {
            return this.cryptographicValidationResult.getConclusion().getIndication();
        }
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        if (this.cryptographicValidationResult != null) {
            return this.cryptographicValidationResult.getConclusion().getSubIndication();
        }
        return SubIndication.CRYPTO_CONSTRAINTS_FAILURE;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.isValid(this.cryptographicValidationResult)) {
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_DM_WITH_ID, new Object[]{this.cryptographicValidationResult.getCryptographicValidation().getAlgorithm().getName(), dateTime, MessageTag.ACCM_POS_SIG_CERT_REF, this.certificateId});
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_ID, new Object[]{this.getErrorMessage(), dateTime, MessageTag.ACCM_POS_SIG_CERT_REF, this.certificateId});
    }

    @Override
    protected List<XmlMessage> getPreviousErrors() {
        if (this.cryptographicValidationResult != null) {
            return this.cryptographicValidationResult.getConclusion().getErrors();
        }
        return Collections.emptyList();
    }

    @Override
    protected Level getLevel() {
        if (this.constraint != null) {
            Level currentConstraintLevel = this.constraint.getLevel();
            Level subProcessLevel = this.getSubProcessLevel();
            return this.getLowestLevel(currentConstraintLevel, subProcessLevel);
        }
        return null;
    }

    private Level getSubProcessLevel() {
        XmlConclusion conclusion = this.getCryptographicValidationResult().getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty(conclusion.getErrors())) {
                return Level.FAIL;
            }
            if (Utils.isCollectionNotEmpty(conclusion.getWarnings())) {
                return Level.WARN;
            }
            if (Utils.isCollectionNotEmpty(conclusion.getInfos())) {
                return Level.INFORM;
            }
        }
        return null;
    }

    private Level getLowestLevel(Level currentLevel, Level subProcessLevel) {
        if (currentLevel == null) {
            return subProcessLevel;
        }
        if (subProcessLevel == null) {
            return currentLevel;
        }
        if (Level.INFORM == currentLevel || Level.INFORM == subProcessLevel) {
            return Level.INFORM;
        }
        if (Level.WARN == currentLevel || Level.WARN == subProcessLevel) {
            return Level.WARN;
        }
        if (Level.FAIL == currentLevel || Level.FAIL == subProcessLevel) {
            return Level.FAIL;
        }
        return currentLevel;
    }

    private XmlMessage extractXmlMessage() {
        XmlConclusion conclusion = this.cryptographicValidationResult.getConclusion();
        if (conclusion != null) {
            ArrayList<XmlMessage> messages = new ArrayList<XmlMessage>();
            switch (this.getLevel()) {
                case INFORM: {
                    messages.addAll(conclusion.getInfos());
                    messages.addAll(conclusion.getWarnings());
                    messages.addAll(conclusion.getErrors());
                    break;
                }
                case WARN: {
                    messages.addAll(conclusion.getWarnings());
                    messages.addAll(conclusion.getErrors());
                    break;
                }
                case FAIL: {
                    messages.addAll(conclusion.getErrors());
                    break;
                }
            }
            if (Utils.isCollectionNotEmpty(messages)) {
                return (XmlMessage)messages.iterator().next();
            }
        }
        return null;
    }

    @Override
    protected boolean isValid(XmlConstraintsConclusion constraintConclusion) {
        return super.isValid(constraintConclusion) && this.allConstraintsValid(constraintConclusion);
    }

    private boolean allConstraintsValid(XmlConstraintsConclusion result) {
        List<XmlConstraint> constraints = result.getConstraint();
        if (Utils.isCollectionNotEmpty(constraints)) {
            for (XmlConstraint constraint : constraints) {
                if (XmlStatus.OK.equals((Object)constraint.getStatus()) || XmlStatus.IGNORED.equals((Object)constraint.getStatus())) continue;
                return false;
            }
        }
        return true;
    }

    public XmlCC getCryptographicValidationResult() {
        return this.validateCertReferences();
    }
}

