/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.DigestAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.SignatureAlgorithmCryptographicChecker;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.SignatureAlgorithmCryptographicCheckerResultCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class TokenAlgorithmObsolescenceValidation<T extends TokenProxy>
extends DigestAlgorithmObsolescenceValidation<T> {
    protected TokenAlgorithmObsolescenceValidation(I18nProvider i18nProvider, T token, Context context, Date validationDate, ValidationPolicy validationPolicy) {
        super(i18nProvider, token, context, validationDate, validationPolicy);
    }

    @Override
    protected ChainItem<XmlAOV> buildChain() {
        return this.buildSignatureValidationChain(this.firstItem);
    }

    protected ChainItem<XmlAOV> buildSignatureValidationChain(ChainItem<XmlAOV> item) {
        SignatureAlgorithmCryptographicChecker cc = new SignatureAlgorithmCryptographicChecker(this.i18nProvider, ((TokenProxy)this.token).getSignatureAlgorithm(), ((TokenProxy)this.token).getKeyLengthUsedToSignThisToken(), this.validationDate, this.position, this.cryptographicSuite);
        XmlCC ccResult = (XmlCC)cc.execute();
        if (item == null) {
            this.firstItem = this.signatureAlgorithmCryptographicCheckResult(ccResult, this.position, this.cryptographicSuite);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.signatureAlgorithmCryptographicCheckResult(ccResult, this.position, this.cryptographicSuite));
        }
        this.signatureCryptographicValidation = ccResult.getCryptographicValidation();
        if (this.signatureCryptographicValidation != null) {
            this.signatureCryptographicValidation.setTokenId(((TokenProxy)this.token).getId());
        }
        return item;
    }

    protected ChainItem<XmlAOV> buildCertificateChainValidationChain(ChainItem<XmlAOV> item, CertificateWrapper signingCertificate, List<CertificateWrapper> certificateChain) {
        SubContext subContext;
        CertificateWrapper certificate;
        if (signingCertificate == null) {
            return item;
        }
        this.certificateChainCryptographicValidation = new ArrayList();
        Iterator<CertificateWrapper> iterator2 = certificateChain.iterator();
        while (iterator2.hasNext() && !this.isTrustAnchor(certificate, subContext = signingCertificate.equals(certificate = iterator2.next()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE)) {
            CryptographicSuite certificateCryptographicSuite = this.validationPolicy.getCertificateCryptographicConstraint(this.context, subContext);
            MessageTag certificatePosition = ValidationProcessUtils.getSubContextPosition(this.context, subContext);
            SignatureAlgorithmCryptographicChecker cc = new SignatureAlgorithmCryptographicChecker(this.i18nProvider, certificate.getSignatureAlgorithm(), certificate.getKeyLengthUsedToSignThisToken(), this.validationDate, certificatePosition, certificateCryptographicSuite);
            XmlCC ccResult = (XmlCC)cc.execute();
            if (item == null) {
                this.firstItem = this.signatureAlgorithmCryptographicCheckResult(ccResult, certificatePosition, certificateCryptographicSuite, certificate.getId());
                item = this.firstItem;
            } else {
                item = item.setNextItem(this.signatureAlgorithmCryptographicCheckResult(ccResult, certificatePosition, certificateCryptographicSuite, certificate.getId()));
            }
            XmlCryptographicValidation certificateCryptographicValidation = ccResult.getCryptographicValidation();
            certificateCryptographicValidation.setTokenId(certificate.getId());
            this.certificateChainCryptographicValidation.add(certificateCryptographicValidation);
        }
        return item;
    }

    private ChainItem<XmlAOV> signatureAlgorithmCryptographicCheckResult(XmlCC ccResult, MessageTag position, CryptographicSuite cryptographicSuite) {
        return new SignatureAlgorithmCryptographicCheckerResultCheck<XmlAOV>(this.i18nProvider, (XmlAOV)this.result, this.validationDate, position, ccResult, cryptographicSuite);
    }

    private ChainItem<XmlAOV> signatureAlgorithmCryptographicCheckResult(XmlCC ccResult, MessageTag position, CryptographicSuite cryptographicSuite, String tokenId) {
        return new SignatureAlgorithmCryptographicCheckerResultCheck<XmlAOV>(this.i18nProvider, (XmlAOV)this.result, this.validationDate, Context.CERTIFICATE, position, ccResult, cryptographicSuite, tokenId);
    }

    private boolean isTrustAnchor(CertificateWrapper certificateWrapper, SubContext subContext) {
        LevelRule constraint = this.validationPolicy.getCertificateSunsetDateConstraint(this.context, subContext);
        return ValidationProcessUtils.isTrustAnchor(certificateWrapper, this.validationDate, constraint);
    }
}

